/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * The Label is used to display INI keys, but can also stand alone.
 */

#ifndef LABEL_H
#define LABEL_H

#include "Atomic.h"

#include <QLabel>
#include <QString>
#include <QTextEdit>
#include <QWidget>
#include <QtXml>

class Label : public Atomic {
	Q_OBJECT

	public:
		explicit Label(const QString &section, const QString &key, const QDomNode &options,
		    const bool &no_spacers, const QString &caption = QString(), QWidget *parent = nullptr);
		bool isEmpty();

	private:
		int getColumnWidth(const QString &text, const int& min_width);

		QLabel *label_ = nullptr;
		QTextEdit *textbox_ = nullptr;

};

#endif //LABEL_H
