#!/bin/bash

cd ..
make
cd tests

echo -e "\n---------- Starting INIshell. This is its output:\n"
../build/inishell -i unit_test_inireader.ini -o unit_test_inireader_output.ini

difference=$(diff "unit_test_inireader_output.ini" "unit_test_inireader_expected_result.ini")

if [ -z "$difference" ]; then
      echo  "---------- All ok for the INI parser."
else
      echo "[E] The ini reader did not produce the expected result! Difference:"
      echo "$difference"
fi

echo -e "\n- Starting memory check for minimal program\n"
cd memory
qmake minimal.pro
make
valgrind ./minimal
