/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * This file handles the program dimensions including time.
 * The goal is a framework that scales well, i. e. can be enhanced for more complex
 * feautures (store settings, mobile, ...)
 * 2019-10
 */

#ifndef DIMENSIONS_H
#define DIMENSIONS_H

#include <QGuiApplication>
#include <QScreen>
#include <QWidget>

namespace dim {

enum prop {
	def_width,
	def_height,
	min_width,
	min_height
};

class ScreenSize {
	public:
		ScreenSize();
		size_t getHeight() const;
		size_t getWidth() const;

	private:
		QRect screen_size_;
};

struct Dimension {
	public:
		Dimension(const size_t &dw, const size_t &dh, const size_t &mw, const size_t& mh)
		    : def_width_(dw), def_height_(dh), min_width_(mw), min_height_(mh) {}
		size_t getProportion(const prop &proportion) const;

	private:
		size_t def_width_, def_height_;
		size_t min_width_, min_height_;
};

class MainDimension {
	public:
		MainDimension(const ScreenSize &screen);
		Dimension getDimension() const { return dim_; }

	private:
		Dimension dim_;
};

class LogDimension {
	public:
		LogDimension(const ScreenSize &screen);
		Dimension getDimension() const { return dim_; }

	private:
		Dimension dim_;
};

template <class T>
inline void setSize(T *widget, const Dimension &dim)
{
	widget->resize(dim.getProportion(def_width), dim.getProportion(def_height));
	widget->setMinimumSize(dim.getProportion(min_width), dim.getProportion(min_height));
}

} //end namespace

#endif //DIMENSIONS_H
