////////////////////////////////////////
///          TEXT panel              ///
////////////////////////////////////////

#include "Textfield.h"
#include "Label.h"

#include <QHBoxLayout>

#ifdef DEBUG
	#include <iostream>
#endif //def DEBUG

/**
 * @class Textfield
 * @brief Default constructor for a Textfield.
 * @details A Textfield is used to enter plain text.
 * @param[in] key INI key corresponding to the value that is being controlled by this Textfield.
 * @param[in] options XML node responsible for this panel with all options and children.
 * @param[in] no_spacers Keep a tight layout for this panel.
 * @param[in] parent The parent widget.
 */
Textfield::Textfield(const QString &section, const QString &key, const QDomNode &options, const bool &no_spacers,
    QWidget *parent) : Atomic(section, key, parent)
{
	/* label and text box */
	auto *key_label = new Label(section_, "_textfield_key_" + key_, options, no_spacers, key_);
	textfield_ = new QLineEdit; //single line text box
	setPrimaryWidget(textfield_);
	auto *textfield_layout = new QHBoxLayout;
	setLayoutMargins(textfield_layout);
	textfield_layout->addWidget(key_label, 0, Qt::AlignLeft);
	textfield_layout->addWidget(textfield_, 0);

	/* choose size of text box */
	const QString size(options.toElement().attribute("size"));
	if (size.toLower() == "medium")
		textfield_->setMinimumWidth(Cst::medium_textbox_width);
	else
		textfield_->setMinimumWidth(Cst::tiny);
	if (!no_spacers && size.toLower() != "large") //"large": text box extends to window width
		textfield_layout->addSpacerItem(buildSpacer());

	addHelp(textfield_layout, options);
	this->setLayout(textfield_layout);

	setOptions(options);
}

bool Textfield::setOptions(const QDomNode &/*options*/)
{
	connect(textfield_, &QLineEdit::textEdited, this, &Textfield::checkValue);
	return true;
}

void Textfield::onPropertySet()
{
	const QString text_to_set = this->property("ini_value").toString();
	textfield_->setText(text_to_set);
	checkValue(text_to_set);
}

void Textfield::checkValue(const QString &text)
{
	setDefaultPanelStyles(text);
	setIniValue(text);
}
