#ifndef SELECTOR_H
#define SELECTOR_H

#include "Atomic.h"
#include "Group.h"

#include <QComboBox>
#include <QString>
#include <QWidget>
#include <QtXml>

#include <map>

class Selector : public Atomic {
	Q_OBJECT

	public:
		explicit Selector(const QString &section, const QString &key, const QDomNode &options,
		    const bool &no_spacers, QWidget *parent = nullptr);
		void iniAddPanel(const QString &param_text);

	private:
		bool setOptions(const QDomNode &options);
		void addPanel(const QString &param_text);
		QComboBox *dropdown_ = nullptr;
		Group *container_ = nullptr;
		QDomNode templ_;
		std::map<QString, Group *> container_map_;

	private slots:
		void guiAddPanel();
		void removePanel();
		void onPropertySet() override;
};

#endif // SELECTOR_H
