#ifndef REPLICATOR_H
#define REPLICATOR_H

#include "Atomic.h"
#include "Group.h"

#include <QString>
#include <QWidget>
#include <QtXml>

class Replicator : public Atomic {
	Q_OBJECT

	public:
		explicit Replicator(const QString &section, const QString &key, const QDomNode &options,
		    const bool &no_spacers, QWidget *parent = nullptr);

	private:
		bool setOptions(const QDomNode &options);
		Group *container_ = nullptr;
		QDomNode templ_;
		int element_counter_ = 0;

	private slots:
		void replicate();
		void deleteLast();
		void onPropertySet() override; //TODO: instead of virtual

};
#endif // REPLICATOR_H
