#ifndef NUMBER_H
#define NUMBER_H

#include "Atomic.h"

#include <QAbstractSpinBox>
#include <QHBoxLayout>
#include <QLineEdit>
#include <QString>
#include <QToolButton>
#include <QWidget>
#include <QtXml>

class Number : public Atomic {
	Q_OBJECT

	public:
		explicit Number(const QString &section, const QString &key, const QDomNode &options,
		    const bool &no_spacers, QWidget *parent = nullptr);

	private:
		enum number_mode {
			NR_DECIMAL,
			NR_INTEGER,
			NR_INTEGERPLUS,
		};
		number_mode mode_;
		bool setOptions(const QDomNode &options);
		QAbstractSpinBox *number_element_ = nullptr;
		QLineEdit *expression_element_ = nullptr;
		QHBoxLayout *switcher_layout_ = nullptr;
		QToolButton *switch_button_ = nullptr;

	private slots:
		void checkValue(const double &to_check);
		void checkValue(const int &to_check);
		void checkStrValue(const QString &str_check);
		bool isExpression(const QString &expression) const;
		virtual void onPropertySet();
		void switchToggle(bool checked);
};

#endif //NUMBER_H
