#ifndef HELPTEXT_H
#define HELPTEXT_H

#include <QLabel>
#include <QString>

class Helptext : public QLabel {
	Q_OBJECT

	public:
		explicit Helptext(const QString &text, const bool &single_line, QWidget *parent = nullptr);
		void updateText(const QString &text);

	private:
		int getMinTextSize(const QString &text, const int &standard_width);
		QLabel *help_ = nullptr;
};
#endif // HELPTEXT_H
