#ifndef GROUP_H
#define GROUP_H

#include "Atomic.h"

#include <QGridLayout>
#include <QGroupBox>
#include <QString>
#include <QWidget>
#include <QVBoxLayout>

class Group : public Atomic {
	Q_OBJECT

	public:
		explicit Group(const QString &section, const QString &key, const bool &has_border = false,
		    const bool &grid_layout = false, const bool &is_frame = false, const bool &tight = false,
		    const QString &caption = QString(),
		    QWidget *parent = nullptr);
		void addWidget(QWidget *widget); //for vertical layout
		void addWidget(QWidget *widget, int row, int column, int rowSpan = 1, int columnSpan = 1,
		    Qt::Alignment alignment = Qt::Alignment()); //for grid layout
		QLayout * getLayout() const { return layout_; }

		QGridLayout * getGridLayout() const { return qobject_cast<QGridLayout *>(layout_); }
		void erase();
		int count() const;
		bool isEmpty() const;
		bool hasVisibleChildren() const;

	private:
		QGroupBox *box_ = nullptr;
		QLayout *layout_ = nullptr;
};

#endif //GROUP_H
