#ifndef FILEPATH_H
#define FILEPATH_H

#include "Atomic.h"

#include <QLabel>
#include <QLineEdit>
#include <QString>
#include <QWidget>
#include <QtXml>

class FilePath : public Atomic {
	Q_OBJECT

	public:
		explicit FilePath(const QString &section, const QString &key, const QDomNode &options,
		    const bool &no_spacers, QWidget *parent = nullptr);

	private:
		bool setOptions(const QDomNode &options);
		QLineEdit *path_text_ = nullptr;
		QLabel *info_text_ = nullptr;
		bool path_only_ = false;
		QString extensions_ = "";

	private slots:
		void openFile();
		virtual void onPropertySet();
		void checkValue(const QString &filename);
};

#endif //FILEPATH_H
