#include "PreviewWindow.h"
#include "src/main/inishell.h"

#include <QVBoxLayout>

SyntaxHighlighter::SyntaxHighlighter(QTextDocument *textdoc) : QSyntaxHighlighter(textdoc)
{
	HighlightingRule rule;

	QTextCharFormat format_section;
	format_section.setForeground(Qt::darkRed);
	format_section.setFontWeight(QFont::Bold);
	rule.pattern = QRegularExpression(R"(.*\[.*\].*)");
	rule.format = format_section;
	rules_.append(rule);

	QTextCharFormat format_key;
	format_key.setForeground(Qt::darkGreen);
	rule.pattern = QRegularExpression(R"(.*=)");
	rule.format = format_key;
	rules_.append(rule);

	QTextCharFormat format_value;
	format_key.setForeground(Qt::blue);
	rule.pattern = QRegularExpression(R"(=.*)");
	rule.format = format_key;
	rules_.append(rule);
}

void SyntaxHighlighter::highlightBlock(const QString &text)
{
	for (const HighlightingRule &rule : qAsConst(rules_)) {
		QRegularExpressionMatchIterator mit = rule.pattern.globalMatch(text);
		while (mit.hasNext()) {
			QRegularExpressionMatch match = mit.next();
			setFormat(match.capturedStart(), match.capturedLength(), rule.format);
		}
	}
}

PreviewWindow::PreviewWindow(QWidget *parent) : QWidget(parent, Qt::Window)
{
	auto *main_layout = new QVBoxLayout;
	file_tabs_ = new QTabWidget;
	file_tabs_->setTabsClosable(true);
	main_layout->addWidget(file_tabs_);
	this->setLayout(main_layout);
}

void PreviewWindow::addIniTab()
{
	auto *preview_editor = new QTextEdit;
	highlighter_ = new SyntaxHighlighter(preview_editor->document());

	QString ini_contents;
	QTextStream ss(&ini_contents);
	getMainWindow()->getIni()->outputIni(ss);

	preview_editor->setPlainText(ini_contents);
	file_tabs_->addTab(preview_editor, getMainWindow()->getIni()->getFilename());
}
