/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * The main program window.
 * Every widget that has this as ancestor will be destroyed when the application quits.
 * 2019-10
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "Logger.h"
#include "src/gui/MainPanel.h"
#include "src/gui/PreviewWindow.h"
#include "src/main/constants.h"
#include "src/main/INIParser.h"

#include <QIcon>
#include <QLabel>
#include <QMainWindow>
#include <QString>
#include <QTabBar>
#include <QTimer>
#include <QtXml>
#include <QWidgetList>

class MainWindow : public QMainWindow {
	Q_OBJECT //Qt macro to make code g++ ready

	public:
		explicit MainWindow(QDomDocument &xml_settings, QMainWindow *parent = nullptr);
		~MainWindow();
		void buildGui(const QDomDocument &xml);
		bool setGuiFromIni(const INIParser &ini);
		MainPanel * getControlPanel() const { return control_panel_; }
		void setStatus(const QString &message, const QString &color = "black", const bool &status_light = false,
		    const int &time = -1);
		void setStatusLight(const bool &on);
		void log(const QString &message, const QString &color = "black") { logger_.log(message, color); }
		INIParser * getIni() { return &ini_; }

	private:
		void createMenu();
		void createToolbar();
		void createStatusbar();
		QWidgetList findPanel(QWidget *parent, const Section &section, const KeyValue &keyval);
		QWidgetList findSimplePanel(QWidget *parent, const Section &section, const KeyValue &keyval);
		QWidgetList prepareSelector(QWidget *parent, const Section &section, const KeyValue &keyval);
		QWidgetList prepareReplicator(QWidget *parent, const Section &section, const KeyValue &keyval);
		bool saveIni();

		QToolBar *toolbar_ = nullptr; //init against warnings
		MainPanel *control_panel_ = nullptr;
		PreviewWindow *preview_ = nullptr;
		Logger logger_;
		INIParser ini_;
		QDomDocument &xml_settings_;
		QLabel *status_label_ = nullptr;
		QLabel *status_icon_ = nullptr;
		QTimer status_timer_;

	private slots:
		void clearStatus();
		void quitProgram();
		void viewPreview();
		void viewLogger();
		void viewSettings();
		void helpAbout();
		void toolbarClick(const QString &function);
};

#endif //MAINWINDOW_H
