/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

#include "dimensions.h"
#include "constants.h"

namespace dim {

ScreenSize::ScreenSize() : screen_size_(0, 0, 0, 0)
{
	QScreen *screen = QGuiApplication::primaryScreen();
	screen_size_ = screen->geometry();
}

size_t ScreenSize::getWidth() const
{
	return static_cast<size_t>(screen_size_.width());
}

size_t ScreenSize::getHeight() const
{
	return static_cast<size_t>(screen_size_.height());
}

size_t Dimension::getProportion(const prop &proportion) const
{
	switch (proportion) {
	case def_width:
		return def_width_;
	case def_height:
		return def_height_;
	case min_width:
		return min_width_;
	case min_height:
		return min_height_;
	}
	return Cst::npos; //should not be reachable
}

MainDimension::MainDimension(const ScreenSize &screen) :
    dim_(screen.getWidth() / 2, screen.getHeight() / 2, Cst::inishell_min_width, Cst::inishell_min_height)
{
	//do nothing
}

LogDimension::LogDimension(const ScreenSize &screen) :
    dim_(screen.getWidth() / 3, screen.getHeight() / 3, Cst::logger_min_width, Cst::logger_min_height)
{
	//do nothing
}

} //end namespace
