#ifndef TEXTFIELD_H
#define TEXTFIELD_H

#include "Atomic.h"

#include <QLineEdit>
#include <QString>
#include <QWidget>
#include <QtXml>

class Textfield : public Atomic {
	Q_OBJECT

	public:
		explicit Textfield(const QString &section, const QString &key, const QDomNode &options,
		    const bool &no_spacers, QWidget *parent = nullptr);

	private:
		bool setOptions(const QDomNode &options);
		QLineEdit *textfield_ = nullptr;

	private slots:
		void onPropertySet() override;
		void checkValue(const QString &text);
};

#endif // TEXTFIELD_H
