////////////////////////////////////////
///           GRID raster            ///
////////////////////////////////////////

#include "GridPanel.h"
#include "src/main/inishell.h"

/**
 * @class GridPanel
 * @brief Default constructor for a GridPanel.
 * @details A GridPanel is a simple grid layout that organizes child widgets on a raster. The children
 * are given enclosed in <option> tags in the XML file.
 * @param[in] section The INI section is set for style targeting.
 * @param[in] key INI key is used for an optional label and ignored otherwise.
 * @param[in] options XML node responsible for this panel with all desired children.
 * @param[in] parent The parent widget.
 */
GridPanel::GridPanel(const QString &section, const QString &key, const QDomNode &options, QWidget *parent)
    : Atomic(section, key, parent)
{
	grid_layout_ = new QGridLayout; //only holds a grid layout for child panels
	setLayoutMargins(grid_layout_);
	this->setLayout(grid_layout_);
	setOptions(options); //construct children
}

/**
 * @brief Parse options for a GridPanel from XML.
 * @param[in] options XML node holding the GridPanel.
 * @return True if all options were set successfully.
 */
bool GridPanel::setOptions(const QDomNode &options)
{
//	if (!key_.isEmpty()) {
//		auto *key_label = new Label(section_, "_grid_label_" + key_, options, true, key_);
//		grid_layout_->addWidget(key_label, 0, 0, Qt::AlignVCenter | Qt::AlignLeft);
//	}
	//construct all child elements:
	for (QDomElement op = options.firstChildElement("option"); !op.isNull(); op = op.nextSiblingElement("option")) {
		substituteKeys(op, "@", this->key_ + Cst::sep);
		auto *item_group = new Group(section_, "_grid_itemgroup_" + key_);
		recursiveBuild(op, item_group, section_, true); //recursive build with horizontal space savings
		const int row = op.attribute("row").toInt() - 1; //indices start at 1 in XML file
		const int column = op.attribute("column").toInt() - 1; //TODO: safechecks
		grid_layout_->addWidget(item_group, row, column, Qt::AlignVCenter | Qt::AlignLeft);
	}
	return true;
}
