#ifndef DROPDOWN_H
#define DROPDOWN_H

#include "Atomic.h"
#include "Group.h"

#include <QComboBox>
#include <QString>
#include <QWidget>
#include <QtXml>

class Dropdown : public Atomic {
	Q_OBJECT

	public:
		explicit Dropdown(const QString &section, const QString &key, const QDomNode &options,
		    const bool &no_spacers, QWidget *parent = nullptr);
		Group * getContainer() const { return container_; }

	private:
		bool setOptions(const QDomNode &options);
		QComboBox *dropdown_ = nullptr;
		Group *container_ = nullptr;

	private slots:
		void itemChanged(int index);
		void onPropertySet() override;
};

#endif // DROPDOWN_H
