#ifndef CHOICE_H
#define CHOICE_H

#include "Atomic.h"
#include "Group.h"

#include <QCheckBox>
#include <QString>
#include <QtXml>

class Choice : public Atomic {
	Q_OBJECT

	public:
		explicit Choice(const QString &section, const QString &key, const QDomNode &options,
		    const bool &no_spacers, QWidget *parent = nullptr);

	private:
		bool setOptions(const QDomNode &options);
		QCheckBox *checkbox_ = nullptr;
		Group * checkbox_container_ = nullptr;
		Group * child_container_ = nullptr;

	private slots:
		void changedState(int index);
		void onPropertySet() override;
};

#endif // CHOICE_H
