#ifndef PREVIEWWINDOW_H
#define PREVIEWWINDOW_H

#include <QRegularExpression>
#include <QSyntaxHighlighter>
#include <QTabWidget>
#include <QTextDocument>
#include <QTextEdit>
#include <QVector>
#include <QWidget>

class SyntaxHighlighter : public QSyntaxHighlighter
{
	Q_OBJECT

	public:
		SyntaxHighlighter(QTextDocument *textdoc = nullptr);

	protected:
		void highlightBlock(const QString &text) override;

	private:
		struct HighlightingRule {
			QRegularExpression pattern;
			QTextCharFormat format;
		};
		QVector<HighlightingRule> rules_;
};

class PreviewWindow : public QWidget {
	public:
		explicit PreviewWindow(QWidget *parent = nullptr);
		void addIniTab();
		int count() const { return file_tabs_->count(); }

	private:
		QTabWidget *file_tabs_ = nullptr;
		SyntaxHighlighter *highlighter_ = nullptr;
};

#endif //PREVIEWWINDOW_H
