#include "AboutWindow.h"
#include "src/main/constants.h"
#include "src/main/Error.h"

#include <QFile>
#include <QTextBrowser>
#include <QVBoxLayout>

AboutWindow::AboutWindow(QWidget *parent) : QWidget(parent, Qt::Window)
{
	auto *textbox = new QTextBrowser;
	textbox->setReadOnly(true);
	textbox->setTextInteractionFlags(Qt::TextBrowserInteraction);
	textbox->setOpenExternalLinks(true);

	QFile about(":about.html");
	if (!about.open(QIODevice::ReadOnly))
		Error(tr("About text can not be loaded."));
	textbox->setHtml(about.readAll());

	auto *main_layout = new QVBoxLayout;
	main_layout->addWidget(textbox);
	this->setLayout(main_layout);

	this->setFixedSize(Cst::help_about_width, Cst::help_about_height);
}
