/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

#include "dimensions.h"
#include "constants.h"

#include <QGuiApplication>

namespace dim {

void setDimensions(QWidget *window, const window_type &type)
{
	//TODO: restore
	QScreen *screen_object = QGuiApplication::primaryScreen();
	QSize screen(screen_object->geometry().width(), screen_object->geometry().height());

	prop size;
	double factor;

	switch (type) {
	case MAIN_WINDOW:
		size.def_width = Cst::width_inishell_default;
		size.min_width = Cst::width_inishell_min;
		size.def_height = Cst::height_inishell_default;
		size.min_height = Cst::height_inishell_min;
		factor = 2/3.;
		break;
	case LOGGER:
		size.def_width = Cst::width_logger_default_;
		size.min_width = Cst::width_logger_min_;
		size.def_height = Cst::height_logger_default;
		size.min_height = Cst::height_logger_min;
		factor = 1/3.;
		break;
	case PREVIEW:
		size.def_width = Cst::width_preview_default;
		size.min_width = Cst::tiny;
		size.def_height = Cst::height_preview_default;
		size.min_height = Cst::tiny;
		factor = 1/2.;
	}

	if (screen.width() < size.def_width)
		size.def_width = static_cast<int>(screen.width() * factor);
	if (screen.height() < size.def_height)
		size.def_height = static_cast<int>(screen.height() * factor);

	window->resize(size.def_width, size.def_height);
	window->setMinimumSize(size.min_width, size.min_height);
}


} //end namespace dim
