#ifndef COMMON_H
#define COMMON_H

#include <QtXmlPatterns/QAbstractMessageHandler>
#include <QString>
#include <QtXml>

/**
 * @struct CaseInsensitiveCompare
 * @brief A weak ordered comparison struct for case insensitive key-value mapping.
 */
struct CaseInsensitiveCompare {
	bool operator() (const QString &first_str, const QString &second_str) const
	{ //<0: less than; =0: equal; >0: greater than; STL comparison is done via a less-type operator
		return (QString::compare(first_str, second_str, Qt::CaseInsensitive) < 0);
	}
};

class MessageHandler : public QAbstractMessageHandler {
	public:
		MessageHandler() : QAbstractMessageHandler(nullptr) {}
		QString status() const { return description_; }
		int line() const { return static_cast<int>(location_.line()); }
		int column() const { return static_cast<int>(location_.column()); }

	protected:
		virtual void handleMessage(QtMsgType type, const QString &description,
		    const QUrl &identifier, const QSourceLocation &location);

	private:
		QString description_;
		QSourceLocation location_;
};

inline bool hasSectionSpecified(const QString &section, const QDomElement &options)
{
	if (!options.attribute("section").isNull())
		return (QString::compare(options.attribute("section"), section, Qt::CaseInsensitive) == 0);
	int counter = 0;
	for (QDomElement section_element = options.firstChildElement("section"); !section_element.isNull();
	    section_element = section_element.nextSiblingElement("section")) { //read all <section> tags
		counter++;
		if (QString::compare(section_element.attribute("name"), section, Qt::CaseInsensitive) == 0)
			return true;
	}
	if (counter == 0) //no section specified means all sections are good to go
		return true;
	return false;
}

#endif //COMMON_H
