/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * The top level XML interface.
 * This class is an XMLReader which reads from the file system into XML.
 * 2019-10
 */

#ifndef XMLREADER_H
#define XMLREADER_H

#include <QFile>
#include <QMap>
#include <QString>
#include <QtXml>

QDomNode prependParent(QDomNode &child);

class XMLReader {
	public:
		XMLReader() = default;
		XMLReader(const QString &filename, QString &xml_error);
		void read(QFile &file, QString &xml_error, const bool &is_settings_file = false);
		void read(const QString &filename, QString &xml_error, const bool &no_references = false);
		void parseReferences();
		void parseIncludes(QString &xml_error);
		QDomDocument getXml() const;

	private:
		void validateSchema(QString &xml_error);

		QString master_xml_path_;
		QDomDocument xml_;
};

#endif //XMLREADER_H
