/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * The left part of the main window with a list as a grouping element and a small info or settings
 * widget set atop.
 * 2019-10
 */

#ifndef WORKFLOW_H
#define WORKFLOW_H

#include "src/gui/ApplicationsView.h"
#include "src/gui/TerminalView.h"
#include "src/gui/FolderView.h"
#include "src/main/colors.h"

#include <QPushButton>
#include <QToolBox>
#include <QWidget>
#include <QtXml>

namespace html {

QString bold(const QString &text);
QString color(const QString &text, const QString &color);

} //namespace html

class WorkflowPanel : public QWidget {
	Q_OBJECT

	public:
		explicit WorkflowPanel(QWidget *parent = nullptr);
		void buildWorkflowPanel(const QDomDocument &xml);
		void clearXmlPanels();
		QString getCurrentApplication() const;
		FolderView * getFilesystemView() const { return filesystem_; }
//		QSize sizeHint() const override;

	private:
		void buildWorkflowSection(QDomElement &element);
		QWidget * workflowElementFactory(QDomElement &item);
		QString parseCommand(const QString &action);
		QString getWidgetValue(QWidget *widget) const;
		void processFinished(int exit_code, QProcess::ExitStatus exit_status, TerminalView *terminal);
		void processStandardOutput(TerminalView *terminal);
		void processStandardError(TerminalView *terminal);

		QToolBox *workflow_container_ = nullptr;
		ApplicationsView *applications_ = nullptr;
		FolderView *filesystem_ = nullptr;

	private slots:
		void buttonClicked(QPushButton *button, const QStringList &action_list);
		void toolboxClicked(int index);
};

#endif //WORKFLOW_H
