#include "TerminalView.h"
#include "src/main/inishell.h"

#include <QDir>
#include <QVBoxLayout>

TerminalView::TerminalView()
{
	console_ = new QTextEdit;
	console_->setReadOnly(true);
	log(html::color(html::bold("$ " + QDir::currentPath()), "sysinfo"));

	auto *main_layout = new QVBoxLayout;
	main_layout->addWidget(console_);
	this->setLayout(main_layout);
}

void TerminalView::log(const QString &text)
{
	console_->append(text);
}
