#ifndef PREVIEWWINDOW_H
#define PREVIEWWINDOW_H

#include <QMainWindow>
#include <QRegularExpression>
#include <QSyntaxHighlighter>
#include <QTabWidget>
#include <QTextDocument>
#include <QTextEdit>
#include <QVector>
#include <QWidget>

class SyntaxHighlighter : public QSyntaxHighlighter
{
	Q_OBJECT

	public:
		SyntaxHighlighter(QTextDocument *textdoc = nullptr);

	protected:
		void highlightBlock(const QString &text) override;

	private:
		struct HighlightingRule {
			QRegularExpression pattern;
			QTextCharFormat format;
		};
		QVector<HighlightingRule> rules_;
};

class PreviewWindow : public QMainWindow
{
	Q_OBJECT

	public:
		explicit PreviewWindow(QMainWindow *parent = nullptr);
		void addIniTab();
		int count() const { return file_tabs_->count(); }

	private:
		void closeTab(int index);
		void createMenu();

		QTabWidget *file_tabs_ = nullptr;
		SyntaxHighlighter *highlighter_ = nullptr;

	private slots:
		void saveFile();
		void saveFileAs();
};

#endif //PREVIEWWINDOW_H
