#ifndef FOLDERVIEW_H
#define FOLDERVIEW_H

#include <QFileSystemModel>
#include <QLabel>
#include <QStack>
#include <QString>
#include <QTreeView>
#include <QWidget>

class FolderView : public QWidget {
	Q_OBJECT

	public:
		explicit FolderView(QWidget *parent = nullptr);
		void setEnabled(const bool &enabled);

	private:
		void setTreeIndex(const QModelIndex &index, const bool &no_stack = false);

		QFileSystemModel *filesystem_model_ = nullptr;
		QTreeView *filesystem_tree_ = nullptr;
		QLabel *path_label_ = nullptr;
		QStack<QModelIndex> prev_index_stack_;

	private slots:
		void onFilesysDoubleclicked(const QModelIndex &index);
		void onUpClicked();
		void onHomeClicked();
		void onBackClicked();
		void onFavoriteClicked();
};

#endif //FOLDERVIEW_H
