#ifndef APPLICATIONSVIEW_H
#define APPLICATIONSVIEW_H

#include <QDir>
#include <QFile>
#include <QListWidget>
#include <QMenu>
#include <QPoint>
#include <QWidget>

class ApplicationsView : public QWidget {
	Q_OBJECT

	public:
		explicit ApplicationsView(QWidget *parent = nullptr);
		QString getCurrentApplication() const;

	private:
		void readAppsFromDir();
		void addApplication(const QFile &file, const QRegularExpressionMatch &match_inishell);
		void createContextMenu();

		QListWidget *application_list_ = nullptr;
		QDir application_dir_;
		QMenu list_context_menu_;

	private slots:
		void onListDoubleClick(QListWidgetItem *item);
		void showListContextMenu(const QPoint &coords);
};

#endif //APPLICATIONSVIEW_H
