/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * A Selector is a special panel that takes a widget in its options and reproduces a parametrized clone
 * of it. It is one of the few panels that must handle INI keys that aren't present in the XML
 * (although the main work for this is done in MainWindow.cc).
 * 2019-10
 */

#ifndef SELECTOR_H
#define SELECTOR_H

#include "Atomic.h"
#include "Group.h"
#include "src/main/common.h"

#include <QComboBox>
#include <QPushButton>
#include <QString>
#include <QWidget>
#include <QtXml>

#include <map>

class Selector : public Atomic {
	Q_OBJECT

	public:
		explicit Selector(const QString &section, const QString &key, const QDomNode &options,
		    const bool &no_spacers, QWidget *parent = nullptr);
		int count() const { return static_cast<int>(container_map_.size()); }
		void clear(const bool &set_default = true) override;

	private:
		void setOptions(const QDomNode &options);
		void addPanel(const QString &param_text);
		void removePanel(const QString &param_text);
		void prepareDropdownForSelector(const QDomNode &options);

		QComboBox *dropdown_ = nullptr;
		Group *container_ = nullptr;
		QDomNode templ_;
		std::map<QString, Group *, CaseInsensitiveCompare> container_map_;
		QPushButton *plus_button_ = nullptr;

	private slots:
		void guiAddPanel();
		void removeCurrentPanel();
		void onPropertySet() override;
};

#endif //SELECTOR_H
