/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

#include "MainList.h"
#include "src/main/constants.h"

#include <QGroupBox>
#include <QListWidget>
#include <QVBoxLayout>

MainList::MainList(QWidget *parent) : QWidget(parent)
{
	auto *info_box = new QGroupBox(this);
	info_box->setTitle(tr("Loaded file(s):"));

	auto *section_list = new QListWidget(this);
	new QListWidgetItem("Input", section_list);
	new QListWidgetItem("Filters", section_list);
	new QListWidgetItem("Output", section_list);
	new QListWidgetItem("Advanced", section_list);

	auto *layout = new QVBoxLayout(this);
	layout->addWidget(info_box, 100 - Cst::proportion_list_vertical_percent);
	layout->addWidget(section_list, Cst::proportion_list_vertical_percent);
	this->setLayout(layout);
}
