/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INISHELL_H
#define INISHELL_H

#include "src/gui/MainWindow.h"
#include "src/main/constants.h"

#include <QApplication>
#include <QString>
#include <QWidgetList>
#include <QtXml>

inline MainWindow* getMainWindow()
{
	const QWidgetList topLevel = QApplication::topLevelWidgets();
	for (QWidget *widget : topLevel) {
		auto *inishell_main = qobject_cast<MainWindow*>(widget);
		if (inishell_main) //cast successful - right window
			return inishell_main;
	}
	return nullptr;
}

inline void topStatus(const QString &message, const int &time = Cst::msg_length)
{ //access to status bar from parent-less objects
	MainWindow *inishell_main = getMainWindow();
	if(inishell_main != nullptr)
		inishell_main->setStatus(message, time);
}

inline void topLog(const QString &message, const QColor &color = Qt::black)
{ //access to logging window from parent-less objects
	MainWindow *inishell_main = getMainWindow();
	if(inishell_main != nullptr)
		inishell_main->log(message, color);
}

void recursiveBuild(const QDomNode &parent_node, Group *parent_group, const QString &parent_section, const bool& no_spacers = false);

#endif //INISHELL_H
