/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CONSTANTS_H
#define CONSTANTS_H

#include <QString>

#include <cstddef> //for size_t

using cfloat = double; //TODO: better place for everything

namespace Cst {

	/* main window */
	constexpr size_t inishell_min_width = 600;  //window size limits
	constexpr size_t inishell_min_height = 300;  //TODO: could depend on screen size and ratio
	constexpr size_t proportion_list_horizontal_percent = 20; //size of the left list
	constexpr size_t proportion_list_vertical_percent = 80;

	/* settings dialog window */
	static constexpr size_t settings_width = 600;
	static constexpr size_t settings_height = 400;
	static constexpr size_t settings_navigation_spacing = 20;
	static constexpr size_t settings_navigation_maxheight = 100;

	/* logger window */
	constexpr size_t logger_min_width = 300;  //window size limits
	constexpr size_t logger_min_height = 150;

	/* widgets */
	constexpr size_t tiny=100; //minimum width of (input) widgets, just to look less cramped
	constexpr size_t std_button_width = 25; //standard width of push button
	constexpr size_t std_button_height = 25;
	constexpr size_t medium_button_width = 35;

	/* panels */
	static constexpr int nr_items_visible = 5; //CHECKLIST panel
	static constexpr int safety_padding = 3;
	static constexpr size_t frame_vertical_margins = 10; //FRAME panel
	static constexpr size_t frame_horizontal_margins = 20;
	static constexpr int help_width = 350; //HELPTEXT panel
	static constexpr size_t help_font_size = 10;
	static constexpr size_t label_width = 150; //LABEL panel
	static constexpr int label_padding = 20; //safety margins to really display all text
	static constexpr size_t medium_textbox_width = 200; //TEXTFIELD panel

	/* static strings */
	const QString sep = "::";
	const QString section_open = "[";
	const QString section_close = "]";
	const QString default_section("General");

	/* time */
	constexpr size_t msg_length = 5000; //default ms for toolbar messages

	/* indices */
	constexpr size_t npos = static_cast<size_t>(-1);
} //end namespace

#endif //CONSTANTS_H
