/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

#include "colors.h"

namespace colors {

/**
 * @brief Get color for a specific event or item.
 * @param[in] INIshell's name for the color.
 * @return Qt usable color.
 */
QColor getQColor(const QString &colorname)
{
	QString name(colorname.toLower());

	/* substitutions */
	if (name == "criticalerror")
		name = "lightred";
	else if (name == "error")
		name = "red";
	else if (name == "fatalerror")
		name = "darkred";
	else if (name == "info")
		name = "blue";
	else if (name == "warning")
		name = "orange";
	else if (name == "helptext")
		name = "gray";
	else if (name == "key")
		name = "darkblue";
	else if (name == "groupborder")
		name = "lightblue";
	else if (name == "frameborder")
		name = "purple";
	else if (name == "frametitle")
		name = "purple";
	else if (name == "msg")
		return Qt::black;

	if (name == "darkred")
		return Qt::darkRed;
	else if (name == "blue")
		return Qt::blue;
	else if (name == "lightblue")
		return {220, 235, 250};
	else if (name == "darkblue")
		return {0, 0, 150};
	else if (name == "lightred")
		return {250, 105, 70};
	else if (name == "orange")
		return {250, 190, 0};
	else if (name == "red")
		return Qt::red;
	else if (name == "gray")
		return {100, 100, 100};
	else if (name == "purple")
		return {110, 40, 160};
	else
		return Qt::black;
}

} //namespace colors
