/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

#include "XMLReader.h"
#include "src/main/colors.h"
#include "src/main/inishell.h"

#include <QCoreApplication> //for translations

#ifdef DEBUG
	#include <iostream>
#endif

QDomNode prependParent(QDomNode &child)
{
	QByteArray parent_array("<dummy_parent></dummy_parent>");
	QDomDocument parent_doc;
	parent_doc.setContent(parent_array, false);
	parent_doc.firstChild().appendChild(child.cloneNode(true));
	return parent_doc.firstChild();
}

XMLReader::XMLReader(const QString &filename, QString &xml_error)
{
	this->read(filename, xml_error);
}

bool XMLReader::read(const QString &filename, QString &xml_error)
{
	QFile infile(filename);
	if (!infile.open(QIODevice::ReadOnly | QIODevice::Text))
		return false;
	const bool success = this->read(infile, xml_error);
	infile.close();
	return success;
}

bool XMLReader::read(QFile &file, QString &xml_error)
{
	QString error_msg;
	int error_line, error_column;
	if (!xml_.setContent(&file, false, &error_msg, &error_line, &error_column)) {
		xml_error = QString(QCoreApplication::tr(
		    "%1 (line %2, column %3)")).arg(error_msg).arg(error_line).arg(error_column);
		return false;
	}
	xml_error = QString();
	return true;
}

QDomDocument XMLReader::getXml() const
{
	return xml_;
}

/*
bool XMLReader::addXmlFile(const QString &filename)
{
	XMLReader xml;
	const bool success = xml.read(filename);
	if (success)
		all_xml_.insert(filename, xml);
	return success;
}
*/
