/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * INIshell's settings for the static part of the GUI.
 * 2019-10
 */

#ifndef SETTINGS_H
#define SETTINGS_H

#include <QButtonGroup>
#include <QListWidget>
#include <QStackedWidget>
#include <QWidget>
#include <QtXml>

#ifdef DEBUG
	#include <iostream>
#endif

struct command_line_args {
	public:
		QString startup_ini_file = "";
		QString settings_file = "";
};

class panelFiles : public QWidget {
	Q_OBJECT

	public:
		panelFiles(QWidget *parent = nullptr);
};

class panelInireader : public QWidget {
	Q_OBJECT

	public:
		panelInireader(QWidget *parent = nullptr);
};

class Settings : public QWidget {
	Q_OBJECT

	public:
		Settings(QWidget *parent = nullptr);

	public slots:
		void switchPanel(QListWidgetItem *current, QListWidgetItem *previous);
		void closeSettings();

	private:
		void buildNavigationList();
		QListWidget *navigation_list_ = nullptr;
		QStackedWidget *pages_ = nullptr;
};

void groupButtons(QButtonGroup &group, QWidget *parent);

inline QString getSetting(QDomDocument &settings, const QString &section, const QString &key)
{
	const QDomElement root = settings.firstChildElement(); //<inishell_settings>
	const QDomElement set = root.firstChildElement(section).firstChildElement(key);
	return set.attribute("value");
}

#endif //SETTINGS_H
