/*****************************************************************************/
/*  Copyright 2019 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with INIshell. If not, see <http://www.gnu.org/licenses/>.
*/

/*
 * The main program window.
 * Every widget that has this as ancestor will be destroyed when the application quits.
 * 2019-10
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "src/main/constants.h"
#include "src/main/INIParser.h"
#include "src/panels/MainPanel.h"

#include "Logger.h"
#include <QMainWindow>
#include <QTabBar>
#include <QtXml>

class MainWindow : public QMainWindow {
	Q_OBJECT //Qt macro to make code g++ ready

	public:
		explicit MainWindow(QDomDocument &xml_settings, QMainWindow *parent = nullptr);
		void buildGui(const QDomDocument &xml);
		MainPanel * getControlPanel() const { return control_panel_; }
		void setStatus(const QString &message, const int &time = Cst::msg_length); //for temporary messages only
		void log(const QString &message, const QColor &color = Qt::black) { logger_.log(message, color); }

	private:
		void createMenu();
		void createToolbar();

		QToolBar *toolbar_ = nullptr; //init against warnings
		MainPanel *control_panel_ = nullptr;
		Logger logger_;
		QDomDocument &xml_settings_;

	private slots:
		void quitProgram();
		void viewLogger();
		void viewSettings();
};

#endif //MAINWINDOW_H
