#ifndef SECTIONTAB_H
#define SECTIONTAB_H

#include <QList>
#include <QScrollArea>
#include <QString>
#include <QStringList>
#include <QTabWidget>
#include <QWidget>
#include <QtXml>

#include "src/gui_elements/Group.h"

class ScrollPanel : public QWidget {
	Q_OBJECT

	public:
		explicit ScrollPanel(const QString &tab_color, QWidget *parent = nullptr);
		Group * getGroup() const;
		void ensureWidgetVisible(QWidget *wid) { main_area_->ensureWidgetVisible(wid); }

	private:
		QScrollArea *main_area_ = nullptr;
		Group *main_group_ = nullptr;
};

class SectionTab : public QTabWidget {
	Q_OBJECT

	public:
		explicit SectionTab(QWidget *parent = nullptr);
		ScrollPanel * getSectionScrollArea(const QString &section, const QString &background_color = QString(),
			const QString &color = "normal", const bool &no_create = false, const int &insert_idx = -1);
		ScrollPanel * getSectionScrollArea(const int &index);
		void setSectionDynamic(const QString &section, const QDomNode &node); //register section as dynamic
		void spawnDynamicSection(const QString &section, const QString &new_name = QString()); //clone a section registered as dynamic
		ScrollPanel * tryDynamicSection(const QString &section);
		void removeDynamicSection(const QString &section);
		QStringList * getDynamicSectionList() { return &dynamic_sections_; }
		bool showTab(const QString &tab_name);
		bool showFrame(const QString &tab_name, const QString &frame_name);
		int getIndex(const QString &section, const Qt::CaseSensitivity &sensitivity = Qt::CaseInsensitive);
		void clear();

	private:
		QStringList dynamic_sections_;
		QList<QDomNode> dynamic_nodes_;
		QList<int> dynamic_running_indices_;
};

#endif //SECTIONTAB_H
