#ifndef HELPWINDOW_H
#define HELPWINDOW_H

#include <QMainWindow>
#include <QString>

#include "src/gui/MainPanel.h"
#include "src/gui/SectionTab.h"
#include "src/gui_elements/Group.h"

class HelpWindow : public QMainWindow {
	Q_OBJECT

	public:
		explicit HelpWindow(QMainWindow *parent = nullptr);
		void loadHelp(const bool &dev = false);
		SectionTab * getSectionTab() const noexcept { return help_tab_; }

	protected:
		void keyPressEvent(QKeyEvent *event) override;

	private:
		void createMenu();
		void helpAbout();

		SectionTab *help_tab_ = nullptr;
		QAction *view_user_guide_ = nullptr;
		QAction *view_dev_help_ = nullptr;
};


#endif //HELPWINDOW_H
