/*****************************************************************************/
/*  Copyright 2021 WSL Institute for Snow and Avalanche Research  SLF-DAVOS  */
/*****************************************************************************/
/* This file is part of INIshell.
   INIshell is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   INIshell is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with INIshell.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "SectionButton.h"
#include "src/main/inishell.h"

#include <QHBoxLayout>
#include <QPushButton>

#ifdef DEBUG
	#include <iostream>
#endif

SectionButton::SectionButton(const int &index, const button_mode &mode, const QString &section, QWidget *parent) : QWidget(parent) {
	const QSize sz( 15, 15 ); //w, h
	const int gap_after_label = 5;
	this->setFixedWidth(sz.width() + gap_after_label);
	this->setFixedHeight(sz.height());


	auto button( new QPushButton() );
	button->setFixedSize(sz);

	if (mode == plus) {
		button->setText("+");
		connect(button, &QPushButton::clicked, this, [=] { onPlusClicked(index); });
		button->setToolTip(tr("Click \"+\" to add another instance of this section to the INI file"));
	} else if (mode == minus) {
		button->setText("-");
		connect(button, &QPushButton::clicked, this, [=] { onMinusClicked(section); });
		button->setToolTip(tr("Click \"-\" to remove this section instance from the INI file"));
	}

	auto button_layout = new QHBoxLayout;
	button_layout->setContentsMargins(0, 0, 0, 0);
	button_layout->setSpacing(0);
	button_layout->addSpacerItem(new QSpacerItem(gap_after_label, sz.height(), QSizePolicy::Fixed));
	button_layout->addWidget(button, 0, Qt::AlignLeft);
	this->setLayout(button_layout);
}

void SectionButton::onPlusClicked(const int &index) {
	getMainWindow()->getControlPanel()->spawnDynamicSection(index);
}

void SectionButton::onMinusClicked(const QString &section) {
	getMainWindow()->getControlPanel()->removeDynamicSection(section);
	//TODO: confirmation box with "do not show again"
}
