/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.Res;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.Serializable;

public class ImageItemPainter
implements ItemPainter,
Serializable {
    protected Component component;
    protected int alignment;
    protected boolean streamResetError;
    protected boolean paintBackground = true;
    protected boolean genDisabledImage = true;

    public ImageItemPainter() {
    }

    public ImageItemPainter(Component component) {
        this(component, 68);
    }

    public ImageItemPainter(Component component, int alignment) {
        this.component = component;
        this.alignment = alignment;
    }

    public ImageItemPainter(Component component, int alignment, boolean paintBackground) {
        this.component = component;
        this.alignment = alignment;
        this.paintBackground = paintBackground;
    }

    public void setAlignment(int alignment) {
        if ((alignment & 0xF0) < 0 || (alignment & 0xF0) > 64) {
            throw new IllegalArgumentException(Res.bundle.format(1, (Object[])new Integer[]{new Integer(alignment & 0xF0)}));
        }
        if ((alignment & 0xF) < 0 || (alignment & 0xF) > 4) {
            throw new IllegalArgumentException(Res.bundle.format(2, (Object[])new Integer[]{new Integer(alignment & 0xF)}));
        }
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setPaintBackground(boolean paintBackground) {
        this.paintBackground = paintBackground;
    }

    public boolean isPaintBackground() {
        return this.paintBackground;
    }

    public void setGenDisabledImage(boolean genDisabledImage) {
        this.genDisabledImage = genDisabledImage;
    }

    public boolean isGenDisabledImage() {
        return this.genDisabledImage;
    }

    public Dimension getPreferredSize(Object data, Graphics g, int state, ItemPaintSite site) {
        Image image;
        if (site != null && site.getSiteComponent() != null) {
            this.component = site.getSiteComponent();
        }
        return (image = this.getImage(data, state)) == null ? new Dimension() : new Dimension(image.getWidth(this.component), image.getHeight(this.component));
    }

    public void paint(Object data, Graphics g, Rectangle rect, int state, ItemPaintSite site) {
        boolean trans;
        Color bg;
        if (site != null && site.getSiteComponent() != null) {
            this.component = site.getSiteComponent();
        }
        Image image = this.getImage(data, state);
        Color oc = g.getColor();
        Color color = bg = site != null ? site.getBackground() : g.getColor();
        if (bg == null) {
            bg = g.getColor();
        }
        g.setColor(bg);
        boolean bl = site != null ? site.isTransparent() : (trans = !this.paintBackground);
        if (!trans) {
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.streamResetError) {
            g.setColor(SystemColor.windowText);
            g.drawString(Res._CantResetImageStream, rect.x, rect.y);
        } else if (image != null) {
            int height;
            int y;
            int width;
            int x;
            int a;
            int imageWidth = image.getWidth(this.component);
            int imageHeight = image.getHeight(this.component);
            int n = a = site != null ? site.getAlignment() : this.alignment;
            if (a == 0) {
                a = this.alignment;
            }
            switch (a & 0xF) {
                default: {
                    x = rect.x;
                    width = imageWidth;
                    break;
                }
                case 2: {
                    x = rect.x + (rect.width - imageWidth) / 2;
                    width = imageWidth;
                    break;
                }
                case 3: {
                    x = rect.x + rect.width - imageWidth;
                    width = imageWidth;
                    break;
                }
                case 4: {
                    x = rect.x;
                    width = rect.width;
                }
            }
            switch (a & 0xF0) {
                default: {
                    y = rect.y;
                    height = imageHeight;
                    break;
                }
                case 32: {
                    y = rect.y + (rect.height - imageHeight) / 2;
                    height = imageHeight;
                    break;
                }
                case 48: {
                    y = rect.y + rect.height - imageHeight;
                    height = imageHeight;
                    break;
                }
                case 64: {
                    y = rect.y;
                    height = rect.height;
                }
            }
            g.drawImage(image, x, y, width, height, this.component);
        }
        g.setColor(oc);
    }

    protected Image getImage(Object data, int state) {
        Image image;
        if (data == null) {
            return null;
        }
        this.streamResetError = false;
        if (data instanceof Image) {
            image = (Image)data;
        } else {
            try {
                image = ImageLoader.loadFromBlob(data, this.component, true);
            }
            catch (IOException ex) {
                this.streamResetError = true;
                image = null;
            }
        }
        if (image == null) {
            return null;
        }
        if (this.genDisabledImage && (state & 1) != 0) {
            return ImageLoader.getDisabledImage(this.component, image);
        }
        return image;
    }
}

