/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.PlaceHolder;
import com.borland.jbcl.model.BasicVectorContainer;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorSelectionEvent;
import com.borland.jbcl.model.VectorViewManager;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.TabsetView;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class TabsetPanel
extends TabsetView
implements Serializable {
    private Vector pageInfo = new Vector();
    CardLayout cardLayout = new CardLayout();
    Insets margins = new Insets(4, 4, 4, 4);
    String textureName;

    public TabsetPanel() {
        super.setModel((VectorModel)new BasicVectorContainer());
        TextItemPainter textPainter = new TextItemPainter(33, new Insets(1, 1, 1, 1));
        super.setViewManager((VectorViewManager)new BasicViewManager(new FocusableItemPainter((ItemPainter)textPainter)));
        this.setClientBordered(true);
        super.setLayout((LayoutManager)this.cardLayout);
        super.addImpl((Component)new JPanel(), (Object)"BLANK", -1);
        super.setBackground(UIManager.getColor("TabbedPane.tabBackground"));
        super.setForeground(UIManager.getColor("TabbedPane.tabForeground"));
    }

    public void updateUI() {
        super.setBackground(UIManager.getColor("TabbedPane.tabBackground"));
        super.setForeground(UIManager.getColor("TabbedPane.tabForeground"));
    }

    public void setSelectedPage(Component page) {
        int index = this.pageInfo.indexOf(page);
        if (index != -1) {
            this.setSelectedIndex(index);
        }
    }

    public Component getSelectedPage() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        Component comp = (Component)this.pageInfo.elementAt(index);
        if (comp instanceof PlaceHolder) {
            return null;
        }
        return comp;
    }

    public void removePage(Component page) {
        int index = this.pageInfo.indexOf(page);
        if (index != -1) {
            this.removeTab((String)this.model.get(index));
        }
    }

    public void setLabels(String[] labels) {
        super.setLabels(labels);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String path) {
        if (path != null && !path.equals("")) {
            Image i = ImageLoader.load(path, (Component)((Object)this));
            if (i == null) throw new IllegalArgumentException(path);
            ImageLoader.waitForImage((Component)((Object)this), i);
            this.textureName = path;
            this.setTexture(i);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    public void addTab(Object item) {
        super.addTab(item);
    }

    public void removeTab(String item) {
        if (this.isReadOnly()) {
            return;
        }
        int index = this.writeModel.find(item);
        if (index != -1) {
            Component comp = (Component)this.pageInfo.elementAt(index);
            this.pageInfo.removeElementAt(index);
            if (!(comp instanceof PlaceHolder)) {
                super.remove(comp);
            }
            super.removeTab((Object)item);
        }
    }

    public void addTab(int aheadOf, String item) {
        if (this.isReadOnly()) {
            return;
        }
        if (aheadOf == -1) {
            this.pageInfo.addElement(new PlaceHolder());
        } else {
            this.pageInfo.insertElementAt(new PlaceHolder(), aheadOf);
        }
        super.addTab(aheadOf, (Object)item);
    }

    public void addImpl(Component page, Object label, int index) {
        this.writeModel.enableModelEvents(false);
        if (label != null) {
            int oldIndex = this.model.find(label);
            if (oldIndex != -1) {
                Component oldComp = (Component)this.pageInfo.elementAt(oldIndex);
                if (!(oldComp instanceof PlaceHolder)) {
                    super.remove(oldComp);
                }
                this.pageInfo.setElementAt(page, oldIndex);
            } else {
                this.pageInfo.addElement(page);
                super.addTab(label);
            }
        } else {
            this.pageInfo.addElement(page);
            label = page.getName();
            super.addTab(label);
        }
        super.addImpl(page, label, index);
        this.writeModel.enableModelEvents(true);
        String selectedLabel = this.getSelectedTab();
        if (selectedLabel != null && selectedLabel.equals((String)label)) {
            this.cardLayout.show((Container)((Object)this), selectedLabel);
        }
    }

    public void remove(Component page) {
        int index = this.pageInfo.indexOf(page);
        if (index != -1) {
            this.pageInfo.setElementAt(new PlaceHolder(), index);
        }
        super.remove(page);
    }

    public void removeAll() {
        if (this.isReadOnly()) {
            return;
        }
        for (int i = 0; i < this.pageInfo.size(); ++i) {
            if (this.pageInfo.elementAt(i) instanceof PlaceHolder) continue;
            super.remove((Component)this.pageInfo.elementAt(i));
        }
        this.pageInfo.removeAllElements();
        this.writeModel.removeAll();
    }

    public Insets getInsets() {
        Insets i = super.getInsets();
        i.left += this.margins.left;
        i.top += this.margins.top;
        i.right += this.margins.right;
        i.bottom += this.margins.bottom;
        return i;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setMargins(Insets margins) {
        this.margins = margins == null ? new Insets(0, 0, 0, 0) : margins;
        this.invalidate();
        this.repaint(100L);
    }

    public void selectionChanged(VectorSelectionEvent e) {
        super.selectionChanged(e);
        int index = this.getSelectedIndex();
        if (index != -1 && !(this.pageInfo.elementAt(index) instanceof PlaceHolder)) {
            String label = this.model.get(index).toString();
            this.cardLayout.show((Container)((Object)this), label);
            return;
        }
        this.cardLayout.show((Container)((Object)this), "BLANK");
    }

    public void modelContentChanged(VectorModelEvent e) {
        switch (e.getChange()) {
            case 1: 
            case 17: 
            case 33: {
                this.updateTabInfo();
            }
        }
    }

    protected void updateTabInfo() {
        int i;
        if (this.pageInfo == null) {
            return;
        }
        Component[] oldComponents = new Component[this.pageInfo.size()];
        for (int i2 = 0; i2 < this.pageInfo.size(); ++i2) {
            oldComponents[i2] = (Component)this.pageInfo.elementAt(i2);
        }
        int index = this.getSelectedIndex();
        for (i = 0; i < this.model.getCount(); ++i) {
            if (i < oldComponents.length) {
                if (oldComponents[i] instanceof PlaceHolder) continue;
                this.cardLayout.removeLayoutComponent(oldComponents[i]);
                this.cardLayout.addLayoutComponent(oldComponents[i], this.model.get(i));
                if (index != i) continue;
                this.cardLayout.show((Container)((Object)this), (String)this.model.get(i));
                continue;
            }
            this.pageInfo.addElement(new PlaceHolder());
        }
        for (i = oldComponents.length - 1; i >= this.model.getCount(); --i) {
            this.pageInfo.removeElementAt(i);
            if (oldComponents[i] instanceof PlaceHolder) continue;
            super.remove(oldComponents[i]);
        }
        super.updateTabInfo();
    }

    public final void setLayout(LayoutManager mgr) {
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = new Dimension(100, 100);
        if (!this.pageInfo.isEmpty()) {
            prefSize = this.cardLayout.preferredLayoutSize((Container)((Object)this));
            prefSize.width = Math.max(prefSize.width, super.getPreferredSize().width);
        }
        return prefSize;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getSelectedPage() != null) {
            this.getSelectedPage().setEnabled(enabled);
        }
    }
}

