/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.Res;
import com.borland.jbcl.control.StringInputDialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.Vector;

public class StringInput
implements WindowListener,
Serializable {
    public static final int OK = 1;
    public static final int CANCEL = 8;
    protected StringInputDialog dialog;
    protected Frame frame;
    protected String title;
    protected String value;
    protected transient Vector listeners = new Vector();
    protected int result;

    public StringInput(Frame frame, String title, String value) {
        this.frame = frame;
        this.title = title;
        this.value = value;
        if (frame != null) {
            this.dialog = new StringInputDialog(frame, title, value);
        }
    }

    public StringInput(Frame frame, String title) {
        this(frame, title, "");
    }

    public StringInput(Frame frame) {
        this(frame, "", "");
    }

    public StringInput() {
        this(null, "", "");
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setValue(String value) {
        this.value = value;
        if (this.dialog != null) {
            this.dialog.setValue(value);
        }
    }

    public String getValue() {
        if (this.dialog != null) {
            this.value = this.dialog.getValue();
        }
        return this.value;
    }

    public void setResult(int i) {
        this.result = i;
        if (this.dialog != null) {
            this.dialog.setResult(this.result);
        }
    }

    public int getResult() {
        if (this.dialog != null) {
            this.result = this.dialog.getResult();
        }
        return this.result;
    }

    public void show() {
        this.setVisible(true);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.dialog == null) {
                if (this.frame == null) {
                    throw new IllegalStateException(Res._NoFrame);
                }
                this.dialog = new StringInputDialog(this.frame, this.title, this.value);
                this.dialog.setResult(this.result);
                this.dialog.addWindowListener(this);
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.dialog.addActionListener((ActionListener)this.listeners.elementAt(i));
                }
            }
            this.dialog.setVisible(true);
        } else if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.dialog != null ? this.dialog.isVisible() : false;
    }

    public void addActionListener(ActionListener l) {
        if (this.dialog != null) {
            this.dialog.addActionListener(l);
        } else {
            this.listeners.addElement(l);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (this.dialog != null) {
            this.dialog.removeActionListener(l);
        } else {
            this.listeners.removeElement(l);
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.value = this.dialog.getValue();
        this.result = this.dialog.getResult();
    }

    public void windowClosed(WindowEvent e) {
        if (this.dialog != null) {
            this.value = this.dialog.getValue();
            this.result = this.dialog.getResult();
        }
        this.dialog = null;
        if (this.frame.isShowing()) {
            if (this.frame.getFocusOwner() != null) {
                this.frame.getFocusOwner().requestFocus();
            } else {
                this.frame.requestFocus();
            }
        }
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    static {
        OK = 1;
        CANCEL = 8;
    }
}

