/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.DateFormatDialog_cancelButton_actionAdapter;
import alpine3d.DateFormatDialog_okButton_actionAdapter;
import alpine3d.Utils;
import com.borland.jbcl.layout.VerticalFlowLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DateFormatDialog
extends JDialog {
    JButton cancelButton;
    private String[] format = new String[]{"yyyymmddhh", "yyyymmddhhmm"};
    JComboBox jComboBox1;
    JLabel jLabel1;
    JLabel jLabel2;
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2;
    JPanel jPanel3;
    JPanel jPanel4;
    JPanel jPanel5;
    JButton okButton;
    private int timeStep = 1;
    JTextField timeStepField;
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    private boolean withMinutes = false;

    public DateFormatDialog() {
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox<String>(this.format);
        this.jLabel2 = new JLabel();
        this.timeStepField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public File getNextFile(String filename) {
        int hour;
        int day;
        int month;
        int year;
        String ext = Utils.getExtension(filename);
        StringBuffer base = new StringBuffer(Utils.getAbsoluteBaseName(filename));
        StringBuffer date = new StringBuffer();
        int min = 0;
        if (this.withMinutes) {
            year = Integer.parseInt(base.substring(base.length() - 12, base.length() - 8));
            month = Integer.parseInt(base.substring(base.length() - 8, base.length() - 6));
            day = Integer.parseInt(base.substring(base.length() - 6, base.length() - 4));
            hour = Integer.parseInt(base.substring(base.length() - 4, base.length() - 2));
            min = Integer.parseInt(base.substring(base.length() - 2));
        } else {
            year = Integer.parseInt(base.substring(base.length() - 10, base.length() - 6));
            month = Integer.parseInt(base.substring(base.length() - 6, base.length() - 4));
            day = Integer.parseInt(base.substring(base.length() - 4, base.length() - 2));
            hour = Integer.parseInt(base.substring(base.length() - 2));
        }
        int numDays = 0;
        if (this.withMinutes) {
            min += this.timeStep;
            while (min >= 60) {
                ++hour;
                min -= 60;
            }
        } else {
            hour += this.timeStep;
        }
        while (hour >= 24) {
            ++day;
            hour -= 24;
        }
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                numDays = 31;
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                numDays = 30;
                break;
            }
            case 2: {
                numDays = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 29 : 28;
            }
        }
        while (day > numDays) {
            ++month;
            day -= numDays;
        }
        while (month >= 13) {
            ++year;
            month -= 12;
        }
        date.append(Utils.formatter4.format(year));
        date.append(Utils.formatter2.format(month));
        date.append(Utils.formatter2.format(day));
        date.append(Utils.formatter2.format(hour));
        if (this.withMinutes) {
            date.append(Utils.formatter2.format(min));
            base.replace(base.length() - 12, base.length() + 1, date.toString());
        } else {
            base.replace(base.length() - 10, base.length() + 1, date.toString());
        }
        File file = new File(base + "." + ext);
        return file;
    }

    public File getPreviousFile(String filename) {
        int hour;
        int day;
        int month;
        int year;
        String ext = Utils.getExtension(filename);
        StringBuffer base = new StringBuffer(Utils.getAbsoluteBaseName(filename));
        StringBuffer date = new StringBuffer();
        int min = 0;
        if (this.withMinutes) {
            year = Integer.parseInt(base.substring(base.length() - 12, base.length() - 8));
            month = Integer.parseInt(base.substring(base.length() - 8, base.length() - 6));
            day = Integer.parseInt(base.substring(base.length() - 6, base.length() - 4));
            hour = Integer.parseInt(base.substring(base.length() - 4, base.length() - 2));
            min = Integer.parseInt(base.substring(base.length() - 2));
        } else {
            year = Integer.parseInt(base.substring(base.length() - 10, base.length() - 6));
            month = Integer.parseInt(base.substring(base.length() - 6, base.length() - 4));
            day = Integer.parseInt(base.substring(base.length() - 4, base.length() - 2));
            hour = Integer.parseInt(base.substring(base.length() - 2));
        }
        int numDays = 0;
        if (this.withMinutes) {
            min -= this.timeStep;
            while (min < 0) {
                --hour;
                min += 60;
            }
        } else {
            hour -= this.timeStep;
        }
        while (hour < 0) {
            --day;
            hour += 24;
        }
        while (day <= 0) {
            --month;
            while (month <= 0) {
                --year;
                month += 12;
            }
            switch (month) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 10: 
                case 12: {
                    numDays = 31;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    numDays = 30;
                    break;
                }
                case 2: {
                    numDays = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 29 : 28;
                }
            }
            day += numDays;
        }
        while (month <= 0) {
            --year;
            month += 12;
        }
        date.append(Utils.formatter4.format(year));
        date.append(Utils.formatter2.format(month));
        date.append(Utils.formatter2.format(day));
        date.append(Utils.formatter2.format(hour));
        if (this.withMinutes) {
            date.append(Utils.formatter2.format(min));
            base.replace(base.length() - 12, base.length() + 1, date.toString());
        } else {
            base.replace(base.length() - 10, base.length() + 1, date.toString());
        }
        File file = new File(base + "." + ext);
        return file;
    }

    public int getTimeStep() {
        return this.timeStep;
    }

    public boolean isGoodFormat(String filename) {
        String hour;
        String day;
        String month;
        String year;
        String base = Utils.getAbsoluteBaseName(filename);
        if (this.withMinutes) {
            year = base.substring(base.length() - 12, base.length() - 8);
            month = base.substring(base.length() - 8, base.length() - 6);
            day = base.substring(base.length() - 6, base.length() - 4);
            hour = base.substring(base.length() - 4, base.length() - 2);
            String min = base.substring(base.length() - 2);
            if (!Character.isDigit(min.charAt(0)) || !Character.isDigit(min.charAt(1)) || Integer.parseInt(min) > 60) {
                return false;
            }
        } else {
            year = base.substring(base.length() - 10, base.length() - 6);
            month = base.substring(base.length() - 6, base.length() - 4);
            day = base.substring(base.length() - 4, base.length() - 2);
            hour = base.substring(base.length() - 2);
        }
        int yearCount = 0;
        while (yearCount < year.length()) {
            if (!Character.isDigit(year.charAt(yearCount))) {
                // empty if block
            }
            ++yearCount;
        }
        if (yearCount != year.length()) {
            return false;
        }
        if (!Character.isDigit(month.charAt(0)) || !Character.isDigit(month.charAt(1)) || Integer.parseInt(month) > 12) {
            return false;
        }
        if (!Character.isDigit(day.charAt(0)) || !Character.isDigit(day.charAt(1)) || Integer.parseInt(day) > 31) {
            return false;
        }
        return Character.isDigit(hour.charAt(0)) && Character.isDigit(hour.charAt(1)) && Integer.parseInt(hour) <= 24;
    }

    public boolean isWithMinutes() {
        return this.withMinutes;
    }

    private void jbInit() throws Exception {
        this.setTitle("Define Date Format");
        this.jPanel1.setLayout(this.verticalFlowLayout1);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 40, 10, 40));
        this.jLabel1.setText("Choose a date format:");
        this.jComboBox1.setBackground(Color.white);
        this.jLabel2.setText("Set time step length: ");
        this.timeStepField.setPreferredSize(new Dimension(30, 19));
        this.timeStepField.setText(new Integer(this.timeStep).toString());
        this.okButton.setPreferredSize(new Dimension(75, 25));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new DateFormatDialog_okButton_actionAdapter(this));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new DateFormatDialog_cancelButton_actionAdapter(this));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel2, null);
        this.jPanel2.add((Component)this.jLabel1, null);
        this.jPanel1.add((Component)this.jPanel3, null);
        this.jPanel3.add((Component)this.jComboBox1, null);
        this.jPanel1.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jLabel2, null);
        this.jPanel4.add((Component)this.timeStepField, null);
        this.jPanel1.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.okButton, null);
        this.jPanel5.add((Component)this.cancelButton, null);
    }

    void okButton_actionPerformed(ActionEvent e) {
        this.withMinutes = this.jComboBox1.getSelectedIndex() == 1;
        this.timeStep = Integer.parseInt(this.timeStepField.getText());
        this.dispose();
    }
}

