/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import ProWin.Setup;
import ProWin.StartFrame;
import alpine3d.ALBStrategy;
import alpine3d.ASCIIFileReader;
import alpine3d.ASCIIFileWriter;
import alpine3d.AlphaSetDialog_okButton_actionAdapter1;
import alpine3d.DEMStrategy;
import alpine3d.DrawingArea;
import alpine3d.EditColorRangeDialog_okButton_actionAdapter;
import alpine3d.EditColorRangeDialog_resetButton_actionAdapter;
import alpine3d.EditMethodDialog;
import alpine3d.EditMethodDialog_cancelButton_actionAdapter1;
import alpine3d.EditMethodDialog_okButton_actionAdapter1;
import alpine3d.EditRectangleDialog_okButton_actionAdapter1;
import alpine3d.EditValueDialog_cancelButton_actionAdapter1;
import alpine3d.EditValueDialog_nextButton_actionAdapter;
import alpine3d.EditValueDialog_okButton_actionAdapter1;
import alpine3d.FIELD_CAPACITYStrategy;
import alpine3d.FileSpecIF;
import alpine3d.GPSData;
import alpine3d.GUI;
import alpine3d.GUI_editButton_actionAdapter1;
import alpine3d.GUI_gpsCheckBox_actionAdapter;
import alpine3d.GUI_jMenuEditCreate_actionAdapter;
import alpine3d.GUI_jMenuEditRedo_actionAdapter;
import alpine3d.GUI_jMenuEditUndo_actionAdapter;
import alpine3d.GUI_jMenuFileClose_actionAdapter;
import alpine3d.GUI_jMenuFileSaveAs_actionAdapter1;
import alpine3d.GUI_jMenuFileSave_actionAdapter;
import alpine3d.GUI_jMenuFileSelect_actionAdapter;
import alpine3d.GUI_jMenuOptionsMap_actionAdapter;
import alpine3d.GUI_jMenuOptionsRaster_actionAdapter;
import alpine3d.GUI_jMenuViewAlpha_actionAdapter1;
import alpine3d.GUI_jMenuViewColor_actionAdapter;
import alpine3d.GUI_jPopMenuCloseMap_actionAdapter;
import alpine3d.GUI_jPopMenuHideMap_actionAdapter;
import alpine3d.GUI_jPopMenuToFront_actionAdapter;
import alpine3d.GUI_mapCheckBox_actionAdapter;
import alpine3d.GUI_nextImageButton_actionAdapter;
import alpine3d.GUI_openButton_actionAdapter1;
import alpine3d.GUI_prevImageButton_actionAdapter;
import alpine3d.GUI_radioButtStack_actionAdapter;
import alpine3d.GUI_resetViewButton_actionAdapter;
import alpine3d.GUI_saveButton_actionAdapter;
import alpine3d.GUI_selectButton_actionAdapter;
import alpine3d.GUI_zoomInButton_actionAdapter;
import alpine3d.GUI_zoomOutButton_actionAdapter;
import alpine3d.LANDUSEStrategy;
import alpine3d.LWRStrategy;
import alpine3d.MapImage;
import alpine3d.MyFileFilter;
import alpine3d.OpenFileChooser_openButton_actionAdapter1;
import alpine3d.PointDialog;
import alpine3d.PointDialog_closeButton_actionAdapter;
import alpine3d.PointDialog_startButton_actionAdapter;
import alpine3d.RasterImage;
import alpine3d.SDPStrategy;
import alpine3d.SNOWPACKFile;
import alpine3d.SOIL_DEPTHStrategy;
import alpine3d.SWEStrategy;
import alpine3d.SWRStrategy;
import alpine3d.SpecialPointCreateDialog_okButton_actionAdapter1;
import alpine3d.SurCodeCreateDialog_cancelButton_actionAdapter1;
import alpine3d.SurCodeCreateDialog_okButton_actionAdapter;
import alpine3d.SurCodeMessageDialog_backButton_actionAdapter;
import alpine3d.SurCodeMessageDialog_cancelButton_actionAdapter;
import alpine3d.SurCodeMessageDialog_okButton_actionAdapter;
import alpine3d.SurfaceArea;
import alpine3d.SurfaceCodeWriter;
import alpine3d.TSSStrategy;
import alpine3d.UNKNOWNStrategy;
import alpine3d.Utils;
import alpine3d.WETStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;

public class Alpine3D
implements MouseInputListener,
MouseWheelListener,
WindowStateListener,
PropertyChangeListener {
    private ArrayList SN_FileList;
    private RasterImage actRImage;
    private int alpha = 255;
    private boolean alphaIsSet = false;
    private File currFile;
    private DrawingArea dArea;
    private int fCEditIndex = -1;
    private ArrayList fCPointList;
    private Map fCPointMap;
    private Map fCUndoIndexMap;
    private DecimalFormat formatter0;
    private GPSData gpsData;
    private GUI gui;
    private int lusEditIndex = -1;
    private ArrayList lusPointList;
    private Map lusPointMap;
    private Map lusUndoIndexMap;
    private MapImage mImage1;
    private boolean packFrame = false;
    private ArrayList pointDialogArr;
    private Stack rasImageStack;
    private int sDEditIndex = -1;
    private ArrayList sDPointList;
    private Map sDPointMap;
    private Map sDUndoIndexMap;
    private StartFrame startFrame;
    private Point viewPos = new Point(0, 0);

    public Alpine3D() {
        this.pointDialogArr = new ArrayList();
        this.SN_FileList = new ArrayList();
        this.lusPointMap = new HashMap();
        this.lusUndoIndexMap = new HashMap();
        this.sDPointMap = new HashMap();
        this.sDUndoIndexMap = new HashMap();
        this.fCPointMap = new HashMap();
        this.fCUndoIndexMap = new HashMap();
        this.lusPointList = new ArrayList();
        this.sDPointList = new ArrayList();
        this.fCPointList = new ArrayList();
        Utils.fileSpecStrategyMap.put(new Integer(1), new DEMStrategy());
        Utils.fileSpecStrategyMap.put(new Integer(100), new LANDUSEStrategy());
        Utils.fileSpecStrategyMap.put(new Integer(102), new SOIL_DEPTHStrategy());
        Utils.fileSpecStrategyMap.put(new Integer(101), new FIELD_CAPACITYStrategy());
        Utils.fileSpecStrategyMap.put(new Integer(3), new SWRStrategy());
        Utils.fileSpecStrategyMap.put(new Integer(4), new LWRStrategy());
        Utils.fileSpecStrategyMap.put(new Integer(6), new TSSStrategy());
        Utils.fileSpecStrategyMap.put(new Integer(5), new ALBStrategy());
        Utils.fileSpecStrategyMap.put(new Integer(8), new SDPStrategy());
        Utils.fileSpecStrategyMap.put(new Integer(9), new SWEStrategy());
        Utils.fileSpecStrategyMap.put(new Integer(7), new WETStrategy());
        Utils.fileSpecStrategyMap.put(new Integer(10), new UNKNOWNStrategy());
        this.formatter0 = new DecimalFormat("###");
        this.createAndShowGui();
        this.rasImageStack = new Stack();
        this.dArea = new DrawingArea();
        this.dArea.addMouseMotionListener(this);
        this.dArea.addMouseListener(this);
        this.dArea.addPropertyChangeListener(this);
    }

    void AlphaSetDialog_okButton_actionPerformed(ActionEvent e) {
        this.changeAlpha();
        this.gui.asd.dispose();
    }

    void EditColorRangeDialog_okButton_actionPerformed(ActionEvent e) {
        try {
            this.changeLegendLimits();
        }
        catch (NumberFormatException ex) {
            this.gui.ecrd.attLabel.setText("Insert a Number like '1.5'");
        }
    }

    void EditColorRangeDialog_resetButton_actionPerformed(ActionEvent e) {
        ((RasterImage)this.rasImageStack.peek()).limitsAreSet(false);
        this.actRImage.changeLimits(this.actRImage.getSurfaceArea().getMinValue(), this.actRImage.getSurfaceArea().getMaxValue(), this.alpha);
        this.gui.ecrd.dispose();
        this.updateDrawingArea();
    }

    void EditMethodDialog_cancelButton_actionPerformed(ActionEvent e) {
        this.gui.evd.deleteOldValues();
        this.gui.emd.dispose();
    }

    void EditMethodDialog_okButton_actionPerformed(ActionEvent e) {
        if (this.gui.emd.rectangleButton.isSelected()) {
            if (this.gui.erd.okButton.getActionListeners().length == 0) {
                this.gui.erd.okButton.addActionListener(new EditRectangleDialog_okButton_actionAdapter1(this));
            }
            Dimension erdSize = this.gui.erd.getPreferredSize();
            Dimension frmSize = this.gui.getSize();
            Point loc = this.gui.getLocation();
            this.gui.erd.setLocation((frmSize.width - erdSize.width) / 2 + loc.x, (frmSize.height - erdSize.height) / 2 + loc.y);
            this.gui.erd.pack();
            this.gui.erd.show();
        }
        if (this.gui.emd.lineButton.isSelected() || this.gui.emd.polygonButton.isSelected()) {
            this.dArea.getEditPointList().clear();
            this.dArea.repaint();
        }
        if (this.gui.emd.existingPolButton.isSelected() || this.gui.emd.existingLineButton.isSelected() || this.gui.emd.pointButton.isSelected() || this.gui.emd.entireButton.isSelected()) {
            this.showEditValueDialog();
        }
        this.gui.statusBar.setText(this.gui.emd.getStatusBarText());
        this.gui.emd.dispose();
        this.gui.evd.deleteOldValues();
    }

    void EditRectangleDialog_okButton_actionPerformed(ActionEvent e) {
        int opt;
        int xLowLimUser = (int)((this.gui.erd.getXulCorner() - this.actRImage.getSurfaceArea().getXllCorner()) / this.actRImage.getSurfaceArea().getCellsize());
        int yLowLimUser = (int)(-1.0f * (this.gui.erd.getYulCorner() - this.actRImage.getSurfaceArea().getYulCorner()) / this.actRImage.getSurfaceArea().getCellsize());
        int xUpLimUser = (int)((this.gui.erd.getXlrCorner() - this.actRImage.getSurfaceArea().getXllCorner()) / this.actRImage.getSurfaceArea().getCellsize());
        int yUpLimUser = (int)(-1.0f * (this.gui.erd.getYlrCorner() - this.actRImage.getSurfaceArea().getYulCorner()) / this.actRImage.getSurfaceArea().getCellsize());
        if (xLowLimUser >= xUpLimUser || yLowLimUser >= yUpLimUser) {
            JOptionPane.showMessageDialog(this.gui, "The chosen intervall is less than 0. \nCheck your entry.");
            return;
        }
        if ((xLowLimUser < 0 || yLowLimUser < 0 || xUpLimUser > this.actRImage.getSurfaceArea().getNCols() || yUpLimUser > this.actRImage.getSurfaceArea().getNRows()) && (opt = JOptionPane.showConfirmDialog(this.gui, "Your values are outside of the raster. \nShould the hole raster be edited?", "Message", 0)) == 1) {
            return;
        }
        this.showEditValueDialog();
        this.gui.erd.dispose();
    }

    void EditValueDialog_cancelButton_actionPerformed(ActionEvent e) {
        this.gui.evd.setNextButtonCount(0);
        this.gui.evd.okButton.setEnabled(false);
        this.gui.evd.panel1.remove(this.gui.evd.forLabel);
        this.gui.evd.panel1.remove(this.gui.evd.nextLabel);
        this.gui.evd.buttonPanel.remove(this.gui.evd.nextButton);
        this.gui.evd.dispose();
        this.gui.statusBar.setText("");
    }

    void EditValueDialog_nextButton_actionPerformed(ActionEvent e) {
        this.gui.evd.setNextButtonCount(this.gui.evd.getNextButtonCount() + 1);
        this.gui.evd.dispose();
        if (this.gui.evd.getNextButtonCount() == 1) {
            this.gui.evd.forLabel.setText("For Soil Depth");
            this.gui.evd.panel1.add((Component)this.gui.evd.forLabel, 0);
            this.showEditValueDialog();
        } else {
            this.gui.evd.forLabel.setText("For Field Capacity");
            this.gui.evd.buttonPanel.remove(this.gui.evd.nextButton);
            this.gui.evd.panel1.remove(this.gui.evd.nextLabel);
            this.showEditValueDialog();
        }
    }

    void EditValueDialog_okButton_actionPerformed(ActionEvent e) {
        block7: {
            block6: {
                if (this.gui.evd.editInsideCheckBox.isSelected()) {
                    this.gui.evd.setEditInside(true);
                } else {
                    this.gui.evd.setEditInside(false);
                }
                EditMethodDialog cfr_ignored_0 = this.gui.emd;
                if (this.gui.emd.getEditMethod() == 0) break block6;
                EditMethodDialog cfr_ignored_1 = this.gui.emd;
                if (this.gui.emd.getEditMethod() != 2) break block7;
            }
            this.gui.evd.setEditWidthFactor(Integer.parseInt(this.gui.evd.inputTextField.getText()));
        }
        EditMethodDialog cfr_ignored_2 = this.gui.emd;
        if (this.gui.emd.getEditMethod() != 2) {
            this.gui.statusBar.setText("");
            this.editSurfaceCode();
        }
        this.gui.evd.setNextButtonCount(0);
        this.gui.evd.okButton.setEnabled(false);
        this.gui.evd.panel1.remove(this.gui.evd.forLabel);
        this.gui.evd.buttonPanel.remove(this.gui.evd.nextButton);
        this.gui.evd.panel1.remove(this.gui.evd.nextLabel);
        this.gui.evd.dispose();
    }

    void GUI_editButton_actionPerformed(ActionEvent e) {
        this.showEditMethodDialog();
    }

    void GUI_gpsCheckBox_actionPerformed(ActionEvent e) {
        this.showOrHideGPSData();
    }

    void GUI_jMenuEditCreate_actionPerformed(ActionEvent e) {
        this.showSurCodeCreateDialog();
    }

    void GUI_jMenuEditRedo_actionPerformed(ActionEvent e) {
        this.redo();
    }

    void GUI_jMenuEditUndo_actionPerformed(ActionEvent e) {
        this.undo();
    }

    void GUI_jMenuFileClose_actionPerformed(ActionEvent e) {
        this.closeActiveImage();
    }

    void GUI_jMenuFileSaveAs_actionPerformed(ActionEvent e) {
        this.saveAsFile();
    }

    void GUI_jMenuFileSave_actionPerformed(ActionEvent e) {
        this.saveFile();
    }

    void GUI_jMenuFileSelect_actionPerformed(ActionEvent e) {
        this.selectSNFiles();
    }

    void GUI_jMenuOptionsMap_actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(this.gui, "xcellsize:  " + this.mImage1.getXCellsize() + "\nycellsize:  " + this.mImage1.getYCellsize() + "\nxulcorner:  " + this.mImage1.getXulCorner() + "\nyulcorner:  " + this.mImage1.getYulCorner());
    }

    void GUI_jMenuOptionsRaster_actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(this.gui, "\nncols:  " + this.actRImage.getSurfaceArea().getNCols() + "\nnrows:  " + this.actRImage.getSurfaceArea().getNRows() + "\nxllcorner:  " + this.actRImage.getSurfaceArea().getXllCorner() + "\nyllcorner:  " + this.actRImage.getSurfaceArea().getYllCorner() + "\ncellsize:  " + this.actRImage.getSurfaceArea().getCellsize() + "\nNODATA_VALUE:  " + this.actRImage.getSurfaceArea().getNoDataValue() + "\nMinValue:  " + this.actRImage.getSurfaceArea().getMinValue() + "\nMaxValue: " + this.actRImage.getSurfaceArea().getMaxValue());
    }

    void GUI_jMenuViewAlpha_actionPerformed(ActionEvent e) {
        this.gui.showAlphaSetDialog(this.alpha);
        this.gui.asd.okButton.addActionListener(new AlphaSetDialog_okButton_actionAdapter1(this));
        this.gui.asd.setModal(true);
    }

    void GUI_jMenuViewColor_actionPerformed(ActionEvent e) {
        this.gui.showEditColorRangeDialog();
        String lo = ((RasterImage)this.rasImageStack.peek()).getLimit(0);
        String up = ((RasterImage)this.rasImageStack.peek()).getLimit(((RasterImage)this.rasImageStack.peek()).getNumOfColors() - 3);
        this.gui.ecrd.lowerTextField.setText(lo);
        this.gui.ecrd.upperTextField.setText(up);
        this.gui.ecrd.okButton.addActionListener(new EditColorRangeDialog_okButton_actionAdapter(this));
        this.gui.ecrd.resetButton.addActionListener(new EditColorRangeDialog_resetButton_actionAdapter(this));
    }

    void GUI_jPopMenuCloseMap_actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Map")) {
            this.closeMap();
        } else if (e.getActionCommand().equals("GPS")) {
            this.closeGPSData();
        }
    }

    void GUI_jPopMenuHideMap_actionPerformed(ActionEvent e) {
        System.out.println(this.dArea.isMImageToFront());
        if (e.getActionCommand().equals("Map")) {
            this.showOrHideMap();
        } else if (e.getActionCommand().equals("GPS")) {
            this.showOrHideGPSData();
        }
    }

    void GUI_jPopMenuToFront_actionPerformed(ActionEvent e) {
        if (this.dArea.isMImageToFront()) {
            this.dArea.setMImageToFront(false);
        } else {
            this.dArea.setMImageToFront(true);
        }
        this.dArea.repaint();
    }

    void GUI_mapCheckBox_actionPerformed(ActionEvent e) {
        this.showOrHideMap();
    }

    void GUI_nextImageButton_actionPerformed(ActionEvent e) {
        this.showNextFile();
    }

    void GUI_openButton_actionPerformed(ActionEvent e) {
        this.gui.showOpenFileChooser(this.currFile);
        this.gui.ofc.openButton.addActionListener(new OpenFileChooser_openButton_actionAdapter1(this));
    }

    void GUI_prevImageButton_actionPerformed(ActionEvent e) {
        this.showPreviousFile();
    }

    void GUI_radioButtStack_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand == ((RasterImage)this.rasImageStack.peek()).getFilename() || actionCommand.equals(((RasterImage)this.rasImageStack.peek()).getFileSpecifier() + ((RasterImage)this.rasImageStack.peek()).getFilename())) {
            if (this.dArea.isRImageHidden()) {
                this.dArea.setRImageHidden(false);
            } else {
                this.dArea.setRImageHidden(true);
                this.gui.radioButtBuffer.setSelected(true);
            }
        } else {
            if (!Utils.getExtension(actionCommand).equals("lus")) {
                int i = 0;
                while (i < this.rasImageStack.size()) {
                    if (((RasterImage)this.rasImageStack.get(i)).getFilename().equals(actionCommand)) {
                        this.actRImage = (RasterImage)this.rasImageStack.get(i);
                        this.rasImageStack.push(this.actRImage);
                        this.rasImageStack.remove(i);
                        break;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.rasImageStack.size()) {
                    String test = ((RasterImage)this.rasImageStack.get(i)).getFileSpecifier() + ((RasterImage)this.rasImageStack.get(i)).getFilename();
                    if (actionCommand.equals(test)) {
                        this.actRImage = (RasterImage)this.rasImageStack.get(i);
                        this.rasImageStack.push(this.actRImage);
                        this.rasImageStack.remove(i);
                        break;
                    }
                    ++i;
                }
            }
            this.gui.statusBar.setForeground(Color.black);
            this.gui.statusBar.setText(this.actRImage.getFilename());
        }
        this.updateDrawingArea();
    }

    void GUI_resetViewButton_actionPerformed(ActionEvent e) {
        this.resetView();
    }

    void GUI_saveButton_actionPerformed(ActionEvent e) {
        this.saveFile();
    }

    void GUI_selectButton_actionPerformed(ActionEvent e) {
        EditMethodDialog cfr_ignored_0 = this.gui.emd;
        this.gui.emd.setEditMethod(1);
        this.dArea.getEditPointList().clear();
        this.dArea.repaint();
    }

    void GUI_zoomInButton_actionPerformed(ActionEvent e) {
        this.zoomIn();
    }

    void GUI_zoomOutButton_actionPerformed(ActionEvent e) {
        this.zoomOut();
    }

    void OpenFileChooser_openButton_actionPerformed(ActionEvent e) {
        this.openFile();
    }

    void PointDialog_closeButton_actionPerformed(ActionEvent e) {
        int i = 0;
        while (i < this.SN_FileList.size()) {
            if (((SNOWPACKFile)this.SN_FileList.get(i)).getFilename().equals(e.getActionCommand())) {
                int j = 0;
                while (j < this.dArea.getSNOWPACKPointList().size()) {
                    ArrayList snList = this.dArea.getSNOWPACKPointList();
                    if (((SNOWPACKFile)this.SN_FileList.get(i)).getLocation().equals(((Point)snList.get(j)).getLocation())) {
                        snList.remove(j);
                        break;
                    }
                    ++j;
                }
                this.SN_FileList.remove(i);
                break;
            }
            ++i;
        }
        this.dArea.repaint();
    }

    void PointDialog_startButton_actionPerformed(ActionEvent e) {
        String snFilename = e.getActionCommand();
        try {
            if (this.startFrame == null || !this.startFrame.mFrame.isShowing()) {
                this.startFrame = new StartFrame();
                StartFrame.positionFrame(this.startFrame, 40, 50, Setup.m_DisplayMode);
            }
            this.startFrame.openSelectedFile(new File(snFilename));
            this.startFrame.mFrame.toFront();
        }
        catch (NullPointerException ex) {
        }
    }

    void SpecialPointCreateDialog_okButton_actionPerformed(ActionEvent e) {
        this.gui.spcd.writePointFile();
        this.gui.statusBar.setForeground(Color.red);
        this.gui.statusBar.setText(this.gui.spcd.getStatusBarText());
    }

    void SurCodeCreateDialog_cancelButton_actionPerformed(ActionEvent e) {
        this.dArea.deleteRectangle();
        this.dArea.repaint();
        this.gui.sccd.setDrawPossible(false);
        this.gui.sccd.dispose();
    }

    void SurCodeCreateDialog_okButton_actionPerformed(ActionEvent e) {
        try {
            this.gui.sccd.setDrawPossible(false);
            this.gui.sccd.dispose();
            this.gui.scmd.setCellsize(Float.parseFloat(this.gui.sccd.cellsizeTextField.getText()));
            this.gui.scmd.setllPoint(new Point2D.Float(Float.parseFloat(this.gui.sccd.xulTextField.getText()), Float.parseFloat(this.gui.sccd.ylrTextField.getText())));
            this.gui.scmd.seturPoint(new Point2D.Float(Float.parseFloat(this.gui.sccd.xlrTextField.getText()), Float.parseFloat(this.gui.sccd.yulTextField.getText())));
            this.gui.scmd.setNoDataValue(Integer.parseInt(this.gui.sccd.noDataTextField.getText()));
            this.gui.scmd.transformeToMatrixSize();
            this.gui.scmd.setTextFields();
            this.gui.showSurCodeMessageDialog();
        }
        catch (NumberFormatException ex) {
            this.gui.sccd.jPanel1.add((Component)this.gui.sccd.infoLabel, null);
            this.gui.sccd.pack();
            this.gui.sccd.show();
        }
    }

    void SurCodeMessageDialog_backButton_actionPerformed(ActionEvent e) {
        this.dArea.deleteRectangle();
        this.dArea.repaint();
        this.gui.scmd.dispose();
        this.showSurCodeCreateDialog();
    }

    void SurCodeMessageDialog_cancelButton_actionPerformed(ActionEvent e) {
        this.dArea.deleteRectangle();
        this.dArea.repaint();
        this.gui.scmd.dispose();
    }

    void SurCodeMessageDialog_okButton_actionPerformed(ActionEvent e) {
        this.gui.scmd.dispose();
        File tempFile = new File("temp.lus");
        tempFile.deleteOnExit();
        try {
            SurfaceArea sArea = new SurfaceArea();
            sArea.setNCols(this.gui.scmd.getNCols());
            sArea.setNRows(this.gui.scmd.getNRows());
            sArea.setXllCorner((float)this.gui.scmd.getllPoint().getX());
            sArea.setYllCorner((float)this.gui.scmd.getllPoint().getY());
            sArea.setCellsize(this.gui.scmd.getCellsize());
            sArea.setNoDataValue(this.gui.scmd.getNoDataValue());
            sArea.createNoValueSurfacePoints();
            new SurfaceCodeWriter(tempFile, sArea);
            this.loadRasterImage(tempFile, 101);
            this.actRImage.setSurfaceArea(sArea);
            this.actRImage.regenerateImage(this.alpha);
            this.loadRasterImage(tempFile, 102);
            this.actRImage.setSurfaceArea(sArea);
            this.actRImage.regenerateImage(this.alpha);
            this.loadRasterImage(tempFile, 100);
            this.actRImage.setSurfaceArea(sArea);
            this.actRImage.regenerateImage(this.alpha);
            this.gui.statusBar.setForeground(Color.black);
            this.gui.statusBar.setText(tempFile.getAbsolutePath());
        }
        catch (IOException ex) {
            System.out.println(ex.getLocalizedMessage());
        }
        this.dArea.deleteRectangle();
        this.updateDrawingArea();
    }

    private void changeAlpha() {
        this.alphaIsSet = true;
        this.alpha = Integer.parseInt(this.gui.asd.newValueTextField.getText());
        int i = 0;
        while (i < this.rasImageStack.size()) {
            ((RasterImage)this.rasImageStack.get(i)).changeAlpha(this.alpha);
            ++i;
        }
        this.updateDrawingArea();
    }

    private void changeLegendLimits() {
        ((RasterImage)this.rasImageStack.peek()).limitsAreSet(true);
        int fileSpecifier = this.actRImage.getFileSpecifier();
        FileSpecIF strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
        float lo = Float.parseFloat(this.gui.ecrd.lowerTextField.getText());
        float up = Float.parseFloat(this.gui.ecrd.upperTextField.getText());
        Float low = Float.valueOf(this.gui.ecrd.lowerTextField.getText());
        float lowerLimit = strategy.retransformeValue(lo);
        float upperLimit = strategy.retransformeValue(up);
        ((RasterImage)this.rasImageStack.peek()).changeLimits(lowerLimit, upperLimit, this.alpha);
        this.gui.ecrd.dispose();
        this.updateDrawingArea();
    }

    private void closeActiveImage() {
        if (!this.rasImageStack.isEmpty()) {
            if (this.actRImage == null && this.mImage1 == null) {
                this.gui.statusBar.setForeground(Color.red);
                this.gui.statusBar.setText("Make one layer active before closing");
                return;
            }
            if (this.actRImage.getFileSpecifier() == 102 || this.actRImage.getFileSpecifier() == 100 || this.actRImage.getFileSpecifier() == 101) {
                this.deleteHistory();
                int count1 = 0;
                int size1 = this.rasImageStack.size();
                int i = 0;
                while (i < size1) {
                    if (((RasterImage)this.rasImageStack.get(i - count1)).getFilename().equals(this.actRImage.getFilename())) {
                        this.gui.chBoxPanel1.remove(((RasterImage)this.rasImageStack.get(i - count1)).getRadioButton());
                        this.gui.radioButtGroup.remove(((RasterImage)this.rasImageStack.get(i - count1)).getRadioButton());
                        this.gui.chBoxPanel1.revalidate();
                        this.rasImageStack.remove(i - count1);
                        ++count1;
                    }
                    ++i;
                }
                this.gui.editButton.setEnabled(false);
                this.gui.jMenuEditActLayer.setEnabled(false);
                this.gui.undoButton.setEnabled(false);
                this.gui.redoButton.setEnabled(false);
                this.gui.jMenuEditRedo.setEnabled(false);
                this.gui.jMenuEditUndo.setEnabled(false);
            } else if (!this.rasImageStack.isEmpty()) {
                this.rasImageStack.pop();
                this.gui.radioButtGroup.remove(this.actRImage.getRadioButton());
                this.gui.chBoxPanel1.remove(this.actRImage.getRadioButton());
                this.gui.chBoxPanel1.revalidate();
            }
            if (!this.rasImageStack.isEmpty()) {
                this.actRImage = (RasterImage)this.rasImageStack.peek();
                this.actRImage.getRadioButton().setSelected(true);
            } else {
                this.actRImage = null;
                if (this.mImage1 == null) {
                    this.resetView();
                    this.gpsData = null;
                    this.dArea.getGpsTrackList().clear();
                    this.dArea.getGpsWayPointList().clear();
                    this.gui.chBoxPanel2.remove(this.gui.gpsCheckBox);
                    this.gui.chBoxPanel2.revalidate();
                }
                this.SN_FileList.clear();
                this.dArea.getSNOWPACKPointList().clear();
                this.gui.statusBar.setText("");
                this.gui.actDeviceLabel.setText("");
                this.gui.actValueLabel.setText("");
                this.gui.LegendColorPanel.removeAll();
                this.gui.LegendTextPanel.removeAll();
                this.gui.deviceLabel.setText("");
                this.gui.legendPanel.repaint();
                this.dArea.getEditPointList().clear();
            }
        } else {
            this.mImage1 = null;
            this.gui.chBoxPanel2.remove(this.gui.mapCheckBox);
            this.gui.chBoxPanel2.revalidate();
            this.dArea.resetAdjustRaster();
            this.resetView();
            this.gui.statusBar.setText("");
            this.gpsData = null;
            this.dArea.getGpsTrackList().clear();
            this.dArea.getGpsWayPointList().clear();
            this.gui.chBoxPanel2.remove(this.gui.gpsCheckBox);
            this.gui.chBoxPanel2.revalidate();
        }
        this.updateDrawingArea();
    }

    private void closeGPSData() {
        this.gpsData = null;
        this.dArea.getGpsTrackList().clear();
        this.dArea.getGpsWayPointList().clear();
        this.gui.chBoxPanel2.remove(this.gui.gpsCheckBox);
        this.gui.chBoxPanel2.revalidate();
        this.dArea.repaint();
    }

    private void closeMap() {
        this.mImage1 = null;
        this.dArea.resetAdjustRaster();
        this.resetView();
        this.gui.chBoxPanel2.remove(this.gui.mapCheckBox);
        this.gui.chBoxPanel2.revalidate();
        if (this.actRImage != null) {
            int i = 0;
            while (i < this.rasImageStack.size()) {
                ((RasterImage)this.rasImageStack.get(i)).changeAlpha(255);
                ++i;
            }
        }
        this.updateDrawingArea();
    }

    private void createAndShowGui() {
        this.gui = new GUI();
        this.gui.addWindowStateListener(this);
        this.gui.drawingAreaScrollPane.getVerticalScrollBar().addMouseListener(this);
        this.gui.drawingAreaScrollPane.getHorizontalScrollBar().addMouseListener(this);
        this.gui.drawingAreaScrollPane.addMouseWheelListener(this);
        this.gui.openButton.addActionListener(new GUI_openButton_actionAdapter1(this));
        this.gui.jMenuFileOpen.addActionListener(new GUI_openButton_actionAdapter1(this));
        this.gui.jMenuFileClose.addActionListener(new GUI_jMenuFileClose_actionAdapter(this));
        this.gui.jMenuFileSave.addActionListener(new GUI_jMenuFileSave_actionAdapter(this));
        this.gui.jMenuFileSaveAs.addActionListener(new GUI_jMenuFileSaveAs_actionAdapter1(this));
        this.gui.jMenuFileSelect.addActionListener(new GUI_jMenuFileSelect_actionAdapter(this));
        this.gui.saveButton.addActionListener(new GUI_saveButton_actionAdapter(this));
        this.gui.selectButton.addActionListener(new GUI_selectButton_actionAdapter(this));
        this.gui.editButton.addActionListener(new GUI_editButton_actionAdapter1(this));
        this.gui.jMenuEditActLayer.addActionListener(new GUI_editButton_actionAdapter1(this));
        this.gui.jMenuEditUndo.addActionListener(new GUI_jMenuEditUndo_actionAdapter(this));
        this.gui.jMenuEditRedo.addActionListener(new GUI_jMenuEditRedo_actionAdapter(this));
        this.gui.undoButton.addActionListener(new GUI_jMenuEditUndo_actionAdapter(this));
        this.gui.redoButton.addActionListener(new GUI_jMenuEditRedo_actionAdapter(this));
        this.gui.jMenuEditCreate.addActionListener(new GUI_jMenuEditCreate_actionAdapter(this));
        this.gui.zoomInButton.addActionListener(new GUI_zoomInButton_actionAdapter(this));
        this.gui.zoomOutButton.addActionListener(new GUI_zoomOutButton_actionAdapter(this));
        this.gui.resetViewButton.addActionListener(new GUI_resetViewButton_actionAdapter(this));
        this.gui.jMenuViewZoomIn.addActionListener(new GUI_zoomInButton_actionAdapter(this));
        this.gui.jMenuViewZoomOut.addActionListener(new GUI_zoomOutButton_actionAdapter(this));
        this.gui.jMenuViewResetView.addActionListener(new GUI_resetViewButton_actionAdapter(this));
        this.gui.jMenuViewAlpha.addActionListener(new GUI_jMenuViewAlpha_actionAdapter1(this));
        this.gui.jMenuViewColor.addActionListener(new GUI_jMenuViewColor_actionAdapter(this));
        this.gui.jMenuOptionsRaster.addActionListener(new GUI_jMenuOptionsRaster_actionAdapter(this));
        this.gui.jMenuOptionsMap.addActionListener(new GUI_jMenuOptionsMap_actionAdapter(this));
        this.gui.mapCheckBox.addActionListener(new GUI_mapCheckBox_actionAdapter(this));
        this.gui.gpsCheckBox.addActionListener(new GUI_gpsCheckBox_actionAdapter(this));
        this.gui.prevImageButton.addActionListener(new GUI_prevImageButton_actionAdapter(this));
        this.gui.nextImageButton.addActionListener(new GUI_nextImageButton_actionAdapter(this));
        this.gui.jPopMenuCloseMap.addActionListener(new GUI_jPopMenuCloseMap_actionAdapter(this));
        this.gui.jPopMenuHideMap.addActionListener(new GUI_jPopMenuHideMap_actionAdapter(this));
        this.gui.jPopMenuToFront.addActionListener(new GUI_jPopMenuToFront_actionAdapter(this));
        this.gui.evd.nextButton.addActionListener(new EditValueDialog_nextButton_actionAdapter(this));
        this.gui.sccd.okButton.addActionListener(new SurCodeCreateDialog_okButton_actionAdapter(this));
        this.gui.sccd.cancelButton.addActionListener(new SurCodeCreateDialog_cancelButton_actionAdapter1(this));
        this.gui.scmd.okButton.addActionListener(new SurCodeMessageDialog_okButton_actionAdapter(this));
        this.gui.scmd.cancelButton.addActionListener(new SurCodeMessageDialog_cancelButton_actionAdapter(this));
        this.gui.scmd.backButton.addActionListener(new SurCodeMessageDialog_backButton_actionAdapter(this));
        this.gui.spcd.okButton.addActionListener(new SpecialPointCreateDialog_okButton_actionAdapter1(this));
        if (this.packFrame) {
            this.gui.pack();
        } else {
            this.gui.validate();
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.gui.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.gui.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.gui.setVisible(true);
    }

    private void createDashedLine(MouseEvent e) {
        Line2D.Double line = new Line2D.Double(Utils.transformRasterToDrawingAreaPixel((Point2D.Float)this.dArea.getEditPointList().get(this.dArea.getEditPointList().size() - 1), this.dArea), e.getPoint());
        this.dArea.setDashedLine(line);
        this.dArea.repaint();
    }

    private void createLegend() {
        int fileSpecifier = ((RasterImage)this.rasImageStack.peek()).getFileSpecifier();
        FileSpecIF strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
        this.gui.LegendColorPanel.removeAll();
        this.gui.LegendTextPanel.removeAll();
        this.gui.LegendTextPanel.repaint();
        this.gui.LegendColorPanel.repaint();
        this.gui.deviceLabel.setText(strategy.getFiletype() + " " + strategy.getUnit());
        int i = strategy.getLegendText(this.actRImage).length - 1;
        while (i >= 0) {
            this.gui.LegendTextPanel.add((JLabel)strategy.getLegendText(this.actRImage)[i]);
            this.gui.LegendColorPanel.add((JPanel)strategy.getLegendColors(this.actRImage)[i]);
            --i;
        }
        this.gui.LegendTextPanel.revalidate();
        this.gui.LegendColorPanel.revalidate();
    }

    private void createLinesOrPolygons(MouseEvent e) {
        if (e.getClickCount() == 1) {
            this.dArea.getEditPointList().add(Utils.transformDrawingAreaPixelToRaster(e.getPoint(), this.dArea));
            this.dArea.repaint();
        }
        if (e.getClickCount() == 2) {
            EditMethodDialog cfr_ignored_0 = this.gui.emd;
            if (this.gui.emd.getEditMethod() == 0) {
                this.endOfDrawing();
            } else if (this.dArea.getEditPointList().size() > 2) {
                this.endOfDrawing();
            }
        }
    }

    private void createRectangle(MouseEvent e) {
        int width = (int)((double)e.getX() - this.dArea.getRectangle().getX());
        int height = (int)((double)e.getY() - this.dArea.getRectangle().getX());
        this.dArea.getRectangle().setSize(width, height);
        this.setSccdlrPoint(e);
        this.gui.sccd.setDrawPossible(false);
        this.gui.sccd.toFront();
    }

    private void deleteHistory() {
        this.lusPointMap.clear();
        this.lusUndoIndexMap.clear();
        this.lusPointList.clear();
        this.lusEditIndex = -1;
        this.sDPointMap.clear();
        this.sDUndoIndexMap.clear();
        this.sDPointList.clear();
        this.sDEditIndex = -1;
        this.fCPointMap.clear();
        this.fCUndoIndexMap.clear();
        this.fCPointList.clear();
        this.fCEditIndex = -1;
    }

    private void deleteUndoValuesBiggerThanIndex() {
        int k;
        ArrayList valueList;
        int undoIndex;
        int j;
        int i;
        int i2;
        int count;
        int size;
        if (!this.lusPointList.isEmpty() && this.lusEditIndex < this.lusPointList.size() - 1) {
            size = this.lusPointList.size();
            count = 0;
            i2 = this.lusEditIndex + 1;
            while (i2 < size) {
                this.lusPointList.remove(i2 - count);
                ++count;
                ++i2;
            }
        }
        if (!this.sDPointList.isEmpty() && this.sDEditIndex < this.sDPointList.size() - 1) {
            size = this.sDPointList.size();
            count = 0;
            i2 = this.sDEditIndex + 1;
            while (i2 < size) {
                this.sDPointList.remove(i2 - count);
                ++count;
                ++i2;
            }
        }
        if (!this.fCPointList.isEmpty() && this.fCEditIndex < this.fCPointList.size() - 1) {
            size = this.fCPointList.size();
            count = 0;
            i2 = this.fCEditIndex + 1;
            while (i2 < size) {
                this.fCPointList.remove(i2 - count);
                ++count;
                ++i2;
            }
        }
        if (!this.lusPointMap.isEmpty()) {
            i = 0;
            while (i < this.actRImage.getSurfaceArea().getNRows()) {
                j = 0;
                while (j < this.actRImage.getSurfaceArea().getNCols()) {
                    Point p = new Point(j, i);
                    if (this.lusPointMap.containsKey(p)) {
                        undoIndex = (Integer)this.lusUndoIndexMap.get(p);
                        valueList = (ArrayList)this.lusPointMap.get(p);
                        k = undoIndex + 1;
                        while (k < valueList.size()) {
                            valueList.remove(k);
                            ++k;
                        }
                        this.lusPointMap.put(p, valueList);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (!this.sDPointMap.isEmpty()) {
            i = 0;
            while (i < this.actRImage.getSurfaceArea().getNRows()) {
                j = 0;
                while (j < this.actRImage.getSurfaceArea().getNCols()) {
                    Point p = new Point(j, i);
                    if (this.sDPointMap.containsKey(p)) {
                        undoIndex = (Integer)this.sDUndoIndexMap.get(p);
                        valueList = (ArrayList)this.sDPointMap.get(p);
                        k = undoIndex + 1;
                        while (k < valueList.size()) {
                            valueList.remove(k);
                            ++k;
                        }
                        this.sDPointMap.put(p, valueList);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (!this.lusPointMap.isEmpty()) {
            i = 0;
            while (i < this.actRImage.getSurfaceArea().getNRows()) {
                j = 0;
                while (j < this.actRImage.getSurfaceArea().getNCols()) {
                    Point p = new Point(j, i);
                    if (this.fCPointMap.containsKey(p)) {
                        undoIndex = (Integer)this.fCUndoIndexMap.get(p);
                        valueList = (ArrayList)this.fCPointMap.get(p);
                        k = undoIndex + 1;
                        while (k < valueList.size()) {
                            valueList.remove(k);
                            ++k;
                        }
                        this.fCPointMap.put(p, valueList);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void drawGPSData(GPSData gpsData) {
        Object[] wpl = gpsData.getWayPointList().toArray();
        int i = 0;
        while (i < wpl.length) {
            wpl[i] = (Point2D.Float)gpsData.getWayPointList().get(i);
            this.dArea.getGpsWayPointList().add(wpl[i]);
            ++i;
        }
        if (!gpsData.getTrackList().isEmpty()) {
            int i2 = 0;
            while (i2 < gpsData.getTrackList().size()) {
                this.dArea.getGpsTrackList().add(gpsData.getTrackList().get(i2));
                ++i2;
            }
        }
        this.dArea.repaint();
    }

    private void editAndRememberValues(ArrayList actPL, ArrayList sdPL, ArrayList fcPL, int y, int x) {
        int undoIndex;
        ArrayList valueList;
        Point p;
        int k;
        int fileSpecifier = ((RasterImage)this.rasImageStack.peek()).getFileSpecifier();
        FileSpecIF strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
        if (this.gui.evd.getOldValues() != null) {
            k = 0;
            while (k < this.gui.evd.getOldValues().length) {
                p = new Point(x, y);
                try {
                    if (!actPL.contains(p) && strategy.getValue(this.actRImage.getSurfaceArea(), y, x) == (float)this.gui.evd.getOldValues()[k]) {
                        if (strategy.getPointMap(this).containsKey(p)) {
                            valueList = (ArrayList)strategy.getPointMap(this).get(p);
                            valueList.add(new Integer(this.gui.evd.getNewValue()));
                            undoIndex = (Integer)strategy.getUndoIndexMap(this).get(p);
                        } else {
                            valueList = new ArrayList();
                            valueList.add(new Integer((int)strategy.getValue(this.actRImage.getSurfaceArea(), y, x)));
                            valueList.add(new Integer(this.gui.evd.getNewValue()));
                            undoIndex = 0;
                        }
                        strategy.getPointMap(this).put(p, valueList);
                        actPL.add(p);
                        strategy.getUndoIndexMap(this).put(p, new Integer(++undoIndex));
                        strategy.setValue(this.gui.evd.getNewValue(), this.actRImage.getSurfaceArea(), y, x);
                        break;
                    }
                    if (k == this.gui.evd.getOldValues().length - 1) {
                        return;
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                }
                ++k;
            }
        }
        if (this.gui.evd.getOldValues1() != null) {
            k = 0;
            while (k < this.gui.evd.getOldValues1().length) {
                p = new Point(x, y);
                try {
                    if (!sdPL.contains(p) && this.actRImage.getSurfaceArea().sPoint[y][x].getSoilDepth() == this.gui.evd.getOldValues1()[k]) {
                        if (this.sDPointMap.containsKey(p)) {
                            valueList = (ArrayList)this.sDPointMap.get(p);
                            valueList.add(new Integer(this.gui.evd.getNewValue1()));
                            undoIndex = (Integer)this.sDUndoIndexMap.get(p);
                        } else {
                            valueList = new ArrayList();
                            valueList.add(new Integer(this.actRImage.getSurfaceArea().sPoint[y][x].getSoilDepth()));
                            valueList.add(new Integer(this.gui.evd.getNewValue1()));
                            undoIndex = 0;
                        }
                        this.sDPointMap.put(p, valueList);
                        sdPL.add(p);
                        this.sDUndoIndexMap.put(p, new Integer(++undoIndex));
                        this.actRImage.getSurfaceArea().sPoint[y][x].setSoilDepth(this.gui.evd.getNewValue1());
                        break;
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                }
                ++k;
            }
        }
        if (this.gui.evd.getOldValues2() != null) {
            k = 0;
            while (k < this.gui.evd.getOldValues2().length) {
                p = new Point(x, y);
                try {
                    if (!fcPL.contains(p) && this.actRImage.getSurfaceArea().sPoint[y][x].getFieldCapacity() == this.gui.evd.getOldValues2()[k]) {
                        if (this.fCPointMap.containsKey(p)) {
                            valueList = (ArrayList)this.fCPointMap.get(p);
                            valueList.add(new Integer(this.gui.evd.getNewValue2()));
                            undoIndex = (Integer)this.fCUndoIndexMap.get(p);
                        } else {
                            valueList = new ArrayList();
                            valueList.add(new Integer(this.actRImage.getSurfaceArea().sPoint[y][x].getFieldCapacity()));
                            valueList.add(new Integer(this.gui.evd.getNewValue2()));
                            undoIndex = 0;
                        }
                        this.fCPointMap.put(p, valueList);
                        fcPL.add(p);
                        this.fCUndoIndexMap.put(p, new Integer(++undoIndex));
                        this.actRImage.getSurfaceArea().sPoint[y][x].setFieldCapacity(this.gui.evd.getNewValue2());
                        break;
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                }
                ++k;
            }
        }
    }

    private void editSurfaceCode() {
        block54: {
            int yUpLim;
            int yLowLim;
            int xUpLim;
            int xLowLim;
            ArrayList fcPL;
            ArrayList sdPL;
            ArrayList actPL;
            FileSpecIF strategy;
            block58: {
                block57: {
                    block56: {
                        block55: {
                            if (((RasterImage)this.rasImageStack.peek()).getFileSpecifier() != 100 && ((RasterImage)this.rasImageStack.peek()).getFileSpecifier() != 102 && ((RasterImage)this.rasImageStack.peek()).getFileSpecifier() != 101) break block54;
                            int fileSpecifier = ((RasterImage)this.rasImageStack.peek()).getFileSpecifier();
                            strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
                            actPL = new ArrayList();
                            sdPL = new ArrayList();
                            fcPL = new ArrayList();
                            this.deleteUndoValuesBiggerThanIndex();
                            xLowLim = 0;
                            xUpLim = this.actRImage.getSurfaceArea().getNCols();
                            yLowLim = 0;
                            yUpLim = this.actRImage.getSurfaceArea().getNRows();
                            EditMethodDialog cfr_ignored_0 = this.gui.emd;
                            if (this.gui.emd.getEditMethod() == 3) {
                                Point2D.Float pul = new Point2D.Float(this.gui.erd.getXulCorner(), this.gui.erd.getYulCorner());
                                Point2D.Float plr = new Point2D.Float(this.gui.erd.getXlrCorner(), this.gui.erd.getYlrCorner());
                                int xLowLimUser = Utils.transformGridToRaster((Point2D.Float)pul, (RasterImage)this.actRImage).x;
                                int yLowLimUser = Utils.transformGridToRaster((Point2D.Float)pul, (RasterImage)this.actRImage).y;
                                int xUpLimUser = Utils.transformGridToRaster((Point2D.Float)plr, (RasterImage)this.actRImage).x;
                                int yUpLimUser = Utils.transformGridToRaster((Point2D.Float)plr, (RasterImage)this.actRImage).y;
                                if (xLowLimUser >= 0 && xLowLimUser <= xUpLim && yLowLimUser >= 0 && yLowLimUser <= yUpLim && xUpLimUser >= 0 && xUpLimUser <= xUpLim && yUpLimUser >= 0 && yUpLimUser <= xUpLim) {
                                    xLowLim = xLowLimUser;
                                    yLowLim = yLowLimUser;
                                    xUpLim = xUpLimUser;
                                    yUpLim = yUpLimUser;
                                }
                            }
                            EditMethodDialog cfr_ignored_1 = this.gui.emd;
                            if (this.gui.emd.getEditMethod() == 0) break block55;
                            EditMethodDialog cfr_ignored_2 = this.gui.emd;
                            if (this.gui.emd.getEditMethod() != 1) break block56;
                        }
                        xLowLim = this.actRImage.getSurfaceArea().getNCols();
                        yLowLim = this.actRImage.getSurfaceArea().getNRows();
                        xUpLim = 0;
                        yUpLim = 0;
                        int i = 0;
                        while (i < this.dArea.getEditPointList().size()) {
                            Point2D.Float p = (Point2D.Float)this.dArea.getEditPointList().get(i);
                            if (p.getX() < (double)xLowLim) {
                                xLowLim = (int)p.getX();
                            } else if (p.getX() > (double)xUpLim) {
                                xUpLim = (int)p.getX();
                            }
                            if (p.getY() < (double)yLowLim) {
                                yLowLim = (int)p.getY();
                            } else if (p.getY() > (double)yUpLim) {
                                yUpLim = (int)p.getY();
                            }
                            ++i;
                        }
                    }
                    EditMethodDialog cfr_ignored_3 = this.gui.emd;
                    if (this.gui.emd.getEditMethod() == 4) break block57;
                    EditMethodDialog cfr_ignored_4 = this.gui.emd;
                    if (this.gui.emd.getEditMethod() != 3) break block58;
                }
                int i = yLowLim;
                while (i < yUpLim) {
                    int j = xLowLim;
                    while (j < xUpLim) {
                        this.editAndRememberValues(actPL, sdPL, fcPL, i, j);
                        ++j;
                    }
                    ++i;
                }
            }
            EditMethodDialog cfr_ignored_5 = this.gui.emd;
            if (this.gui.emd.getEditMethod() == 0) {
                int i = yLowLim;
                while (i <= yUpLim) {
                    int j = xLowLim;
                    while (j <= xUpLim) {
                        int ln = 0;
                        while (ln < this.dArea.getEditPointList().size() - 1) {
                            int n;
                            int m;
                            Point2D.Float p1 = (Point2D.Float)this.dArea.getEditPointList().get(ln);
                            Point2D.Float p2 = (Point2D.Float)this.dArea.getEditPointList().get(ln + 1);
                            Line2D.Float line = new Line2D.Float(p1, p2);
                            if (Utils.isEven(this.gui.evd.getEditWidthFactor())) {
                                if (line.intersects((double)j + 0.5, (double)i + 0.5, 1.0, 1.0)) {
                                    m = i - (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 1.0);
                                    while (m <= i + (int)((double)this.gui.evd.getEditWidthFactor() / 2.0)) {
                                        n = j - (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 1.0);
                                        while (n <= j + (int)((double)this.gui.evd.getEditWidthFactor() / 2.0)) {
                                            this.editAndRememberValues(actPL, sdPL, fcPL, m, n);
                                            ++n;
                                        }
                                        ++m;
                                    }
                                }
                            } else if (line.intersects(j, i, 1.0, 1.0)) {
                                m = i - (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 0.5);
                                while (m <= i + (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 0.5)) {
                                    n = j - (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 0.5);
                                    while (n <= j + (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 0.5)) {
                                        this.editAndRememberValues(actPL, sdPL, fcPL, m, n);
                                        ++n;
                                    }
                                    ++m;
                                }
                            }
                            ++ln;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            EditMethodDialog cfr_ignored_6 = this.gui.emd;
            if (this.gui.emd.getEditMethod() == 1) {
                int npoints = this.dArea.getEditPointList().size();
                int[] xpoints = new int[npoints];
                int[] ypoints = new int[npoints];
                int i = 0;
                while (i < npoints) {
                    xpoints[i] = (int)Utils.transformRasterToDrawingAreaPixel((Point2D.Float)this.dArea.getEditPointList().get(i), this.dArea).getX();
                    ypoints[i] = (int)Utils.transformRasterToDrawingAreaPixel((Point2D.Float)this.dArea.getEditPointList().get(i), this.dArea).getY();
                    ++i;
                }
                Polygon pol = new Polygon(xpoints, ypoints, npoints);
                int i2 = yLowLim;
                while (i2 <= yUpLim) {
                    int j = xLowLim;
                    while (j <= xUpLim) {
                        Rectangle2D.Double rec = new Rectangle2D.Double((double)j * this.dArea.getZoom() / this.dArea.getAdjustRasX() + (double)this.dArea.getXulRCoord() * this.dArea.getZoom(), (double)i2 * this.dArea.getZoom() / this.dArea.getAdjustRasX() + (double)this.dArea.getYulRCoord() * this.dArea.getZoom(), this.dArea.getZoom() / this.dArea.getAdjustRasX(), this.dArea.getZoom() / this.dArea.getAdjustRasX());
                        if (!this.gui.evd.isEditInside()) {
                            if (pol.intersects(rec)) {
                                this.editAndRememberValues(actPL, sdPL, fcPL, i2, j);
                            }
                        } else if (pol.contains(rec)) {
                            this.editAndRememberValues(actPL, sdPL, fcPL, i2, j);
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            strategy.setEditIndex(this, strategy.getEditIndex(this) + 1);
            if (!actPL.isEmpty()) {
                strategy.getPointList(this).add(actPL);
            }
            if (!sdPL.isEmpty()) {
                this.sDPointList.add(sdPL);
                ++this.sDEditIndex;
            }
            if (!fcPL.isEmpty()) {
                this.fCPointList.add(fcPL);
                ++this.fCEditIndex;
            }
            if (this.gui.evd.getOldValues1() != null) {
                int z = 0;
                while (z < this.rasImageStack.size()) {
                    if (((RasterImage)this.rasImageStack.get(z)).getFilename().equals(this.actRImage.getFilename()) && ((RasterImage)this.rasImageStack.get(z)).getFileSpecifier() == 102) {
                        ((RasterImage)this.rasImageStack.get(z)).regenerateImage(this.alpha);
                        break;
                    }
                    ++z;
                }
            }
            if (this.gui.evd.getOldValues2() != null) {
                int z = 0;
                while (z < this.rasImageStack.size()) {
                    if (((RasterImage)this.rasImageStack.get(z)).getFilename().equals(this.actRImage.getFilename()) && ((RasterImage)this.rasImageStack.get(z)).getFileSpecifier() == 101) {
                        ((RasterImage)this.rasImageStack.get(z)).regenerateImage(this.alpha);
                        break;
                    }
                    ++z;
                }
            }
            ((RasterImage)this.rasImageStack.peek()).regenerateImage(this.alpha);
            this.updateDrawingArea();
            this.gui.evd.deleteOldValues();
        }
    }

    private void editSurfacePoints(MouseEvent e) {
        if (((RasterImage)this.rasImageStack.peek()).getFileSpecifier() == 100 || ((RasterImage)this.rasImageStack.peek()).getFileSpecifier() == 102 || ((RasterImage)this.rasImageStack.peek()).getFileSpecifier() == 101) {
            int z;
            int n;
            int m;
            int fileSpecifier = ((RasterImage)this.rasImageStack.peek()).getFileSpecifier();
            FileSpecIF strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
            ArrayList actPL = new ArrayList();
            ArrayList sdPL = new ArrayList();
            ArrayList fcPL = new ArrayList();
            this.deleteUndoValuesBiggerThanIndex();
            double y = (double)e.getY() / this.dArea.getZoom() * this.dArea.getAdjustRasX() - (double)this.dArea.getYulRCoord() * this.dArea.getAdjustRasX();
            double x = (double)e.getX() / this.dArea.getZoom() * this.dArea.getAdjustRasX() - (double)this.dArea.getXulRCoord() * this.dArea.getAdjustRasX();
            int i = (int)y;
            int j = (int)x;
            if (Utils.isEven(this.gui.evd.getEditWidthFactor())) {
                if (y < (double)i + 0.5) {
                    --i;
                }
                if (x < (double)j + 0.5) {
                    --j;
                }
                m = i - (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 1.0);
                while (m <= i + (int)((double)this.gui.evd.getEditWidthFactor() / 2.0)) {
                    n = j - (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 1.0);
                    while (n <= j + (int)((double)this.gui.evd.getEditWidthFactor() / 2.0)) {
                        this.editAndRememberValues(actPL, sdPL, fcPL, m, n);
                        ++n;
                    }
                    ++m;
                }
            } else {
                m = i - (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 0.5);
                while (m <= i + (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 0.5)) {
                    n = j - (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 0.5);
                    while (n <= j + (int)((double)this.gui.evd.getEditWidthFactor() / 2.0 - 0.5)) {
                        int k = 0;
                        while (k < this.gui.evd.getOldValues().length) {
                            this.editAndRememberValues(actPL, sdPL, fcPL, m, n);
                            ++k;
                        }
                        ++n;
                    }
                    ++m;
                }
            }
            strategy.setEditIndex(this, strategy.getEditIndex(this) + 1);
            if (!actPL.isEmpty()) {
                strategy.getPointList(this).add(actPL);
            }
            if (!sdPL.isEmpty()) {
                this.sDPointList.add(sdPL);
                ++this.sDEditIndex;
            }
            if (!fcPL.isEmpty()) {
                this.fCPointList.add(fcPL);
                ++this.fCEditIndex;
            }
            if (this.gui.evd.getOldValues1() != null) {
                z = 0;
                while (z < this.rasImageStack.size()) {
                    if (((RasterImage)this.rasImageStack.get(z)).getFilename().equals(this.actRImage.getFilename()) && ((RasterImage)this.rasImageStack.get(z)).getFileSpecifier() == 102) {
                        ((RasterImage)this.rasImageStack.get(z)).regenerateImage(this.alpha);
                        break;
                    }
                    ++z;
                }
            }
            if (this.gui.evd.getOldValues2() != null) {
                z = 0;
                while (z < this.rasImageStack.size()) {
                    if (((RasterImage)this.rasImageStack.get(z)).getFilename().equals(this.actRImage.getFilename()) && ((RasterImage)this.rasImageStack.get(z)).getFileSpecifier() == 101) {
                        ((RasterImage)this.rasImageStack.get(z)).regenerateImage(this.alpha);
                        break;
                    }
                    ++z;
                }
            }
            ((RasterImage)this.rasImageStack.peek()).regenerateImage(this.alpha);
            this.updateDrawingArea();
        }
    }

    private void enableButtons() {
        if (!this.rasImageStack.isEmpty()) {
            if (((RasterImage)this.rasImageStack.peek()).getFileSpecifier() == 100 || ((RasterImage)this.rasImageStack.peek()).getFileSpecifier() == 102 || ((RasterImage)this.rasImageStack.peek()).getFileSpecifier() == 101) {
                this.gui.jMenuViewColor.setEnabled(false);
                this.gui.editButton.setEnabled(true);
                this.gui.jMenuEditActLayer.setEnabled(true);
                this.gui.undoButton.setEnabled(true);
                this.gui.redoButton.setEnabled(true);
                this.gui.jMenuEditRedo.setEnabled(true);
                this.gui.jMenuEditUndo.setEnabled(true);
            } else {
                this.gui.jMenuViewColor.setEnabled(true);
                this.gui.editButton.setEnabled(false);
                this.gui.jMenuEditActLayer.setEnabled(false);
                this.gui.undoButton.setEnabled(false);
                this.gui.redoButton.setEnabled(false);
                this.gui.jMenuEditRedo.setEnabled(false);
                this.gui.jMenuEditUndo.setEnabled(false);
            }
        }
        if (this.mImage1 == null || this.rasImageStack.isEmpty()) {
            this.gui.jMenuViewAlpha.setEnabled(false);
        } else {
            this.gui.jMenuViewAlpha.setEnabled(true);
        }
        if (this.mImage1 == null) {
            this.gui.jMenuOptionsMap.setEnabled(false);
        } else {
            this.gui.jMenuOptionsMap.setEnabled(true);
        }
        if (this.rasImageStack.isEmpty()) {
            this.gui.jMenuOptionsRaster.setEnabled(false);
            this.gui.jMenuAlp3DCreate.setEnabled(false);
        } else {
            this.gui.jMenuOptionsRaster.setEnabled(true);
            this.gui.jMenuAlp3DCreate.setEnabled(true);
        }
    }

    private void endOfDrawing() {
        block8: {
            int opt;
            block5: {
                block7: {
                    block6: {
                        this.dArea.setDashedLine(null);
                        this.updateDrawingArea();
                        EditMethodDialog cfr_ignored_0 = this.gui.emd;
                        opt = this.gui.emd.getEditMethod() == 1 ? JOptionPane.showConfirmDialog(this.gui, "Finished drawing, close polygon?") : JOptionPane.showConfirmDialog(this.gui, "Finished drawing?");
                        if (opt != 2) break block5;
                        this.gui.emd.setDrawPossible(false);
                        EditMethodDialog cfr_ignored_1 = this.gui.emd;
                        if (this.gui.emd.getEditMethod() == 1) break block6;
                        EditMethodDialog cfr_ignored_2 = this.gui.emd;
                        if (this.gui.emd.getEditMethod() != 0) break block7;
                    }
                    this.dArea.getEditPointList().clear();
                }
                this.dArea.repaint();
                this.gui.statusBar.setText("");
                break block8;
            }
            if (opt == 0) {
                EditMethodDialog cfr_ignored_3 = this.gui.emd;
                if (this.gui.emd.getEditMethod() == 1) {
                    this.dArea.getEditPointList().add(this.dArea.getEditPointList().get(0));
                    this.dArea.repaint();
                }
                this.gui.emd.setDrawPossible(false);
                this.showEditValueDialog();
            }
        }
    }

    public int getFCEditIndex() {
        return this.fCEditIndex;
    }

    public ArrayList getFCPointList() {
        return this.fCPointList;
    }

    public Map getFCPointMap() {
        return this.fCPointMap;
    }

    public Map getFCUndoIndexMap() {
        return this.fCUndoIndexMap;
    }

    public int getLusEditIndex() {
        return this.lusEditIndex;
    }

    public ArrayList getLusPointList() {
        return this.lusPointList;
    }

    public Map getLusPointMap() {
        return this.lusPointMap;
    }

    public Map getLusUndoIndexMap() {
        return this.lusUndoIndexMap;
    }

    public int getSDEditIndex() {
        return this.sDEditIndex;
    }

    public ArrayList getSDPointList() {
        return this.sDPointList;
    }

    public Map getSDPointMap() {
        return this.sDPointMap;
    }

    public Map getSDUndoIndexMap() {
        return this.sDUndoIndexMap;
    }

    private void loadCheckBoxPanel() {
        JRadioButton rB = this.actRImage.getRadioButton();
        rB.addActionListener(new GUI_radioButtStack_actionAdapter(this));
        this.gui.radioButtGroup.add(rB);
        rB.setSelected(true);
        this.gui.chBoxPanel1.add(rB);
        this.gui.chBoxPanel1.revalidate();
    }

    private void loadRasterImage(File file, int fileSpecifier) throws IOException {
        if (fileSpecifier == 100 || fileSpecifier == 102 || fileSpecifier == 101) {
            this.deleteHistory();
        }
        if (this.mImage1 == null || !this.mImage1.isGeoreferenced()) {
            this.rasImageStack.push(new RasterImage(fileSpecifier, file.getAbsolutePath(), 255));
            this.alpha = 255;
        } else if (this.dArea.isMImageHidden()) {
            this.rasImageStack.push(new RasterImage(fileSpecifier, file.getAbsolutePath(), 255));
        } else if (this.alphaIsSet) {
            this.rasImageStack.push(new RasterImage(fileSpecifier, file.getAbsolutePath(), this.alpha));
        } else {
            this.rasImageStack.push(new RasterImage(fileSpecifier, file.getAbsolutePath(), 130));
            this.alpha = 130;
        }
        this.actRImage = (RasterImage)this.rasImageStack.peek();
        this.loadCheckBoxPanel();
        this.gui.statusBar.setForeground(Color.black);
        this.gui.statusBar.setText(this.actRImage.getFilename());
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new Alpine3D();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mouseClicked(MouseEvent e) {
        if (this.gui.infoButton.isSelected() && e.getSource().equals(this.dArea)) {
            this.showPointDialog(e);
            return;
        }
        if (this.gui.editButton.isSelected()) {
            EditMethodDialog cfr_ignored_0 = this.gui.emd;
            if (this.gui.emd.getEditMethod() == 2 && e.getSource().equals(this.dArea)) {
                this.editSurfacePoints(e);
                return;
            }
        }
        if (!this.gui.editButton.isSelected()) return;
        EditMethodDialog cfr_ignored_1 = this.gui.emd;
        if (this.gui.emd.getEditMethod() != 5) return;
        if (!e.getSource().equals(this.dArea)) return;
        this.undoOnMouseClick(e);
    }

    public void mouseDragged(MouseEvent e) {
        if (this.gui.sccd.drawIsPossible()) {
            int width = (int)((double)e.getX() - this.dArea.getRectangle().getX());
            int height = (int)((double)e.getY() - this.dArea.getRectangle().getY());
            this.dArea.getRectangle().setSize(width, height);
            this.dArea.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.setGridCoord(e);
        this.setActValue(e);
        this.setSpecialPointInfo(e);
        if (this.gui.emd.isDrawPossible() && this.dArea.getEditPointList().size() >= 1) {
            this.createDashedLine(e);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource().equals(this.gui.drawingAreaScrollPane.getHorizontalScrollBar()) || e.getSource().equals(this.gui.drawingAreaScrollPane.getVerticalScrollBar())) {
            int i = 0;
            while (i < this.pointDialogArr.size()) {
                ((PointDialog)this.pointDialogArr.get(i)).dispose();
                ++i;
            }
            this.pointDialogArr.clear();
        } else if (this.gui.sccd.drawIsPossible()) {
            this.dArea.initRectangle(new Point(e.getX(), e.getY()));
            this.setSccdulPoint(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.setSpecialPointPosition(e);
        if (this.gui.emd.isDrawPossible()) {
            this.createLinesOrPolygons(e);
        }
        if (this.gui.sccd.drawIsPossible()) {
            this.createRectangle(e);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getSource().equals(this.gui.drawingAreaScrollPane)) {
            int i = 0;
            while (i < this.pointDialogArr.size()) {
                ((PointDialog)this.pointDialogArr.get(i)).dispose();
                ++i;
            }
            this.pointDialogArr.clear();
        }
    }

    private void openFile() {
        block39: {
            this.currFile = this.gui.ofc.jFileChooser1.getSelectedFile();
            int fileSpecifier = -1;
            try {
                if (this.gui.ofc.radioButtonIn.isSelected()) {
                    switch (this.gui.ofc.comboBoxIn.getSelectedIndex()) {
                        case 0: {
                            fileSpecifier = 1;
                            this.loadRasterImage(this.currFile, fileSpecifier);
                            break;
                        }
                        case 1: {
                            fileSpecifier = 100;
                            this.loadRasterImage(this.currFile, 101);
                            SurfaceArea sArea = this.actRImage.getSurfaceArea();
                            this.loadRasterImage(this.currFile, 102);
                            this.actRImage.setSurfaceArea(sArea);
                            this.actRImage.regenerateImage(this.alpha);
                            this.loadRasterImage(this.currFile, fileSpecifier);
                            this.actRImage.setSurfaceArea(sArea);
                            this.actRImage.regenerateImage(this.alpha);
                            this.gui.statusBar.setForeground(Color.black);
                            this.gui.statusBar.setText(this.currFile.getAbsolutePath());
                        }
                    }
                    break block39;
                }
                if (this.gui.ofc.radioButtonOut.isSelected()) {
                    switch (this.gui.ofc.comboBoxOut.getSelectedIndex()) {
                        case 0: {
                            fileSpecifier = 6;
                            break;
                        }
                        case 1: {
                            fileSpecifier = 3;
                            break;
                        }
                        case 2: {
                            fileSpecifier = 4;
                            break;
                        }
                        case 3: {
                            fileSpecifier = 5;
                            break;
                        }
                        case 4: {
                            fileSpecifier = 9;
                            break;
                        }
                        case 5: {
                            fileSpecifier = 7;
                            break;
                        }
                        case 6: {
                            fileSpecifier = 8;
                            break;
                        }
                        case 7: {
                            fileSpecifier = 10;
                        }
                    }
                    this.loadRasterImage(this.currFile, fileSpecifier);
                    break block39;
                }
                if (!this.gui.ofc.radioButtonAdd.isSelected()) break block39;
                switch (this.gui.ofc.comboBoxAdd.getSelectedIndex()) {
                    case 0: {
                        this.mImage1 = new MapImage(this.currFile);
                        this.gui.chBoxPanel2.add(this.gui.mapCheckBox);
                        this.gui.mapCheckBox.setSelected(true);
                        this.gui.chBoxPanel2.revalidate();
                        if (this.mImage1.ex1.getMessage() != null) {
                            this.gui.statusBar.setForeground(Color.black);
                            this.gui.statusBar.setText("Load Map with WorldFile " + this.mImage1.getWorldFileName2());
                        }
                        if (this.mImage1.ex2.getMessage() != null) {
                            this.gui.statusBar.setForeground(Color.black);
                            this.gui.statusBar.setText("Load Map with WorldFile " + this.mImage1.getWorldFileName3());
                        }
                        if (this.mImage1.exFinal.getMessage() != null) {
                            this.gui.statusBar.setForeground(Color.red);
                            this.gui.statusBar.setText("Cannot find WorldFile, Georeferencing is not possible.");
                            break;
                        }
                        this.gui.statusBar.setForeground(Color.black);
                        this.gui.statusBar.setText("Load Map with WorldFile " + this.mImage1.getWorldFileName1());
                        if (!this.rasImageStack.isEmpty()) {
                            if (this.alpha == 255) {
                                this.alpha = 130;
                            }
                            int i = 0;
                            while (i < this.rasImageStack.size()) {
                                ((RasterImage)this.rasImageStack.get(i)).changeAlpha(this.alpha);
                                ++i;
                            }
                        }
                        break;
                    }
                    case 1: {
                        if (this.mImage1 != null || !this.rasImageStack.isEmpty()) {
                            try {
                                if (this.gpsData == null) {
                                    this.gpsData = new GPSData(this.currFile);
                                } else {
                                    this.gpsData.readFile(this.currFile);
                                }
                                this.drawGPSData(this.gpsData);
                                this.gui.chBoxPanel2.add(this.gui.gpsCheckBox);
                                this.gui.gpsCheckBox.setSelected(true);
                                this.gui.chBoxPanel2.revalidate();
                                this.gui.statusBar.setForeground(Color.black);
                                this.gui.statusBar.setText("Load GPS File " + this.currFile.getAbsolutePath());
                            }
                            catch (IOException ex) {
                                System.out.println(ex.getMessage());
                                this.gui.statusBar.setForeground(Color.red);
                                this.gui.statusBar.setText("Can't read GPS data.");
                            }
                            break;
                        }
                        this.gui.statusBar.setForeground(Color.red);
                        this.gui.statusBar.setText("Open a Map or a Raster Image before");
                        break;
                    }
                    case 2: {
                        if (this.actRImage != null) {
                            SNOWPACKFile sF = new SNOWPACKFile(this.currFile, this.actRImage.getSurfaceArea());
                            if (!this.SN_FileList.isEmpty()) {
                                int i = 0;
                                while (i < this.SN_FileList.size()) {
                                    if (((SNOWPACKFile)this.SN_FileList.get(i)).getLocation().equals(sF.getLocation())) {
                                        this.gui.statusBar.setForeground(Color.red);
                                        this.gui.statusBar.setText("Do not load two files with the same location (x,y)");
                                        return;
                                    }
                                    ++i;
                                }
                            }
                            this.SN_FileList.add(sF);
                            ArrayList snList = this.dArea.getSNOWPACKPointList();
                            snList.add(new Point(sF.getXCoord(), sF.getYcoord()));
                            if (this.startFrame == null) {
                                this.startFrame = new StartFrame();
                                StartFrame.positionFrame(this.startFrame, 40, 50, Setup.m_DisplayMode);
                            }
                            this.startFrame.openSelectedFile(this.currFile);
                            this.startFrame.mFrame.toFront();
                            break;
                        }
                        this.gui.statusBar.setForeground(Color.red);
                        this.gui.statusBar.setText("Activate an appropriate raster image before");
                    }
                }
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
        this.updateDrawingArea();
        this.resetView();
    }

    public void propertyChange(PropertyChangeEvent e) {
        int i = 0;
        while (i < this.pointDialogArr.size()) {
            ((PointDialog)this.pointDialogArr.get(i)).dispose();
            ++i;
        }
        this.pointDialogArr.clear();
    }

    private void redo() {
        if (this.actRImage.getFileSpecifier() == 100 || this.actRImage.getFileSpecifier() == 102 || this.actRImage.getFileSpecifier() == 101) {
            int fileSpecifier = this.actRImage.getFileSpecifier();
            FileSpecIF strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
            if (strategy.getEditIndex(this) < strategy.getPointList(this).size() - 1) {
                int editIndex = strategy.getEditIndex(this) + 1;
                ArrayList aL = (ArrayList)strategy.getPointList(this).get(editIndex);
                int i = 0;
                while (i < aL.size()) {
                    Point p = (Point)aL.get(i);
                    int undoIndex = (Integer)strategy.getUndoIndexMap(this).get(p) + 1;
                    ArrayList undoValues = (ArrayList)strategy.getPointMap(this).get(p);
                    int value = (Integer)undoValues.get(undoIndex);
                    strategy.setValue(value, this.actRImage.getSurfaceArea(), (int)p.getY(), (int)p.getX());
                    strategy.getUndoIndexMap(this).put(p, new Integer(undoIndex));
                    ++i;
                }
                strategy.setEditIndex(this, strategy.getEditIndex(this) + 1);
                this.actRImage.regenerateImage(this.alpha);
            }
            this.updateDrawingArea();
        }
    }

    private void resetView() {
        double posY;
        double posX;
        if (this.actRImage != null && this.mImage1 != null) {
            if ((double)this.actRImage.getImage().getWidth(null) / this.dArea.getAdjustRasX() < (double)this.mImage1.getImage().getWidth(null)) {
                this.dArea.setZoom(822.0 / (double)this.actRImage.getImage().getWidth(null) * this.dArea.getAdjustRasX());
                posX = (double)this.dArea.getXulRCoord() * this.dArea.getZoom();
                posY = (double)this.dArea.getYulRCoord() * this.dArea.getZoom();
            } else {
                this.dArea.setZoom(1000.0 / (double)this.mImage1.getImage().getWidth(null));
                posX = (double)this.dArea.getXulMCoord() * this.dArea.getZoom();
                posY = (double)this.dArea.getYulMCoord() * this.dArea.getZoom();
            }
        } else if (this.actRImage != null) {
            this.dArea.setZoom(822.0 / (double)this.actRImage.getImage().getWidth(null) * this.dArea.getAdjustRasX());
            posX = 0.0;
            posY = 0.0;
        } else if (this.mImage1 != null) {
            this.dArea.setZoom(1000.0 / (double)this.mImage1.getImage().getWidth(null));
            posX = 0.0;
            posY = 0.0;
        } else {
            posX = 0.0;
            posY = 0.0;
        }
        this.viewPos.setLocation(posX, posY);
        this.dArea.georeferenceImages(this.mImage1, this.actRImage);
        this.dArea.setZoomChanged(false);
        this.dArea.repaint();
        this.gui.drawingAreaScrollPane.getViewport().add((Component)this.dArea, null);
        this.gui.drawingAreaScrollPane.getViewport().setViewPosition(this.viewPos);
        this.setScale();
        int i = 0;
        while (i < this.pointDialogArr.size()) {
            ((PointDialog)this.pointDialogArr.get(i)).dispose();
            ++i;
        }
        this.pointDialogArr.clear();
    }

    private void saveAsFile() {
        if (this.actRImage != null) {
            if (this.actRImage.getFilename().equals(new File("temp.lus").getAbsolutePath())) {
                new File("temp.lus").delete();
            }
            this.gui.fileChooser.removeChoosableFileFilter(this.gui.fileChooser.getFileFilter());
            this.gui.fileChooser.setCurrentDirectory(this.currFile);
            this.gui.fileChooser.setMultiSelectionEnabled(false);
            MyFileFilter lusfilter = new MyFileFilter();
            MyFileFilter swrfilter = new MyFileFilter();
            MyFileFilter lwrfilter = new MyFileFilter();
            MyFileFilter tssfilter = new MyFileFilter();
            MyFileFilter demfilter = new MyFileFilter();
            MyFileFilter albfilter = new MyFileFilter();
            MyFileFilter sdpfilter = new MyFileFilter();
            MyFileFilter swefilter = new MyFileFilter();
            MyFileFilter wetfilter = new MyFileFilter();
            MyFileFilter txtfilter = new MyFileFilter();
            MyFileFilter imagefilter = new MyFileFilter();
            MyFileFilter snfilter = new MyFileFilter();
            lusfilter.addExtension("lus");
            swrfilter.addExtension("swr");
            lwrfilter.addExtension("lwr");
            demfilter.addExtension("dem");
            demfilter.addExtension("grd");
            albfilter.addExtension("alb");
            tssfilter.addExtension("tss");
            sdpfilter.addExtension("sdp");
            swefilter.addExtension("swe");
            wetfilter.addExtension("wet");
            imagefilter.addExtension("png");
            imagefilter.addExtension("jpg");
            imagefilter.addExtension("gif");
            snfilter.addExtension("met");
            snfilter.addExtension("pro");
            txtfilter.addExtension("txt");
            lusfilter.setDescription("Landuse Files");
            swrfilter.setDescription("Shortwave Radiation");
            lwrfilter.setDescription("Longwave Radiation");
            demfilter.setDescription("Elevation Models");
            albfilter.setDescription("Albedo");
            tssfilter.setDescription("Surface Temp.");
            sdpfilter.setDescription("Snowdepth");
            swefilter.setDescription("Snowwater Equivalent");
            wetfilter.setDescription("Snowwater Content");
            imagefilter.setDescription("Image");
            snfilter.setDescription("SNOWPACK Files");
            txtfilter.setDescription("GPS Data");
            this.gui.fileChooser.addChoosableFileFilter(demfilter);
            this.gui.fileChooser.addChoosableFileFilter(lusfilter);
            this.gui.fileChooser.addChoosableFileFilter(swrfilter);
            this.gui.fileChooser.addChoosableFileFilter(lwrfilter);
            this.gui.fileChooser.addChoosableFileFilter(tssfilter);
            this.gui.fileChooser.addChoosableFileFilter(albfilter);
            this.gui.fileChooser.addChoosableFileFilter(sdpfilter);
            this.gui.fileChooser.addChoosableFileFilter(swefilter);
            this.gui.fileChooser.addChoosableFileFilter(wetfilter);
            this.gui.fileChooser.addChoosableFileFilter(imagefilter);
            this.gui.fileChooser.addChoosableFileFilter(snfilter);
            this.gui.fileChooser.addChoosableFileFilter(txtfilter);
            this.gui.fileChooser.setAcceptAllFileFilterUsed(true);
            if (0 == this.gui.fileChooser.showSaveDialog(this.gui)) {
                try {
                    this.currFile = this.gui.fileChooser.getSelectedFile();
                    String newFilename = this.gui.fileChooser.getSelectedFile().getAbsolutePath();
                    String oldFilename = this.actRImage.getFilename();
                    if (this.actRImage.getFileSpecifier() == 100 || this.actRImage.getFileSpecifier() == 102 || this.actRImage.getFileSpecifier() == 101) {
                        new SurfaceCodeWriter(this.gui.fileChooser.getSelectedFile(), this.actRImage.getSurfaceArea());
                        this.deleteHistory();
                        int i = 0;
                        while (i < this.rasImageStack.size()) {
                            if (((RasterImage)this.rasImageStack.get(i)).getFilename().equals(oldFilename)) {
                                RasterImage rImage = (RasterImage)this.rasImageStack.get(i);
                                rImage.setFilename(newFilename);
                                rImage.getRadioButton().setActionCommand(rImage.getFileSpecifier() + newFilename);
                                rImage.getRadioButton().setToolTipText(newFilename);
                            }
                            ++i;
                        }
                    } else {
                        new ASCIIFileWriter(this.gui.fileChooser.getSelectedFile(), this.actRImage.getSurfaceArea());
                        this.actRImage.setFilename(newFilename);
                        this.actRImage.getRadioButton().setToolTipText(newFilename);
                        this.actRImage.getRadioButton().setActionCommand(newFilename);
                    }
                    this.gui.statusBar.setForeground(Color.black);
                    this.gui.statusBar.setText("Save " + this.actRImage.getFilename());
                }
                catch (IOException ex) {
                    System.out.println(ex.getMessage());
                    this.gui.statusBar.setForeground(Color.red);
                    this.gui.statusBar.setText("Can't write File");
                }
            }
        }
    }

    private void saveFile() {
        if (this.actRImage != null) {
            if (this.actRImage.getFileSpecifier() != 100 && this.actRImage.getFileSpecifier() != 102 && this.actRImage.getFileSpecifier() != 101) {
                this.saveAsFile();
            } else {
                try {
                    new SurfaceCodeWriter(new File(this.actRImage.getFilename()), this.actRImage.getSurfaceArea());
                    this.gui.statusBar.setForeground(Color.black);
                    this.gui.statusBar.setText("Saved " + this.actRImage.getFilename());
                    this.deleteHistory();
                }
                catch (IOException ex) {
                    this.gui.statusBar.setForeground(Color.red);
                    this.gui.statusBar.setText("Can't write file");
                    System.out.println(ex.getLocalizedMessage());
                }
            }
        }
    }

    private void selectSNFiles() {
        this.gui.fileChooser.setCurrentDirectory(this.currFile);
        MyFileFilter filter = new MyFileFilter();
        filter.addExtension("pro");
        filter.setDescription("SNOWPACK Files");
        this.gui.fileChooser.setFileFilter(filter);
        this.gui.fileChooser.setMultiSelectionEnabled(true);
        if (0 == this.gui.fileChooser.showOpenDialog(this.gui)) {
            if (this.actRImage != null) {
                File[] fileArray = this.gui.fileChooser.getSelectedFiles();
                this.currFile = this.gui.fileChooser.getSelectedFile();
                SNOWPACKFile[] sFArray = new SNOWPACKFile[fileArray.length];
                int i = 0;
                while (i < fileArray.length) {
                    sFArray[i] = new SNOWPACKFile(fileArray[i], this.actRImage.getSurfaceArea());
                    ++i;
                }
                int j = 0;
                while (j < sFArray.length) {
                    block10: {
                        int k;
                        SNOWPACKFile sF = sFArray[j];
                        if (!this.SN_FileList.isEmpty()) {
                            k = 0;
                            while (k < this.SN_FileList.size()) {
                                if (((SNOWPACKFile)this.SN_FileList.get(k)).getLocation().equals(sF.getLocation())) {
                                    this.gui.statusBar.setForeground(Color.red);
                                    this.gui.statusBar.setText("Some files have the same location (x,y). These new files are not loaded.");
                                    break block10;
                                }
                                ++k;
                            }
                        }
                        k = 0;
                        while (k < j) {
                            if (sF.getLocation().equals(sFArray[k].getLocation())) {
                                this.gui.statusBar.setForeground(Color.red);
                                this.gui.statusBar.setText("Some files have the same location (x,y) with already loaded files. These new files are not loaded.");
                                break block10;
                            }
                            ++k;
                        }
                        this.SN_FileList.add(sF);
                        ArrayList snList = this.dArea.getSNOWPACKPointList();
                        snList.add(new Point(sF.getXCoord(), sF.getYcoord()));
                    }
                    ++j;
                }
            } else {
                this.gui.statusBar.setForeground(Color.red);
                this.gui.statusBar.setText("Activate an appropriate raster image before");
            }
            this.dArea.repaint();
        }
    }

    private void setActValue(MouseEvent e) {
        if (this.actRImage != null) {
            try {
                int fileSpecifier = this.actRImage.getFileSpecifier();
                FileSpecIF strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
                Point2D.Float pR = Utils.transformDrawingAreaPixelToRaster(e.getPoint(), this.dArea);
                int i = (int)pR.getY();
                int j = (int)pR.getX();
                if (this.actRImage.getSurfaceArea().sPoint[i][j].isNoDataValue()) {
                    this.gui.actValueLabel.setText("No Data");
                } else {
                    this.gui.actValueLabel.setText(strategy.valueToString(strategy.getValue(this.actRImage.getSurfaceArea(), i, j)));
                }
            }
            catch (ArrayIndexOutOfBoundsException z) {
                this.gui.actValueLabel.setText("");
            }
        }
    }

    public void setFCEditIndex(int value) {
        this.fCEditIndex = value;
    }

    private void setGridCoord(MouseEvent e) {
        String xValue = this.formatter0.format(Utils.transformDrawingAreaPixelToGrid(e.getPoint(), this.mImage1, this.actRImage, this.dArea).getX());
        String yValue = this.formatter0.format(Utils.transformDrawingAreaPixelToGrid(e.getPoint(), this.mImage1, this.actRImage, this.dArea).getY());
        this.gui.posXValueLabel.setText(xValue);
        this.gui.posYValueLabel.setText(yValue);
    }

    public void setLusEditIndex(int value) {
        this.lusEditIndex = value;
    }

    public void setSDEditIndex(int value) {
        this.sDEditIndex = value;
    }

    private void setScale() {
        double firstScale = 0.0;
        if (this.actRImage != null) {
            firstScale = (double)((float)(this.gui.scaleSectionPanel.getWidth() / 6) * this.actRImage.getSurfaceArea().getCellsize()) / this.dArea.getZoom() * this.dArea.getAdjustRasX();
        } else if (this.mImage1 != null) {
            firstScale = (double)((float)(this.gui.scaleSectionPanel.getWidth() / 6) * this.mImage1.getXCellsize()) / this.dArea.getZoom();
        }
        this.gui.scaleNr2.setText(this.formatter0.format(firstScale));
        this.gui.scaleNr3.setText(this.formatter0.format(firstScale * 2.0));
        this.gui.scaleNr4.setText(this.formatter0.format(firstScale * 3.0));
        this.gui.scaleNr5.setText(this.formatter0.format(firstScale * 4.0));
        this.gui.scaleNr6.setText(this.formatter0.format(firstScale * 5.0) + " m");
    }

    private void setSccdlrPoint(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        Point2D.Float swiss = Utils.transformDrawingAreaPixelToGrid(p, this.mImage1, this.actRImage, this.dArea);
        this.gui.sccd.xlrTextField.setText(this.formatter0.format(swiss.getX()));
        this.gui.sccd.ylrTextField.setText(this.formatter0.format(swiss.getY()));
    }

    private void setSccdulPoint(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        Point2D.Float swiss = Utils.transformDrawingAreaPixelToGrid(p, this.mImage1, this.actRImage, this.dArea);
        this.gui.sccd.xulTextField.setText(this.formatter0.format(swiss.getX()));
        this.gui.sccd.yulTextField.setText(this.formatter0.format(swiss.getY()));
    }

    private void setSpecialPointInfo(MouseEvent e) {
        if (this.gui.spcd.isShowing() && this.actRImage != null) {
            Point p = new Point(e.getX(), e.getY());
            this.gui.spcd.panel2.add(this.gui.spcd.positionPanel);
            this.gui.spcd.labelx.setText(String.valueOf((int)Utils.transformDrawingAreaPixelToRaster(p, this.dArea).getX()));
            this.gui.spcd.labely.setText(String.valueOf(this.actRImage.getSurfaceArea().getNRows() - 1 - (int)Utils.transformDrawingAreaPixelToRaster(p, this.dArea).getY()));
        }
    }

    private void setSpecialPointPosition(MouseEvent e) {
        if (this.gui.spcd.isShowing() && e.getClickCount() == 2) {
            Point p1 = new Point(e.getX(), e.getY());
            Point p2 = new Point((int)Utils.transformDrawingAreaPixelToRaster(p1, this.dArea).getX(), this.actRImage.getSurfaceArea().getNRows() - 1 - (int)Utils.transformDrawingAreaPixelToRaster(p1, this.dArea).getY());
            this.gui.spcd.setPointToNextRow(p2);
            this.gui.spcd.toFront();
        }
    }

    private void showEditMethodDialog() {
        int count = 0;
        int i = 0;
        while (i < this.rasImageStack.size()) {
            if (((RasterImage)this.rasImageStack.get(i)).getFileSpecifier() == 100) {
                ++count;
            }
            ++i;
        }
        if (count > 1) {
            JOptionPane.showMessageDialog(this.gui, "Please close all other surface code files before editing");
            return;
        }
        int fileSpecifier = this.actRImage.getFileSpecifier();
        FileSpecIF strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
        if (strategy.getEditIndex(this) >= 0) {
            this.gui.emd.panel1.add((Component)this.gui.emd.undoPointsButton, 4);
        } else {
            this.gui.emd.panel1.remove(this.gui.emd.undoPointsButton);
            this.gui.emd.panel1.revalidate();
        }
        if (!this.dArea.getEditPointList().isEmpty()) {
            EditMethodDialog cfr_ignored_0 = this.gui.emd;
            if (this.gui.emd.getEditMethod() == 0) {
                this.gui.emd.panel1.remove(this.gui.emd.existingPolButton);
                this.gui.emd.panel1.add((Component)this.gui.emd.existingLineButton, 1);
                this.gui.emd.panel1.revalidate();
                this.gui.emd.existingLineButton.setSelected(true);
            } else {
                EditMethodDialog cfr_ignored_1 = this.gui.emd;
                if (this.gui.emd.getEditMethod() == 1) {
                    this.gui.emd.panel1.remove(this.gui.emd.existingLineButton);
                    this.gui.emd.panel1.add((Component)this.gui.emd.existingPolButton, 1);
                    this.gui.emd.panel1.revalidate();
                    this.gui.emd.existingPolButton.setSelected(true);
                }
            }
        } else {
            this.gui.emd.panel1.remove(this.gui.emd.existingPolButton);
            this.gui.emd.panel1.remove(this.gui.emd.existingLineButton);
            this.gui.emd.panel1.revalidate();
            this.gui.emd.polygonButton.setSelected(true);
            EditMethodDialog cfr_ignored_2 = this.gui.emd;
            this.gui.emd.setEditMethod(1);
        }
        EditMethodDialog cfr_ignored_3 = this.gui.emd;
        if (this.gui.emd.getEditMethod() == 5) {
            this.gui.emd.undoPointsButton.setSelected(true);
        }
        if (this.gui.emd.okButton.getActionListeners().length == 1) {
            this.gui.emd.okButton.addActionListener(new EditMethodDialog_okButton_actionAdapter1(this));
        }
        if (this.gui.emd.cancelButton.getActionListeners().length == 0) {
            this.gui.emd.cancelButton.addActionListener(new EditMethodDialog_cancelButton_actionAdapter1(this));
        }
        this.gui.showEditMethodDialog();
    }

    private void showEditValueDialog() {
        if (!this.gui.evd.isEditWithNoData() && this.gui.evd.getNextButtonCount() > 0) {
            this.gui.evd.okButton.setEnabled(true);
        }
        EditMethodDialog cfr_ignored_0 = this.gui.emd;
        if (this.gui.emd.getEditMethod() == 1) {
            this.gui.evd.panel1.add((Component)this.gui.evd.editInsideCheckBox, 0);
            this.gui.evd.editInsideCheckBox.setSelected(true);
        } else {
            this.gui.evd.panel1.remove(this.gui.evd.editInsideCheckBox);
        }
        EditMethodDialog cfr_ignored_1 = this.gui.emd;
        if (this.gui.emd.getEditMethod() == 0 && this.gui.evd.getNextButtonCount() == 0) {
            this.gui.evd.cellsizeLabel.setText(new Float(this.actRImage.getSurfaceArea().getCellsize()).toString());
            this.gui.evd.linePointsLabel.setText("Define the width for editing along the line:");
            this.gui.evd.panel1.add((Component)this.gui.evd.forLinePanel, 0);
        } else {
            EditMethodDialog cfr_ignored_2 = this.gui.emd;
            if (this.gui.emd.getEditMethod() == 2 && this.gui.evd.getNextButtonCount() == 0) {
                this.gui.evd.cellsizeLabel.setText(new Float(this.actRImage.getSurfaceArea().getCellsize()).toString());
                this.gui.evd.linePointsLabel.setText("Define the size for editing on the points:");
                this.gui.evd.panel1.add((Component)this.gui.evd.forLinePanel, 0);
            } else {
                this.gui.evd.panel1.remove(this.gui.evd.forLinePanel);
            }
        }
        if (((RasterImage)this.rasImageStack.peek()).getFileSpecifier() == 100 && this.gui.evd.getNextButtonCount() == 0) {
            this.gui.evd.setWithNames(true);
            this.gui.evd.oldBox.setListData(this.gui.evd.getNoDataNames());
            this.gui.evd.newBox.setListData(this.gui.evd.getNames());
            this.gui.evd.buttonPanel.add((Component)this.gui.evd.nextButton, 1);
            this.gui.evd.panel1.add(this.gui.evd.nextLabel);
        } else if (this.gui.evd.getNextButtonCount() > 0 && this.gui.evd.isEditWithNoData()) {
            this.gui.evd.oldBox.setListData(this.gui.evd.getNoDataNumbers());
            this.gui.evd.newBox.setListData(this.gui.evd.getNumbers());
        } else {
            this.gui.evd.setWithNames(false);
            this.gui.evd.oldBox.setListData(this.gui.evd.getNumbers());
            this.gui.evd.newBox.setListData(this.gui.evd.getNumbers());
        }
        if (this.gui.evd.isEditWithNoData()) {
            this.gui.evd.oldBox.setSelectedIndex(this.gui.evd.oldBox.getModel().getSize() - 1);
        }
        if (this.gui.evd.okButton.getActionListeners().length == 0) {
            this.gui.evd.okButton.addActionListener(new EditValueDialog_okButton_actionAdapter1(this));
        }
        if (this.gui.evd.cancelButton.getActionListeners().length == 0) {
            this.gui.evd.cancelButton.addActionListener(new EditValueDialog_cancelButton_actionAdapter1(this));
        }
        this.gui.evd.validate();
        this.gui.showEditValueDialog();
    }

    private void showNextFile() {
        if (!this.rasImageStack.isEmpty()) {
            if (this.gui.dfd.isGoodFormat(this.actRImage.getFilename())) {
                int i = this.rasImageStack.size() - 1;
                while (i >= 0) {
                    RasterImage rImage = (RasterImage)this.rasImageStack.get(i);
                    if (this.gui.dfd.isGoodFormat(rImage.getFilename())) {
                        File nextFile = this.gui.dfd.getNextFile(rImage.getFilename());
                        try {
                            rImage.getSurfaceArea().deleteMinAndMax();
                            new ASCIIFileReader(nextFile, rImage.getSurfaceArea());
                            if (rImage.limitsAreSet()) {
                                if (!this.dArea.isMImageHidden()) {
                                    rImage.regImageKeepLimits(this.alpha);
                                } else {
                                    rImage.regImageKeepLimits(255);
                                }
                            } else if (!this.dArea.isMImageHidden()) {
                                rImage.regenerateImage(this.alpha);
                            } else {
                                rImage.regenerateImage(255);
                            }
                            rImage.setFilename(nextFile.getAbsolutePath());
                            rImage.getRadioButton().setToolTipText(nextFile.getAbsolutePath());
                            rImage.getRadioButton().setActionCommand(nextFile.getAbsolutePath());
                            this.updateDrawingArea();
                            this.gui.statusBar.setForeground(Color.black);
                            this.gui.statusBar.setText(this.actRImage.getFilename());
                        }
                        catch (IOException ex) {
                            System.out.println(ex.getMessage());
                            if (i != this.rasImageStack.size() - 1) {
                                this.gui.statusBar.setForeground(Color.red);
                                this.gui.statusBar.setText("Can't find " + nextFile);
                                this.gui.chBoxPanel1.remove(((RasterImage)this.rasImageStack.get(i)).getRadioButton());
                                this.gui.radioButtGroup.remove(((RasterImage)this.rasImageStack.get(i)).getRadioButton());
                                this.rasImageStack.remove(i);
                            }
                            this.gui.statusBar.setForeground(Color.red);
                            this.gui.statusBar.setText("Can't find " + nextFile);
                            return;
                        }
                    }
                    --i;
                }
            } else {
                this.gui.statusBar.setForeground(Color.red);
                this.gui.statusBar.setText(this.actRImage.getFilename() + " does not have the format /...yyyymmddhh(mm).*");
            }
        }
    }

    private void showOrHideGPSData() {
        if (!this.dArea.getGpsTrackList().isEmpty() || !this.dArea.getGpsWayPointList().isEmpty()) {
            this.dArea.getGpsTrackList().clear();
            this.dArea.getGpsWayPointList().clear();
            this.gui.gpsCheckBox.setSelected(false);
        } else {
            this.dArea.setGpsTrackList(this.gpsData.getTrackList());
            this.dArea.setGpsWayPointList(this.gpsData.getWayPointList());
            this.gui.gpsCheckBox.setSelected(true);
        }
        this.dArea.repaint();
    }

    private void showOrHideMap() {
        if (!this.dArea.isMImageHidden()) {
            this.dArea.setMImageHidden(true);
            this.gui.mapCheckBox.setSelected(false);
            if (!this.rasImageStack.isEmpty()) {
                int i = 0;
                while (i < this.rasImageStack.size()) {
                    ((RasterImage)this.rasImageStack.get(i)).changeAlpha(255);
                    ++i;
                }
            }
        } else {
            this.dArea.setMImageHidden(false);
            this.gui.mapCheckBox.setSelected(true);
            if (!this.rasImageStack.isEmpty()) {
                int i = 0;
                while (i < this.rasImageStack.size()) {
                    ((RasterImage)this.rasImageStack.get(i)).changeAlpha(this.alpha);
                    ++i;
                }
            }
        }
        this.updateDrawingArea();
    }

    private void showPointDialog(MouseEvent e) {
        PointDialog pointD = new PointDialog();
        this.pointDialogArr.add(pointD);
        int i = 0;
        while (i < this.pointDialogArr.size()) {
            ((PointDialog)this.pointDialogArr.get(i)).toFront();
            ++i;
        }
        int i2 = (int)((double)e.getY() / this.dArea.getZoom() * this.dArea.getAdjustRasX() - (double)this.dArea.getYulRCoord() * this.dArea.getAdjustRasX());
        int j = (int)((double)e.getX() / this.dArea.getZoom() * this.dArea.getAdjustRasX() - (double)this.dArea.getXulRCoord() * this.dArea.getAdjustRasX());
        if (this.actRImage == null) {
            pointD.xValueLabel.setText(this.formatter0.format((double)((float)e.getX() * this.mImage1.getXCellsize()) / this.dArea.getZoom() + (double)this.dArea.getXulGrid()));
            pointD.yValueLabel.setText(this.formatter0.format((double)((float)(e.getY() * -1) * this.mImage1.getYCellsize()) / this.dArea.getZoom() + (double)this.dArea.getYulGrid()));
        } else {
            try {
                if (!this.dArea.getSNOWPACKPointList().isEmpty()) {
                    int k = 0;
                    while (k < this.SN_FileList.size()) {
                        Ellipse2D.Double ell = this.dArea.getZoom() / this.dArea.getAdjustRasX() < 10.0 ? new Ellipse2D.Double((double)(((SNOWPACKFile)this.SN_FileList.get(k)).getXCoord() - 2) * this.dArea.getZoom() / this.dArea.getAdjustRasX() + (double)this.dArea.getXulRCoord() * this.dArea.getZoom(), (double)(((SNOWPACKFile)this.SN_FileList.get(k)).getYcoord() - 2) * this.dArea.getZoom() / this.dArea.getAdjustRasX() + (double)this.dArea.getYulRCoord() * this.dArea.getZoom(), this.dArea.getZoom() / this.dArea.getAdjustRasX() * 5.0, this.dArea.getZoom() / this.dArea.getAdjustRasX() * 5.0) : new Ellipse2D.Double((double)(((SNOWPACKFile)this.SN_FileList.get(k)).getXCoord() - 1) * this.dArea.getZoom() / this.dArea.getAdjustRasX() + (double)this.dArea.getXulRCoord() * this.dArea.getZoom(), (double)(((SNOWPACKFile)this.SN_FileList.get(k)).getYcoord() - 1) * this.dArea.getZoom() / this.dArea.getAdjustRasX() + (double)this.dArea.getYulRCoord() * this.dArea.getZoom(), this.dArea.getZoom() / this.dArea.getAdjustRasX() * 3.0, this.dArea.getZoom() / this.dArea.getAdjustRasX() * 3.0);
                        if (ell.contains(e.getX(), e.getY())) {
                            pointD.jPanel1.add(new JSeparator());
                            pointD.snFileNameLabel.setText(((SNOWPACKFile)this.SN_FileList.get(k)).getName());
                            pointD.jPanel1.add((Component)pointD.startPanel, null);
                            pointD.startButton.addActionListener(new PointDialog_startButton_actionAdapter(this));
                            pointD.startButton.setActionCommand(((SNOWPACKFile)this.SN_FileList.get(k)).getFilename());
                            pointD.closeButton.addActionListener(new PointDialog_closeButton_actionAdapter(this));
                            pointD.closeButton.setActionCommand(((SNOWPACKFile)this.SN_FileList.get(k)).getFilename());
                            break;
                        }
                        ++k;
                    }
                }
                pointD.xValueLabel.setText(this.formatter0.format((double)((float)e.getX() * this.actRImage.getSurfaceArea().getCellsize()) / this.dArea.getZoom() * this.dArea.getAdjustRasX() + (double)this.dArea.getXulGrid()));
                pointD.yValueLabel.setText(this.formatter0.format((double)((float)(e.getY() * -1) * this.actRImage.getSurfaceArea().getCellsize()) / this.dArea.getZoom() * this.dArea.getAdjustRasX() + (double)this.dArea.getYulGrid()));
                JPanel[] panelArr = new JPanel[this.rasImageStack.size()];
                int m = 0;
                while (m < this.rasImageStack.size()) {
                    if (((RasterImage)this.rasImageStack.get(m)).getSurfaceArea().getNCols() == this.actRImage.getSurfaceArea().getNCols()) {
                        int fileSpecifier = ((RasterImage)this.rasImageStack.get(m)).getFileSpecifier();
                        FileSpecIF strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
                        panelArr[m] = new JPanel();
                        panelArr[m].setToolTipText(((RasterImage)this.rasImageStack.get(m)).getFilename());
                        FlowLayout flowLayout1 = new FlowLayout();
                        flowLayout1.setAlignment(0);
                        panelArr[m].setLayout(flowLayout1);
                        JLabel captionLabel = new JLabel(strategy.getFiletype() + " " + strategy.getUnit() + ":");
                        JLabel valueLabel = new JLabel(strategy.valueToString(strategy.getValue(((RasterImage)this.rasImageStack.get(m)).getSurfaceArea(), i2, j)));
                        captionLabel.setFont(new Font("Dialog", 0, 11));
                        valueLabel.setFont(new Font("Dialog", 0, 11));
                        panelArr[m].add(captionLabel);
                        panelArr[m].add(valueLabel);
                        pointD.valuePanel.add(panelArr[m]);
                    }
                    ++m;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                System.out.println(ex.getMessage());
                pointD.xValueLabel.setText(this.formatter0.format((double)((float)e.getX() * this.mImage1.getXCellsize()) / this.dArea.getZoom() + (double)this.dArea.getXulGrid()));
                pointD.yValueLabel.setText(this.formatter0.format((double)((float)(e.getY() * -1) * this.mImage1.getYCellsize()) / this.dArea.getZoom() + (double)this.dArea.getYulGrid()));
                pointD.valuePanel.setVisible(false);
            }
        }
        Point dAreaUL = this.dArea.getLocationOnScreen();
        pointD.setLocation((int)((double)e.getX() + dAreaUL.getX()), (int)((double)e.getY() + dAreaUL.getY()));
        pointD.pack();
        pointD.show();
    }

    private void showPreviousFile() {
        if (!this.rasImageStack.isEmpty()) {
            if (this.gui.dfd.isGoodFormat(this.actRImage.getFilename())) {
                int i = this.rasImageStack.size() - 1;
                while (i >= 0) {
                    RasterImage rImage = (RasterImage)this.rasImageStack.get(i);
                    if (this.gui.dfd.isGoodFormat(rImage.getFilename())) {
                        File prevFile = this.gui.dfd.getPreviousFile(rImage.getFilename());
                        try {
                            rImage.getSurfaceArea().deleteMinAndMax();
                            new ASCIIFileReader(prevFile, rImage.getSurfaceArea());
                            if (rImage.limitsAreSet()) {
                                if (!this.dArea.isMImageHidden()) {
                                    rImage.regImageKeepLimits(this.alpha);
                                } else {
                                    rImage.regImageKeepLimits(255);
                                }
                            } else if (!this.dArea.isMImageHidden()) {
                                rImage.regenerateImage(this.alpha);
                            } else {
                                rImage.regenerateImage(255);
                            }
                            rImage.setFilename(prevFile.getAbsolutePath());
                            rImage.getRadioButton().setToolTipText(prevFile.getAbsolutePath());
                            rImage.getRadioButton().setActionCommand(prevFile.getAbsolutePath());
                            this.updateDrawingArea();
                            this.gui.statusBar.setForeground(Color.black);
                            this.gui.statusBar.setText(this.actRImage.getFilename());
                        }
                        catch (IOException ex) {
                            System.out.println(ex.getMessage());
                            if (i != this.rasImageStack.size() - 1) {
                                this.gui.statusBar.setForeground(Color.red);
                                this.gui.statusBar.setText("Can't find " + prevFile);
                            }
                            this.gui.statusBar.setForeground(Color.red);
                            this.gui.statusBar.setText("Can't find " + prevFile);
                            return;
                        }
                    }
                    --i;
                }
            } else {
                this.gui.statusBar.setForeground(Color.black);
                this.gui.statusBar.setText(this.actRImage.getFilename() + " does not have the format /...yyyymmddhh(mm).*");
            }
        }
    }

    private void showSurCodeCreateDialog() {
        this.gui.sccd.jPanel1.remove(this.gui.sccd.infoLabel);
        this.gui.sccd.jPanel1.revalidate();
        if (this.actRImage != null) {
            this.gui.sccd.radioButtSame.setEnabled(true);
            this.gui.sccd.cellsizeTextField.setText(new Float(this.actRImage.getSurfaceArea().getCellsize()).toString());
            this.gui.sccd.xulTextField.setText(new Float(this.actRImage.getXulCorner()).toString());
            this.gui.sccd.yulTextField.setText(new Float(this.actRImage.getYulCorner()).toString());
            this.gui.sccd.xlrTextField.setText(new Float(this.actRImage.getSurfaceArea().getXllCorner() + (float)this.actRImage.getSurfaceArea().getNCols() * this.actRImage.getSurfaceArea().getCellsize()).toString());
            this.gui.sccd.ylrTextField.setText(new Float(this.actRImage.getSurfaceArea().getYllCorner()).toString());
            this.gui.sccd.noDataTextField.setText(new Integer(this.actRImage.getSurfaceArea().getNoDataValue()).toString());
            this.gui.sccd.radioButtSame.doClick();
        } else {
            this.gui.sccd.cellsizeTextField.setText("100");
            this.gui.sccd.xulTextField.setText("730000");
            this.gui.sccd.xlrTextField.setText("750000");
            this.gui.sccd.yulTextField.setText("200000");
            this.gui.sccd.ylrTextField.setText("180000");
            this.gui.sccd.noDataTextField.setText("-9999");
            this.gui.sccd.radioButtSame.setEnabled(false);
            this.gui.sccd.radioButtNew.setSelected(true);
            this.gui.sccd.radioButtNew.doClick();
            if (this.mImage1 != null) {
                this.gui.sccd.setDrawPossible(false);
            }
        }
        this.gui.showSurCodeCreateDialog();
    }

    private void undo() {
        int fileSpecifier;
        FileSpecIF strategy;
        if (!(this.actRImage.getFileSpecifier() != 100 && this.actRImage.getFileSpecifier() != 102 && this.actRImage.getFileSpecifier() != 101 || (strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier = this.actRImage.getFileSpecifier()))).getEditIndex(this) < 0 || strategy.getPointList(this).isEmpty())) {
            ArrayList aL = (ArrayList)strategy.getPointList(this).get(strategy.getEditIndex(this));
            int i = 0;
            while (i < aL.size()) {
                Point p = (Point)aL.get(i);
                int undoIndex = (Integer)strategy.getUndoIndexMap(this).get(p) - 1;
                ArrayList undoValues = (ArrayList)strategy.getPointMap(this).get(p);
                int value = (Integer)undoValues.get(undoIndex);
                if (value == -9999) {
                    JOptionPane.showMessageDialog(this.gui, "No undo possible, because you edited \"no data\"");
                    return;
                }
                strategy.setValue(value, this.actRImage.getSurfaceArea(), (int)p.getY(), (int)p.getX());
                strategy.getUndoIndexMap(this).put(p, new Integer(undoIndex));
                ++i;
            }
            strategy.setEditIndex(this, strategy.getEditIndex(this) - 1);
            this.actRImage.regenerateImage(this.alpha);
            this.updateDrawingArea();
        }
    }

    private void undoOnMouseClick(MouseEvent e) {
        if (((RasterImage)this.rasImageStack.peek()).getFileSpecifier() == 100 || ((RasterImage)this.rasImageStack.peek()).getFileSpecifier() == 102 || ((RasterImage)this.rasImageStack.peek()).getFileSpecifier() == 101) {
            int fileSpecifier = ((RasterImage)this.rasImageStack.peek()).getFileSpecifier();
            FileSpecIF strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
            ArrayList<Point> pL = new ArrayList<Point>();
            this.deleteUndoValuesBiggerThanIndex();
            double y = (double)e.getY() / this.dArea.getZoom() * this.dArea.getAdjustRasX() - (double)this.dArea.getYulRCoord() * this.dArea.getAdjustRasX();
            double x = (double)e.getX() / this.dArea.getZoom() * this.dArea.getAdjustRasX() - (double)this.dArea.getXulRCoord() * this.dArea.getAdjustRasX();
            int i = (int)y;
            int j = (int)x;
            Point p = new Point(j, i);
            if (strategy.getPointMap(this).containsKey(p)) {
                int undoIndex;
                ArrayList valueList = (ArrayList)strategy.getPointMap(this).get(p);
                int value = (Integer)valueList.get((undoIndex = ((Integer)strategy.getUndoIndexMap(this).get(p)).intValue()) - 1);
                if (value == -9999) {
                    JOptionPane.showMessageDialog(this.gui, "No undo possible, because new value = \"no data \"");
                    return;
                }
                strategy.setValue(value, this.actRImage.getSurfaceArea(), i, j);
                valueList.add(new Integer(value));
                strategy.getPointMap(this).put(p, valueList);
                pL.add(p);
                strategy.getPointList(this).add(pL);
                strategy.getUndoIndexMap(this).put(p, new Integer(++undoIndex));
                strategy.setEditIndex(this, strategy.getEditIndex(this) + 1);
                ((RasterImage)this.rasImageStack.peek()).regenerateImage(this.alpha);
                this.updateDrawingArea();
            }
        }
    }

    private void updateDrawingArea() {
        this.dArea.georeferenceImages(this.mImage1, this.actRImage);
        if ((this.mImage1 == null || !this.mImage1.isGeoreferenced()) && this.rasImageStack.isEmpty()) {
            this.gui.scaleAllPanel.setVisible(false);
            this.gui.posPanel.setVisible(false);
        } else {
            this.gui.scaleAllPanel.setVisible(true);
            this.gui.posPanel.setVisible(true);
        }
        this.enableButtons();
        this.viewPos = this.gui.drawingAreaScrollPane.getViewport().getViewPosition();
        this.gui.drawingAreaScrollPane.getViewport().add((Component)this.dArea, null);
        this.gui.drawingAreaScrollPane.getViewport().setViewPosition(this.viewPos);
        this.setScale();
        if (this.actRImage != null) {
            int fileSpecifier = this.actRImage.getFileSpecifier();
            FileSpecIF strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
            this.createLegend();
            this.gui.actDeviceLabel.setText(strategy.getFiletype() + " " + strategy.getUnit() + ":");
            this.gui.actValueLabel.setText("");
            if (this.actRImage.getFileSpecifier() == 100) {
                this.gui.actValueLabel.setPreferredSize(new Dimension(95, 14));
            } else {
                this.gui.actValueLabel.setPreferredSize(new Dimension(55, 14));
            }
        }
        int i = 0;
        while (i < this.pointDialogArr.size()) {
            ((PointDialog)this.pointDialogArr.get(i)).dispose();
            ++i;
        }
        this.pointDialogArr.clear();
    }

    public void windowStateChanged(WindowEvent e) {
        int i = 0;
        while (i < this.pointDialogArr.size()) {
            ((PointDialog)this.pointDialogArr.get(i)).dispose();
            ++i;
        }
        this.pointDialogArr.clear();
    }

    private void zoomIn() {
        this.dArea.setZoomChanged(true);
        this.viewPos.setLocation(this.gui.drawingAreaScrollPane.getViewport().getViewPosition().getX() * 1.25 + this.gui.drawingAreaScrollPane.getViewport().getExtentSize().getWidth() / 2.0 * 0.25, this.gui.drawingAreaScrollPane.getViewport().getViewPosition().getY() * 1.25 + this.gui.drawingAreaScrollPane.getViewport().getExtentSize().getHeight() / 2.0 * 0.25);
        this.dArea.setZoom(this.dArea.getZoom() * 1.25);
        this.gui.drawingAreaScrollPane.getViewport().remove(this.dArea);
        this.dArea.georeferenceImages(this.mImage1, this.actRImage);
        this.dArea.repaint();
        this.gui.drawingAreaScrollPane.getViewport().add((Component)this.dArea, null);
        this.gui.drawingAreaScrollPane.getViewport().setViewPosition(this.viewPos);
        this.setScale();
        int i = 0;
        while (i < this.pointDialogArr.size()) {
            ((PointDialog)this.pointDialogArr.get(i)).dispose();
            ++i;
        }
        this.pointDialogArr.clear();
    }

    private void zoomOut() {
        this.dArea.setZoomChanged(true);
        this.viewPos.setLocation(this.gui.drawingAreaScrollPane.getViewport().getViewPosition().getX() * 0.8 - this.gui.drawingAreaScrollPane.getViewport().getExtentSize().getWidth() / 2.0 * 0.2, this.gui.drawingAreaScrollPane.getViewport().getViewPosition().getY() * 0.8 - this.gui.drawingAreaScrollPane.getViewport().getExtentSize().getHeight() / 2.0 * 0.2);
        this.dArea.setZoom(this.dArea.getZoom() * 4.0 / 5.0);
        this.dArea.georeferenceImages(this.mImage1, this.actRImage);
        this.dArea.repaint();
        this.gui.drawingAreaScrollPane.getViewport().setViewPosition(this.viewPos);
        this.setScale();
        int i = 0;
        while (i < this.pointDialogArr.size()) {
            ((PointDialog)this.pointDialogArr.get(i)).dispose();
            ++i;
        }
        this.pointDialogArr.clear();
    }
}

