/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.C_DataFile;
import ProWin.GrainForm;
import ProWin.Graph;
import ProWin.MetDataEntry;
import ProWin.ProDataEntry;
import ProWin.Setup;
import ProWin.SnowPackDoc;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.GregorianCalendar;
import javax.swing.JPanel;

public class XYPlotView
extends JPanel
implements C_DataFile {
    boolean firstActivation = true;
    int m_IdCode;
    Rectangle m_rightRect;
    Dimension rightRectSize = new Dimension();
    SnowPackDoc spDoc;

    public XYPlotView(SnowPackDoc spDoc, int IdCode) {
        this.spDoc = spDoc;
        this.m_IdCode = IdCode;
        this.setOpaque(true);
    }

    void DrawGrainHeightProfile(Graphics g) {
        boolean debug = false;
        Graph graph = new Graph(this.spDoc);
        if (this.spDoc == null) {
            return;
        }
        int yNrOfGrids = this.spDoc.m_yNrOfGrids;
        float YMinValue = this.spDoc.m_YMinValue;
        float YMaxValue = this.spDoc.m_YMaxValue;
        float XMinValue = 0.0f;
        float XMaxValue = 1.0f;
        Rectangle ClientRect = new Rectangle(this.m_rightRect.x, this.m_rightRect.y, this.m_rightRect.width, this.m_rightRect.height * 4 / 5);
        if (Setup.m_2Columns) {
            graph.SetClientAreaDP(g, ClientRect, 0, 1, 4, 1);
        } else {
            graph.SetClientAreaDP(g, ClientRect, 5, 1, 4, 1);
        }
        graph.SetXAxis(XMinValue, XMaxValue, 0);
        graph.SetYAxis(YMinValue, YMaxValue, yNrOfGrids);
        graph.CalcCoordinateSystem();
        g.setColor(this.spDoc.m_Background);
        g.fillRect(graph.m_XAxisStartPos.x, graph.m_YAxisEndPos.y, graph.m_XAxisEndPos.x - graph.m_XAxisStartPos.x, graph.m_YAxisStartPos.y - graph.m_YAxisEndPos.y);
        g.setColor(this.getForeground());
        this.spDoc.m_CurrentColor = this.getForeground();
        graph.DrawCoordinateAxes(g);
        graph.DrawGrids(g, false);
        if (!Setup.m_2Columns) {
            graph.DrawYAxisText(g, yNrOfGrids, 1, "ALIGN_LEFT", "ALIGN_TOP", this.spDoc.GetAxisText(501), this.spDoc.GetAxisUnit(501));
        }
        int IdCode = 513;
        float xStart = 0.0f;
        float xEnd = 0.1f;
        float LayerHeight = 0.0f;
        float zValue = 0.0f;
        float NextZValue = 0.0f;
        Point StartPoint = new Point();
        Point EndPoint = new Point();
        Color ActColor = new Color(0, 0, 0);
        Color NextColor = new Color(0, 0, 0);
        Point SymbolStartPoint = new Point();
        Point SymbolEndPoint = new Point();
        Dimension MinSpace = new Dimension(5, 6);
        Dimension SymbolSize = new Dimension(24, 12);
        int PrevEndPointX = 0;
        int PrevEndPointY = graph.CalcYPosLP(YMinValue) + SymbolSize.height + MinSpace.height;
        int HorizPos = 0;
        this.spDoc.GetMarkerValue(IdCode);
        ProDataEntry ActDataEntry = (ProDataEntry)this.spDoc.m_ActDataEntry;
        int TotalNrOfLayers = ActDataEntry.GetTotalNrOfLayers();
        int NrOfSnowLayers = ActDataEntry.GetNrOfSnowLayers();
        int NrOfSoilLayers = TotalNrOfLayers - NrOfSnowLayers;
        int NrOfLayers = ActDataEntry.GetNrOfLayers(IdCode);
        if (NrOfLayers > 0) {
            --NrOfLayers;
        }
        StartPoint.x = graph.CalcXPosLP(xStart);
        EndPoint.x = graph.CalcXPosLP(xEnd);
        StartPoint.y = graph.CalcYPosLP(YMinValue);
        if (NrOfLayers > 0) {
            NextZValue = ActDataEntry.GetZData(IdCode, 0);
            NextColor = GrainForm.GetColor((int)NextZValue);
        }
        if (debug) {
            System.out.println("StartPoint.x, EndPoint.x: " + StartPoint.x + " " + EndPoint.x);
        }
        int j = 0;
        while (j < NrOfLayers) {
            boolean hoarboxpaint = false;
            zValue = NextZValue;
            ActColor = NextColor;
            while (j < NrOfLayers) {
                if (j + 1 == NrOfLayers) break;
                NextZValue = ActDataEntry.GetZData(IdCode, j + 1);
                NextColor = GrainForm.GetColor((int)NextZValue);
                if (zValue % 10.0f == 2.0f || NextZValue % 10.0f == 2.0f || Math.abs(ActColor.getRed() - NextColor.getRed()) >= 8 || Math.abs(ActColor.getGreen() - NextColor.getGreen()) >= 8 || Math.abs(ActColor.getBlue() - NextColor.getBlue()) >= 8) break;
                if (debug) {
                    System.out.println("layer " + j + " skipped; " + "z = " + zValue + ", Next z = " + NextZValue);
                }
                ++j;
            }
            if (TotalNrOfLayers == NrOfSnowLayers) {
                LayerHeight = ActDataEntry.GetZData(501, j);
            } else if (NrOfLayers == NrOfSnowLayers) {
                LayerHeight = ActDataEntry.GetZData(501, j + 1 + NrOfSoilLayers);
            }
            if (LayerHeight > YMaxValue) {
                LayerHeight = YMaxValue;
                j = NrOfLayers;
            }
            if (LayerHeight < YMinValue) {
                LayerHeight = YMinValue;
            }
            EndPoint.y = graph.CalcYPosLP(LayerHeight);
            if (LayerHeight > YMinValue && IdCode != 514) {
                g.setColor(ActColor);
                if (IdCode == 513 && StartPoint.y - EndPoint.y < 1) {
                    g.fillRect(StartPoint.x, EndPoint.y, EndPoint.x - StartPoint.x, 1);
                } else {
                    g.fillRect(StartPoint.x, EndPoint.y, EndPoint.x - StartPoint.x, StartPoint.y - EndPoint.y);
                }
                if (zValue % 10.0f == 2.0f) {
                    g.setColor(Color.cyan);
                    int StartPointX = StartPoint.x + 1;
                    while (StartPointX < EndPoint.x) {
                        g.drawLine(StartPointX, StartPoint.y, StartPointX, EndPoint.y);
                        StartPointX += 5;
                    }
                }
                if (j == NrOfLayers - 1 && ActDataEntry.GetZData(IdCode, j + 1) > 0.0f) {
                    g.setColor(GrainForm.GetColor(660));
                    g.fillRect(StartPoint.x, EndPoint.y - 1, EndPoint.x - StartPoint.x, 2);
                }
                g.setColor(ActColor);
                if (j == NrOfLayers - 1 || Math.abs(zValue - NextZValue) > 2.0f || Math.abs(zValue - NextZValue) > 0.0f && (zValue % 10.0f == 2.0f || NextZValue % 10.0f == 2.0f)) {
                    if (EndPoint.y > PrevEndPointY - SymbolSize.height - MinSpace.height && PrevEndPointX + MinSpace.width + SymbolSize.width <= graph.CalcXPosLP(XMaxValue)) {
                        SymbolStartPoint.x = EndPoint.x + MinSpace.width + (++HorizPos - 1) * (SymbolSize.width + MinSpace.width);
                    } else {
                        HorizPos = 1;
                        SymbolStartPoint.x = EndPoint.x + MinSpace.width;
                        PrevEndPointY = EndPoint.y;
                    }
                    SymbolStartPoint.y = EndPoint.y;
                    SymbolEndPoint.x = SymbolStartPoint.x + SymbolSize.width;
                    SymbolEndPoint.y = SymbolStartPoint.y + SymbolSize.height;
                    g.drawLine(EndPoint.x, EndPoint.y, SymbolStartPoint.x, SymbolStartPoint.y);
                    GrainForm.DrawSymbol(g, (int)zValue, SymbolStartPoint, SymbolEndPoint);
                    g.setColor(ActColor);
                    g.drawRect(SymbolStartPoint.x, SymbolStartPoint.y, SymbolSize.width, SymbolSize.height);
                    PrevEndPointX = SymbolEndPoint.x;
                    if (j == NrOfLayers - 1 && ActDataEntry.GetZData(IdCode, j + 1) > 0.0f) {
                        SymbolStartPoint.x = EndPoint.x + MinSpace.width;
                        SymbolStartPoint.y = EndPoint.y - 3 - SymbolSize.height;
                        SymbolEndPoint.x = SymbolStartPoint.x + SymbolSize.width;
                        SymbolEndPoint.y = SymbolStartPoint.y + SymbolSize.height;
                        g.setColor(GrainForm.GRAIN_COLOR_6);
                        g.drawLine(EndPoint.x, EndPoint.y, SymbolStartPoint.x, SymbolEndPoint.y + 1);
                        GrainForm.DrawSymbol(g, 660, SymbolStartPoint, SymbolEndPoint);
                        g.setColor(GrainForm.GRAIN_COLOR_6);
                        g.drawRect(SymbolStartPoint.x, SymbolStartPoint.y, SymbolSize.width, SymbolSize.height);
                    }
                }
            }
            if (debug) {
                System.out.println("**** Layer j = " + j + ": height = " + LayerHeight);
                System.out.println("     StartPoint.y, EndPoint.y: " + StartPoint.y + " " + EndPoint.y + " z = " + zValue);
                System.out.println("RGB: " + ActColor.getRed() + " " + ActColor.getGreen() + " " + ActColor.getBlue());
            }
            StartPoint.y = EndPoint.y;
            ++j;
        }
        g.setColor(this.getForeground());
        graph.DrawAboveBelowText(g, 1.5f, "ALIGN_RIGHT", "BOLD", 10, "Grain Type", false);
        graph.DrawAboveBelowText(g, 3.0f, "ALIGN_LEFT", "PLAIN", 10, Graph.TimeToString(this.spDoc.m_ActTime).substring(0, 14), true);
        float SnowDepth = TotalNrOfLayers == NrOfSnowLayers ? ActDataEntry.GetZData(501, TotalNrOfLayers - 1) : ActDataEntry.GetZData(501, TotalNrOfLayers);
        graph.DrawAboveBelowText(g, 4.0f, "ALIGN_LEFT", "PLAIN", 10, "Snow Depth: " + SnowDepth + " cm", true);
    }

    void DrawHeightProfile(Graphics g) {
        Graph graph = new Graph(this.spDoc);
        if (this.spDoc == null) {
            return;
        }
        int[] IdCode = new int[3];
        ProDataEntry ActDataEntry = null;
        int NrOfParameters = 1;
        IdCode[0] = this.m_IdCode;
        Rectangle ClientRect = new Rectangle(this.m_rightRect.x, this.m_rightRect.y, this.m_rightRect.width, this.m_rightRect.height * 4 / 5);
        if (Setup.m_2Columns) {
            graph.SetClientAreaDP(g, ClientRect, 0, 1, 4, 1);
        } else {
            graph.SetClientAreaDP(g, ClientRect, 5, 1, 4, 1);
        }
        int yNrOfGrids = this.spDoc.m_yNrOfGrids;
        float YMinValue = this.spDoc.m_YMinValue;
        float YMaxValue = this.spDoc.m_YMaxValue;
        graph.SetYAxis(YMinValue, YMaxValue, yNrOfGrids);
        int i = 0;
        while (i < NrOfParameters) {
            float XMinValue = this.spDoc.m_StartValue;
            float XMaxValue = this.spDoc.m_EndValue;
            int xNrOfGrids = this.spDoc.m_xNrOfGrids;
            if (this.spDoc.GetMarkerValue(this.m_IdCode) && (ActDataEntry = (ProDataEntry)this.spDoc.m_ActDataEntry).SoilDataExist(IdCode[i]) && Setup.m_SoilDataDisplay) {
                XMinValue = this.spDoc.m_SoilStartValue;
                XMaxValue = this.spDoc.m_SoilEndValue;
            }
            graph.SetXAxis(XMinValue, XMaxValue, xNrOfGrids);
            if (i == 0) {
                graph.CalcCoordinateSystem();
                g.setColor(this.spDoc.m_Background);
                g.fillRect(graph.m_XAxisStartPos.x, graph.m_YAxisEndPos.y, graph.m_XAxisEndPos.x - graph.m_XAxisStartPos.x, graph.m_YAxisStartPos.y - graph.m_YAxisEndPos.y);
                g.setColor(this.getForeground());
                this.spDoc.m_CurrentColor = this.getForeground();
                graph.DrawCoordinateAxes(g);
                graph.DrawGrids(g, false);
                if (!Setup.m_2Columns) {
                    graph.DrawYAxisText(g, yNrOfGrids, 1, "ALIGN_LEFT", "ALIGN_TOP", this.spDoc.GetAxisText(501), this.spDoc.GetAxisUnit(501));
                }
            } else {
                graph.CalcCoordinateSystem();
            }
            g.setColor(this.spDoc.GetParameterColor(IdCode[i]));
            this.spDoc.m_CurrentColor = this.spDoc.GetParameterColor(IdCode[i]);
            if (IdCode[i] == 508 || IdCode[i] == 509) {
                graph.DrawXAxisText(g, 2 * i + 1, xNrOfGrids, 2);
            } else {
                graph.DrawXAxisText(g, 2 * i + 1, xNrOfGrids, 1);
            }
            graph.DrawAboveBelowText(g, (float)((double)(2 * i) + 1.7), "ALIGN_RIGHT", "BOLD", 10, this.spDoc.GetAxisText(IdCode[i]) + " (" + this.spDoc.GetAxisUnit(IdCode[i]) + ")", false);
            int PrevStartPointY = 0;
            Point StartPoint = new Point();
            Point EndPoint = new Point();
            int S_class = 0;
            float S_d = 0.0f;
            float S_n = 0.0f;
            float S_s = 0.0f;
            float S_d_height = 0.0f;
            float S_n_height = 0.0f;
            float S_s_height = 0.0f;
            if (this.spDoc.GetMarkerValue(this.m_IdCode)) {
                float xValue;
                GregorianCalendar xTime = this.spDoc.m_ActTime;
                ActDataEntry = (ProDataEntry)this.spDoc.m_ActDataEntry;
                int TotalNrOfLayers = ActDataEntry.GetTotalNrOfLayers();
                int NrOfSnowLayers = ActDataEntry.GetNrOfSnowLayers();
                int NrOfSoilLayers = TotalNrOfLayers - NrOfSnowLayers;
                int NrOfLayers = ActDataEntry.GetNrOfLayers(IdCode[i]);
                int StartLayer = Setup.m_SoilDataDisplay || TotalNrOfLayers != NrOfLayers ? 0 : NrOfSoilLayers;
                float yValue = ActDataEntry.SoilDataExist(IdCode[i]) && Setup.m_SoilDataDisplay ? ActDataEntry.GetZData(501, 0) : 0.0f;
                if (StartLayer < NrOfLayers) {
                    xValue = ActDataEntry.GetZData(IdCode[i], StartLayer);
                    StartPoint.x = graph.CalcXPosLP(xValue);
                    StartPoint.y = graph.CalcYPosLP(yValue);
                }
                int j = StartLayer;
                while (j < NrOfLayers) {
                    xValue = ActDataEntry.GetZData(IdCode[i], j);
                    yValue = TotalNrOfLayers == NrOfSnowLayers ? ActDataEntry.GetZData(501, j) : (NrOfLayers == NrOfSnowLayers ? ActDataEntry.GetZData(501, j + 1 + NrOfSoilLayers) : ActDataEntry.GetZData(501, j + 1));
                    EndPoint.x = graph.CalcXPosLP(xValue);
                    EndPoint.y = graph.CalcYPosLP(yValue);
                    if (yValue <= YMaxValue && StartPoint.y <= graph.CalcYPosLP(YMinValue) && EndPoint.y <= graph.CalcYPosLP(YMinValue) && EndPoint.y >= graph.CalcYPosLP(YMaxValue) && StartPoint.x >= graph.m_XAxisStartPos.x && StartPoint.x <= graph.m_XAxisEndPos.x && EndPoint.x >= graph.m_XAxisStartPos.x && EndPoint.x <= graph.m_XAxisEndPos.x) {
                        if (IdCode[i] == 502 || IdCode[i] == 506 || IdCode[i] == 512 || IdCode[i] == 531 || IdCode[i] == 532 || IdCode[i] == 533 || IdCode[i] == 534) {
                            g.drawLine(StartPoint.x, StartPoint.y, EndPoint.x, StartPoint.y);
                            g.drawLine(EndPoint.x, StartPoint.y, EndPoint.x, EndPoint.y);
                        } else if (j > StartLayer && PrevStartPointY <= graph.CalcYPosLP(YMinValue)) {
                            g.drawLine(StartPoint.x, (PrevStartPointY + StartPoint.y) / 2, EndPoint.x, (StartPoint.y + EndPoint.y) / 2);
                        }
                    }
                    PrevStartPointY = StartPoint.y;
                    StartPoint.x = EndPoint.x;
                    StartPoint.y = EndPoint.y;
                    ++j;
                }
                g.setColor(this.getForeground());
                this.spDoc.m_CurrentColor = this.getForeground();
                if (ActDataEntry.SoilDataExist(IdCode[i]) && Setup.m_SoilDataDisplay) {
                    graph.DrawGroundSurface(g);
                    if (!Setup.m_2Columns) {
                        graph.DrawYAxisText(g, yNrOfGrids, 1, "ALIGN_LEFT", "ALIGN_BOTTOM", "Soil", this.spDoc.GetAxisUnit(501));
                    }
                }
                graph.DrawAboveBelowText(g, 2 * NrOfParameters + 1, "ALIGN_LEFT", "PLAIN", 10, Graph.TimeToString(xTime).substring(0, 14), true);
                graph.DrawAboveBelowText(g, 2 * NrOfParameters + 2, "ALIGN_LEFT", "PLAIN", 10, "Snow Depth: " + yValue + " cm", true);
                if ((IdCode[i] == 531 || IdCode[i] == 532 || IdCode[i] == 533 || IdCode[i] == 534) && ActDataEntry.GetNrOfValues(530) == 7) {
                    if (ActDataEntry.CheckDataValid(530)) {
                        S_class = (int)ActDataEntry.GetZData(530, 0);
                        S_d_height = ActDataEntry.GetZData(530, 1);
                        S_d = ActDataEntry.GetZData(530, 2);
                        S_n_height = ActDataEntry.GetZData(530, 3);
                        S_n = ActDataEntry.GetZData(530, 4);
                        S_s_height = ActDataEntry.GetZData(530, 5);
                        S_s = ActDataEntry.GetZData(530, 6);
                    }
                    graph.DrawAboveBelowText(g, (float)((double)(2 * NrOfParameters) + 3.5), "ALIGN_LEFT", "PLAIN", 10, "S_class: " + S_class, true);
                    g.setColor(Color.magenta);
                    this.spDoc.m_CurrentColor = Color.magenta;
                    graph.InsertArrow(g, XMinValue, XMaxValue, S_d_height);
                    graph.DrawAboveBelowText(g, (float)((double)(2 * NrOfParameters) + 4.4), "ALIGN_LEFT", "PLAIN", 10, "S_d:       " + S_d + " at " + S_d_height + " cm", true);
                    g.setColor(Color.blue);
                    this.spDoc.m_CurrentColor = Color.blue;
                    graph.InsertArrow(g, XMinValue, XMaxValue, S_n_height);
                    graph.DrawAboveBelowText(g, (float)((double)(2 * NrOfParameters) + 5.2), "ALIGN_LEFT", "PLAIN", 10, "S_n:       " + S_n + " at " + S_n_height + " cm", true);
                    g.setColor(new Color(0, 127, 0));
                    this.spDoc.m_CurrentColor = new Color(0, 127, 0);
                    graph.InsertArrow(g, XMinValue, XMaxValue, S_s_height);
                    graph.DrawAboveBelowText(g, (float)((double)(2 * NrOfParameters) + 6.0), "ALIGN_LEFT", "PLAIN", 10, "S_s:       " + S_s + " at " + S_s_height + " cm", true);
                    g.setColor(this.getForeground());
                }
            }
            ++i;
        }
    }

    void DrawSingleValue(Graphics g) {
        Graph graph = new Graph(this.spDoc);
        if (this.spDoc == null) {
            return;
        }
        this.spDoc.AssociatedIdCodes(this.m_IdCode);
        int NrOfParameters = this.spDoc.NrOfParameters;
        int[] IdCode = new int[NrOfParameters];
        String[] Name2 = new String[NrOfParameters];
        int i = 0;
        while (i < NrOfParameters) {
            IdCode[i] = this.spDoc.IdCode[i];
            Name2[i] = this.spDoc.Name2[i];
            ++i;
        }
        if (this.spDoc.GetMarkerValue(this.m_IdCode)) {
            Rectangle ClientRect = new Rectangle(this.m_rightRect.x, this.m_rightRect.y + this.m_rightRect.height * 2 / 5, this.m_rightRect.width, this.m_rightRect.height * 2 / 5);
            graph.SetClientAreaDP(g, ClientRect, 0, 0, 3, 1);
            GregorianCalendar xTime = this.spDoc.m_ActTime;
            MetDataEntry ActDataEntry = (MetDataEntry)this.spDoc.m_ActDataEntry;
            graph.SetYAxis(0.0f, 1.0f, 1);
            graph.CalcCoordinateSystem();
            if (NrOfParameters == 1) {
                g.setColor(this.spDoc.GetParameterColor(this.m_IdCode));
                this.spDoc.m_CurrentColor = this.spDoc.GetParameterColor(this.m_IdCode);
                graph.DrawAboveBelowText(g, -3.0f, "ALIGN_CENTER", "BOLD", 12, this.spDoc.GetAxisText(this.m_IdCode) + ":", false);
                float xValue = ActDataEntry.GetMetData(this.m_IdCode);
                if (this.spDoc.GetAxisUnit(this.m_IdCode).equals("1")) {
                    graph.DrawAboveBelowText(g, -1.5f, "ALIGN_CENTER", "BOLD", 12, xValue + "", true);
                } else if (new Float(xValue).equals(new Float(-999.9))) {
                    graph.DrawAboveBelowText(g, -1.5f, "ALIGN_CENTER", "BOLD", 12, "not available", true);
                } else {
                    graph.DrawAboveBelowText(g, -1.5f, "ALIGN_CENTER", "BOLD", 12, xValue + " " + this.spDoc.GetAxisUnit(this.m_IdCode), true);
                }
            } else {
                graph.DrawAboveBelowText(g, -4.5f, "ALIGN_CENTER", "BOLD", 12, this.spDoc.GetAxisText(this.m_IdCode) + ":", false);
                int i2 = 0;
                while (i2 < NrOfParameters) {
                    g.setColor(this.spDoc.GetParameterColor(IdCode[i2]));
                    this.spDoc.m_CurrentColor = this.spDoc.GetParameterColor(IdCode[i2]);
                    float xValue = ActDataEntry.GetMetData(IdCode[i2]);
                    if (this.spDoc.GetAxisUnit(IdCode[i2]).equals("1")) {
                        graph.DrawAboveBelowText(g, -3 + i2, "ALIGN_CENTER", "PLAIN", 11, Name2[i2] + ": " + xValue, true);
                    } else if (new Float(xValue).equals(new Float(-999.9))) {
                        graph.DrawAboveBelowText(g, -3 + i2, "ALIGN_CENTER", "PLAIN", 11, Name2[i2] + ": not available", true);
                    } else {
                        graph.DrawAboveBelowText(g, -3 + i2, "ALIGN_CENTER", "PLAIN", 11, Name2[i2] + ": " + xValue + " " + this.spDoc.GetAxisUnit(this.m_IdCode), true);
                    }
                    ++i2;
                }
            }
            g.setColor(this.getForeground());
            this.spDoc.m_CurrentColor = this.getForeground();
            graph.DrawCenteredDate(g, xTime, "FULL_DATE");
        }
    }

    void DrawXYPlot(Graphics g) {
        this.setBackground(this.spDoc.m_Background);
        this.setForeground(this.spDoc.m_Foreground);
        this.rightRectSize.width = this.getSize().width;
        this.rightRectSize.height = this.getSize().height;
        this.m_rightRect = new Rectangle(0, 0, this.rightRectSize.width, this.rightRectSize.height);
        if (this.m_IdCode == 513) {
            this.DrawGrainHeightProfile(g);
        } else if (this.m_IdCode >= 500) {
            this.DrawHeightProfile(g);
        } else {
            this.DrawSingleValue(g);
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.spDoc.datafile_m_ActStartTime != null) {
            this.spDoc.RetrieveDataFile();
        }
        this.DrawXYPlot(g);
    }
}

