/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.C_DataFile;
import ProWin.ColorTab;
import ProWin.GrainForm;
import ProWin.Graph;
import ProWin.MetDataEntry;
import ProWin.ProDataEntry;
import ProWin.Setup;
import ProWin.SnowPackDoc;
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.GregorianCalendar;
import javax.swing.JPanel;

public class SnowPackView
extends JPanel
implements C_DataFile {
    Dimension leftRectSize;
    ColorTab m_ColorTab = null;
    float m_ColorTabEndValue = 0.0f;
    int m_ColorTabIndex = 0;
    float m_ColorTabStartValue = 0.0f;
    int m_IdCode;
    Rectangle m_leftRect;
    SnowPackDoc spDoc;
    XYLayout xYLayout1 = new XYLayout();

    public SnowPackView(SnowPackDoc spDoc, int IdCode) {
        this.leftRectSize = new Dimension();
        this.spDoc = spDoc;
        this.m_IdCode = IdCode;
        this.setBackground(spDoc.m_Background);
        this.setForeground(spDoc.m_Foreground);
        this.setLayout(this.xYLayout1);
        this.setOpaque(true);
    }

    boolean DrawColorBar(Graphics g) {
        Graph ColorBarGraph = new Graph(this.spDoc);
        Rectangle ClientRect = new Rectangle(this.m_leftRect.x, this.m_leftRect.y + this.m_leftRect.height * 13 / 15, this.m_leftRect.width, this.m_leftRect.height * 2 / 15);
        ColorBarGraph.SetClientAreaDP(g, ClientRect, 7, 1, 3, 0);
        if (this.m_ColorTab == null) {
            return false;
        }
        int xNrOfGrids = ColorTab.NrOfColors[this.m_ColorTabIndex] - 1;
        while (xNrOfGrids < 5) {
            xNrOfGrids *= 2;
        }
        ColorBarGraph.SetXAxis(this.m_ColorTabStartValue, this.m_ColorTabEndValue, xNrOfGrids);
        ColorBarGraph.SetYAxis(0.0f, 10.0f, 1);
        ColorBarGraph.CalcCoordinateSystem();
        ColorBarGraph.DrawCoordinateAxes(g);
        ColorBarGraph.DrawGrids(g, false);
        g.setColor(this.getForeground());
        ColorBarGraph.DrawXAxisText(g, 1.0f, xNrOfGrids, 1);
        ColorBarGraph.DrawAboveBelowText(g, 2.0f, "ALIGN_CENTER", "PLAIN", 10, this.spDoc.GetAxisText(this.m_IdCode) + " (" + this.spDoc.GetAxisUnit(this.m_IdCode) + ")", false);
        Color ActColor = new Color(0, 0, 0);
        Point StartPoint = new Point();
        Point EndPoint = new Point();
        int NrOfColRects = 100;
        float Offset = (this.m_ColorTabEndValue - this.m_ColorTabStartValue) / (float)NrOfColRects;
        StartPoint.y = ColorBarGraph.CalcYPosLP(0.0f);
        EndPoint.y = ColorBarGraph.CalcYPosLP(10.0f);
        StartPoint.x = ColorBarGraph.CalcXPosLP(this.m_ColorTabStartValue);
        int i = 0;
        while (i < NrOfColRects) {
            float ActValue = this.m_ColorTabStartValue + (float)i * Offset;
            EndPoint.x = ColorBarGraph.CalcXPosLP(ActValue + Offset);
            ActColor = this.m_ColorTab.GetColor(ActValue + Offset / 2.0f, this.m_ColorTabIndex);
            g.setColor(ActColor);
            if (StartPoint.y > EndPoint.y) {
                g.fillRect(StartPoint.x, EndPoint.y, EndPoint.x - StartPoint.x, StartPoint.y - EndPoint.y);
            } else {
                g.fillRect(StartPoint.x, StartPoint.y, EndPoint.x - StartPoint.x, EndPoint.y - StartPoint.y);
            }
            StartPoint.x = EndPoint.x;
            ++i;
        }
        g.setColor(this.getForeground());
        return true;
    }

    boolean DrawGrainFormBar(Graphics g) {
        int NR_OF_ROWS = 3;
        int NR_OF_COLUMNS = 7;
        int NR_OF_GRAIN_FORMS = NR_OF_ROWS * NR_OF_COLUMNS;
        int[] GrainFormCodes = new int[]{0, 0, 230, 330, 370, 770, 880, 110, 120, 220, 340, 470, 570, 2, 0, 0, 240, 440, 450, 550, 660};
        Graph ColorBarGraph = new Graph(this.spDoc);
        Rectangle ClientRect = new Rectangle(this.m_leftRect.x, this.m_leftRect.y + this.m_leftRect.height * 13 / 15, this.m_leftRect.width, this.m_leftRect.height * 2 / 15);
        ColorBarGraph.SetClientAreaDP(g, ClientRect, 7, 1, 1, 0);
        ColorBarGraph.SetXAxis(0.0f, (float)NR_OF_COLUMNS, NR_OF_COLUMNS);
        ColorBarGraph.SetYAxis(0.0f, NR_OF_ROWS, NR_OF_ROWS);
        ColorBarGraph.CalcCoordinateSystem();
        g.setColor(this.getForeground());
        Font font = new Font("Dialog", 0, 10);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        g.drawString("Grain Type", ColorBarGraph.m_XAxisStartPos.x, ColorBarGraph.m_YAxisStartPos.y + 2);
        Color ActColor = new Color(0, 0, 0);
        Point StartPoint = new Point();
        Point EndPoint = new Point();
        Point SymbolStartPoint = new Point();
        Point SymbolEndPoint = new Point();
        int Index = 0;
        float y = NR_OF_ROWS;
        while (y > 0.0f) {
            StartPoint.y = ColorBarGraph.CalcYPosLP(y - 1.0f);
            EndPoint.y = ColorBarGraph.CalcYPosLP(y);
            float x = 0.0f;
            while (x < (float)NR_OF_COLUMNS) {
                StartPoint.x = ColorBarGraph.CalcXPosLP(x);
                EndPoint.x = ColorBarGraph.CalcXPosLP(x + 1.0f);
                int ActValue = GrainFormCodes[Index];
                if (ActValue > 0) {
                    ActColor = GrainForm.GetColor(ActValue);
                    g.setColor(ActColor);
                    g.fillRect(StartPoint.x, EndPoint.y, EndPoint.x - StartPoint.x, StartPoint.y - EndPoint.y);
                    if (ActValue == 2) {
                        g.setColor(Color.cyan);
                        int StartPointX = StartPoint.x + 1;
                        while (StartPointX < EndPoint.x) {
                            g.drawLine(StartPointX, StartPoint.y, StartPointX, EndPoint.y);
                            StartPointX += 5;
                        }
                    }
                    g.setColor(ActColor);
                    int SymbolMaxSize = 12;
                    SymbolStartPoint.y = EndPoint.y;
                    SymbolEndPoint.y = SymbolStartPoint.y + Math.min(SymbolMaxSize, StartPoint.y - EndPoint.y);
                    SymbolStartPoint.x = StartPoint.x;
                    SymbolEndPoint.x = StartPoint.x + 2 * (SymbolEndPoint.y - SymbolStartPoint.y);
                    GrainForm.DrawSymbol(g, ActValue, SymbolStartPoint, SymbolEndPoint);
                    g.setColor(this.getForeground());
                }
                ++Index;
                x += 1.0f;
            }
            y -= 1.0f;
        }
        g.setColor(this.getForeground());
        return true;
    }

    boolean DrawMarker(Graphics g, int IdCode) {
        Graph graph = new Graph(this.spDoc);
        if (this.spDoc == null) {
            return false;
        }
        if (!this.PrepareGraph(graph)) {
            return false;
        }
        if (this.spDoc.GetMarkerValue(IdCode)) {
            GregorianCalendar xTime = this.spDoc.m_ActTime;
            Point StartPointMarker = new Point();
            Point EndPointMarker = new Point();
            StartPointMarker.x = graph.CalcXPosLP(xTime);
            StartPointMarker.y = graph.CalcYPosLP(this.spDoc.m_YMinValue);
            EndPointMarker.x = StartPointMarker.x;
            EndPointMarker.y = graph.CalcYPosLP(this.spDoc.m_YMaxValue);
            g.setXORMode(this.getBackground());
            g.drawLine(StartPointMarker.x, StartPointMarker.y, EndPointMarker.x, EndPointMarker.y);
            g.drawLine(EndPointMarker.x - 3, EndPointMarker.y - 6, EndPointMarker.x, EndPointMarker.y);
            g.drawLine(EndPointMarker.x + 3, EndPointMarker.y - 6, EndPointMarker.x, EndPointMarker.y);
            g.drawLine(EndPointMarker.x - 3, EndPointMarker.y - 6, EndPointMarker.x + 3, EndPointMarker.y - 6);
            g.setPaintMode();
            this.spDoc.activeSliderMovement = false;
            this.spDoc.jSlider.setMinimum(graph.m_XAxisStartPos.x);
            this.spDoc.jSlider.setMaximum(graph.m_XAxisEndPos.x);
            this.spDoc.jSlider.setValue(StartPointMarker.x);
            this.spDoc.activeSliderMovement = true;
        }
        return true;
    }

    void DrawSnowPackView(Graphics g) {
        this.setBackground(this.spDoc.m_Background);
        this.setForeground(this.spDoc.m_Foreground);
        this.leftRectSize.width = this.getSize().width;
        this.leftRectSize.height = this.getSize().height;
        this.m_leftRect = new Rectangle(0, 0, this.leftRectSize.width, this.leftRectSize.height);
        if (this.m_IdCode >= 500) {
            if (this.DrawSnowpackGraph(g, this.m_IdCode)) {
                if (this.m_IdCode == 513 || this.m_IdCode == 514) {
                    this.DrawGrainFormBar(g);
                } else {
                    this.DrawColorBar(g);
                }
            }
        } else {
            this.DrawTimeProfile(g);
        }
    }

    boolean DrawSnowpackGraph(Graphics g, int IdCode) {
        boolean debug = false;
        Graph graph = new Graph(this.spDoc);
        if (this.spDoc == null) {
            return false;
        }
        g.setColor(this.getForeground());
        this.spDoc.m_CurrentColor = this.getForeground();
        String StationName = this.spDoc.m_StationName;
        String StationAltStr = this.spDoc.m_StationAltStr;
        String StationAspectStr = this.spDoc.m_StationAspectStr;
        String StationSlopeStr = this.spDoc.m_StationSlopeStr;
        String StationLatStr = this.spDoc.m_StationLatStr;
        String StationLonStr = this.spDoc.m_StationLonStr;
        this.m_ColorTabIndex = this.spDoc.m_ColorTab;
        this.m_ColorTabStartValue = this.spDoc.m_ColorStartValue;
        this.m_ColorTabEndValue = this.spDoc.m_ColorEndValue;
        GregorianCalendar StartTime = this.spDoc.m_StartTime;
        int TimeRange = this.spDoc.m_TimeRange1;
        int TimeStep = this.spDoc.m_TimeStep;
        int xNrOfGrids = this.spDoc.m_TimeGrid;
        int yNrOfGrids = this.spDoc.m_yNrOfGrids;
        float YMinValue = this.spDoc.m_YMinValue;
        float YMaxValue = this.spDoc.m_YMaxValue;
        if (TimeStep == 0 || TimeRange == 0) {
            return false;
        }
        int NrOfXValues = TimeRange / TimeStep;
        if (NrOfXValues <= 0) {
            NrOfXValues = 1;
        }
        Rectangle ClientRect = new Rectangle(this.m_leftRect.x, this.m_leftRect.y, this.m_leftRect.width, this.m_leftRect.height * 4 / 5);
        graph.SetClientAreaDP(g, ClientRect, 7, 3, 4, 1);
        graph.SetXAxis(StartTime, TimeRange, xNrOfGrids);
        graph.SetYAxis(YMinValue, YMaxValue, yNrOfGrids);
        graph.CalcCoordinateSystem();
        graph.DrawCoordinateAxes(g);
        graph.DrawGrids(g, true);
        graph.DrawXAxisDateText(g, xNrOfGrids, "FULL_DATE");
        graph.DrawYAxisText(g, yNrOfGrids, 1, "ALIGN_LEFT", "ALIGN_TOP", this.spDoc.GetAxisText(501), this.spDoc.GetAxisUnit(501));
        graph.DrawAboveBelowText(g, 4.0f, "ALIGN_CENTER", "BOLD", 11, StationName + ", " + StationAltStr + " m", false);
        if (Setup.m_ResearchMode && !StationName.equals("Undefined Station")) {
            if (!StationSlopeStr.equals("")) {
                graph.DrawAboveBelowText(g, 4.0f, "ALIGN_LEFT", "PLAIN", 10, "Slope = " + StationSlopeStr + " deg", false);
            }
            if (!StationAspectStr.equals("")) {
                graph.DrawAboveBelowText(g, 4.8f, "ALIGN_LEFT", "PLAIN", 10, "Aspect = " + StationAspectStr + " deg", false);
            }
            if (!StationLatStr.equals("")) {
                graph.DrawAboveBelowText(g, 4.0f, "ALIGN_RIGHT", "PLAIN", 10, "Latitude = " + StationLatStr, false);
            }
            if (!StationLonStr.equals("")) {
                graph.DrawAboveBelowText(g, 4.8f, "ALIGN_RIGHT", "PLAIN", 10, "Longitude = " + StationLonStr, false);
            }
        }
        float zValue = 0.0f;
        float NextZValue = 0.0f;
        Point StartPoint = new Point();
        Point EndPoint = new Point();
        Color ActColor = new Color(0, 0, 0);
        Color NextColor = new Color(0, 0, 0);
        int NrOfLayers = 0;
        int TotalNrOfLayers = 0;
        int NrOfSnowLayers = 0;
        int NrOfSoilLayers = 0;
        int StartLayer = 0;
        this.m_ColorTab = new ColorTab();
        this.m_ColorTab.LoadPredefinedColorTable(this.m_ColorTabIndex, this.m_ColorTabStartValue, this.m_ColorTabEndValue);
        boolean hasMoreValues = this.spDoc.GetFirstValue(IdCode);
        GregorianCalendar xTime = this.spDoc.m_ActTime;
        GregorianCalendar NextTime = this.spDoc.m_ActTime;
        ProDataEntry ActDataEntry = (ProDataEntry)this.spDoc.m_ActDataEntry;
        boolean lastColumnSkipped = false;
        int i = 0;
        while (i < NrOfXValues) {
            if (debug) {
                System.out.println("================= Start Column " + i + " ======================");
            }
            boolean firstBox = true;
            if (!lastColumnSkipped) {
                xTime = (GregorianCalendar)NextTime.clone();
            }
            boolean hasMoreValuesNext = this.spDoc.GetNextValue(IdCode);
            NextTime = this.spDoc.m_ActTime;
            ProDataEntry NextDataEntry = (ProDataEntry)this.spDoc.m_ActDataEntry;
            if (!hasMoreValuesNext) {
                GregorianCalendar xTimeClone = (GregorianCalendar)xTime.clone();
                xTimeClone.add(13, TimeStep);
                GregorianCalendar EndTimeClone = (GregorianCalendar)StartTime.clone();
                EndTimeClone.add(13, TimeRange);
                NextTime = xTimeClone.before(EndTimeClone) ? xTimeClone : EndTimeClone;
                NextDataEntry = null;
            }
            if (hasMoreValues) {
                StartPoint.x = graph.CalcXPosLP(xTime);
                EndPoint.x = graph.CalcXPosLP(NextTime);
                if (EndPoint.x - StartPoint.x >= 1) {
                    TotalNrOfLayers = ActDataEntry.GetTotalNrOfLayers();
                    NrOfSnowLayers = ActDataEntry.GetNrOfSnowLayers();
                    NrOfSoilLayers = TotalNrOfLayers - NrOfSnowLayers;
                    NrOfLayers = ActDataEntry.GetNrOfLayers(IdCode);
                    if (IdCode == 513 && NrOfLayers > 0) {
                        --NrOfLayers;
                    }
                    StartLayer = Setup.m_SoilDataDisplay || TotalNrOfLayers != NrOfLayers ? 0 : NrOfSoilLayers;
                    float StartLayerHeight = ActDataEntry.SoilDataExist(IdCode) && Setup.m_SoilDataDisplay ? ActDataEntry.GetZData(501, 0) : 0.0f;
                    StartPoint.y = graph.CalcYPosLP(StartLayerHeight);
                    if (NrOfLayers > 0 && (Setup.m_SoilDataDisplay || NrOfSnowLayers > 0)) {
                        NextZValue = ActDataEntry.GetZData(IdCode, StartLayer);
                        NextColor = IdCode == 513 ? GrainForm.GetColor((int)NextZValue) : this.m_ColorTab.GetColor(NextZValue, this.m_ColorTabIndex);
                    }
                    if (debug) {
                        System.out.println("StartPoint.x, EndPoint.x: " + StartPoint.x + " " + EndPoint.x);
                    }
                    int j = StartLayer;
                    while (j < NrOfLayers) {
                        zValue = NextZValue;
                        ActColor = NextColor;
                        while (j + 1 < NrOfLayers) {
                            NextZValue = ActDataEntry.GetZData(IdCode, j + 1);
                            if (IdCode == 513) {
                                NextColor = GrainForm.GetColor((int)NextZValue);
                                if (zValue % 10.0f == 2.0f || NextZValue % 10.0f == 2.0f) {
                                    break;
                                }
                            } else {
                                NextColor = this.m_ColorTab.GetColor(NextZValue, this.m_ColorTabIndex);
                            }
                            if (Math.abs(ActColor.getRed() - NextColor.getRed()) >= 8 || Math.abs(ActColor.getGreen() - NextColor.getGreen()) >= 8 || Math.abs(ActColor.getBlue() - NextColor.getBlue()) >= 8) break;
                            if (debug) {
                                System.out.println("i=" + i + ": layer " + j + " skipped; " + "z = " + zValue + ", Next z = " + NextZValue);
                            }
                            ++j;
                        }
                        float LayerHeight = TotalNrOfLayers == NrOfSnowLayers ? ActDataEntry.GetZData(501, j) : (NrOfLayers == NrOfSnowLayers ? ActDataEntry.GetZData(501, j + 1 + NrOfSoilLayers) : ActDataEntry.GetZData(501, j + 1));
                        if (LayerHeight > YMaxValue) {
                            LayerHeight = YMaxValue;
                            j = NrOfLayers;
                        }
                        if (firstBox && LayerHeight > YMinValue && StartLayerHeight < YMinValue) {
                            StartPoint.y = graph.CalcYPosLP(YMinValue);
                        }
                        firstBox = false;
                        if (LayerHeight < YMinValue) {
                            LayerHeight = YMinValue;
                        }
                        EndPoint.y = graph.CalcYPosLP(LayerHeight);
                        if (LayerHeight > YMinValue && IdCode != 514) {
                            g.setColor(ActColor);
                            if (IdCode == 513 && StartPoint.y - EndPoint.y < 1) {
                                g.fillRect(StartPoint.x, EndPoint.y, EndPoint.x - StartPoint.x, 1);
                            } else {
                                g.fillRect(StartPoint.x, EndPoint.y, EndPoint.x - StartPoint.x, StartPoint.y - EndPoint.y);
                            }
                            if (IdCode == 513 && zValue % 10.0f == 2.0f) {
                                g.setColor(Color.cyan);
                                int StartPointX = StartPoint.x + 1;
                                while (StartPointX < EndPoint.x) {
                                    g.drawLine(StartPointX, StartPoint.y, StartPointX, EndPoint.y);
                                    StartPointX += 5;
                                }
                            }
                            if (IdCode == 513 && j == NrOfLayers - 1 && ActDataEntry.GetZData(IdCode, j + 1) > 0.0f) {
                                g.setColor(GrainForm.GetColor(660));
                                g.fillRect(StartPoint.x, EndPoint.y - 1, EndPoint.x - StartPoint.x, 2);
                            }
                            g.setColor(ActColor);
                        }
                        if (debug) {
                            System.out.println("**** Layer j = " + j + ": height = " + LayerHeight);
                            System.out.println("     StartPoint.y, EndPoint.y: " + StartPoint.y + " " + EndPoint.y + " z = " + zValue);
                            System.out.println("RGB: " + ActColor.getRed() + " " + ActColor.getGreen() + " " + ActColor.getBlue());
                        }
                        StartPoint.y = EndPoint.y;
                        ++j;
                    }
                    lastColumnSkipped = false;
                } else {
                    lastColumnSkipped = true;
                }
            }
            if (!lastColumnSkipped) {
                ActDataEntry = NextDataEntry;
                hasMoreValues = hasMoreValuesNext;
            }
            ++i;
        }
        g.setColor(this.getForeground());
        if (TotalNrOfLayers != NrOfSnowLayers && NrOfLayers == TotalNrOfLayers && Setup.m_SoilDataDisplay) {
            graph.DrawGroundSurface(g);
            graph.DrawYAxisText(g, yNrOfGrids, 1, "ALIGN_LEFT", "ALIGN_BOTTOM", "Soil", this.spDoc.GetAxisUnit(501));
        }
        this.DrawMarker(g, IdCode);
        return true;
    }

    void DrawTimeProfile(Graphics g) {
        Graph graph = new Graph(this.spDoc);
        if (this.spDoc == null) {
            return;
        }
        g.setColor(this.getForeground());
        this.spDoc.m_CurrentColor = this.getForeground();
        this.spDoc.AssociatedIdCodes(this.m_IdCode);
        int NrOfParameters = this.spDoc.NrOfParameters;
        int[] IdCode = new int[NrOfParameters];
        String[] Name2 = new String[NrOfParameters];
        int i = 0;
        while (i < NrOfParameters) {
            IdCode[i] = this.spDoc.IdCode[i];
            Name2[i] = this.spDoc.Name2[i];
            ++i;
        }
        Rectangle ClientRect = new Rectangle(this.m_leftRect.x, this.m_leftRect.y, this.m_leftRect.width, this.m_leftRect.height * 4 / 5);
        graph.SetClientAreaDP(g, ClientRect, 7, 3, 4, 1);
        try {
            if (!this.spDoc.GetXAxisRange(IdCode[0])) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        String StationName = this.spDoc.m_StationName;
        String StationAltStr = this.spDoc.m_StationAltStr;
        String StationAspectStr = this.spDoc.m_StationAspectStr;
        String StationSlopeStr = this.spDoc.m_StationSlopeStr;
        String StationLatStr = this.spDoc.m_StationLatStr;
        String StationLonStr = this.spDoc.m_StationLonStr;
        GregorianCalendar StartTime = this.spDoc.m_StartTime;
        int TimeRange = this.spDoc.m_TimeRange1;
        int TimeStep = this.spDoc.m_TimeStep;
        int xNrOfGrids = this.spDoc.m_TimeGrid;
        int yNrOfGrids = this.spDoc.m_yNrOfGrids;
        float YMinValue = this.spDoc.m_YMinValue;
        float YMaxValue = this.spDoc.m_YMaxValue;
        Rectangle GraphRect = graph.m_GraphRect;
        if (TimeStep == 0 || TimeRange == 0) {
            return;
        }
        int NrOfXValues = TimeRange / TimeStep;
        if (NrOfXValues <= 0) {
            NrOfXValues = 1;
        }
        graph.SetXAxis(StartTime, TimeRange, xNrOfGrids);
        graph.SetYAxis(YMinValue, YMaxValue, yNrOfGrids);
        graph.CalcCoordinateSystem();
        graph.DrawCoordinateAxes(g);
        graph.DrawGrids(g, true);
        graph.DrawXAxisDateText(g, xNrOfGrids, "FULL_DATE");
        graph.DrawAboveBelowText(g, 5.0f, "ALIGN_CENTER", "BOLD", 11, StationName + ", " + StationAltStr + " m", false);
        if (Setup.m_ResearchMode && !StationName.equals("Undefined Station")) {
            if (!StationSlopeStr.equals("")) {
                graph.DrawAboveBelowText(g, 5.0f, "ALIGN_LEFT", "PLAIN", 10, "Slope = " + StationSlopeStr + " deg", false);
            }
            if (!StationAspectStr.equals("")) {
                graph.DrawAboveBelowText(g, 5.8f, "ALIGN_LEFT", "PLAIN", 10, "Aspect = " + StationAspectStr + " deg", false);
            }
            if (!StationLatStr.equals("")) {
                graph.DrawAboveBelowText(g, 5.0f, "ALIGN_RIGHT", "PLAIN", 10, "Latitude = " + StationLatStr, false);
            }
            if (!StationLonStr.equals("")) {
                graph.DrawAboveBelowText(g, 5.8f, "ALIGN_RIGHT", "PLAIN", 10, "Longitude = " + StationLonStr, false);
            }
        }
        if (NrOfParameters == 1) {
            g.setColor(this.spDoc.GetParameterColor(IdCode[0]));
        }
        int NrOfDigits = YMaxValue - YMinValue > 50.0f ? 0 : (YMaxValue - YMinValue > 5.0f ? 1 : 2);
        graph.DrawYAxisText(g, yNrOfGrids, NrOfDigits, "ALIGN_LEFT", "ALIGN_TOP", this.spDoc.GetAxisText(IdCode[0]), this.spDoc.GetAxisUnit(IdCode[0]));
        int i2 = 0;
        while (i2 < NrOfParameters) {
            g.setColor(this.spDoc.GetParameterColor(IdCode[i2]));
            this.spDoc.m_CurrentColor = this.spDoc.GetParameterColor(IdCode[i2]);
            if (NrOfParameters > 1) {
                String space = "";
                if (i2 == 1) {
                    space = "                              ";
                } else if (i2 == 2) {
                    space = "                                                            ";
                } else if (i2 == 3) {
                    space = "                                                                                          ";
                }
                graph.DrawAboveBelowText(g, 7.0f, "ALIGN_LEFT", "PLAIN", 10, space + "-- " + Name2[i2], false);
            }
            boolean symbolDraw = false;
            int symbolSize = 5;
            Point StartPoint = new Point();
            Point EndPoint = new Point();
            this.spDoc.GetFirstValue(IdCode[i2]);
            GregorianCalendar xTime = this.spDoc.m_ActTime;
            MetDataEntry ActDataEntry = (MetDataEntry)this.spDoc.m_ActDataEntry;
            float yValue = ActDataEntry.GetMetData(IdCode[i2]);
            StartPoint = graph.CalcPointLP(xTime, yValue);
            GregorianCalendar xClosestNextTime = (GregorianCalendar)xTime.clone();
            xClosestNextTime.add(13, this.spDoc.m_MinTimeStepInData);
            EndPoint = graph.CalcPointLP(xClosestNextTime, 0.0f);
            symbolDraw = EndPoint.x - StartPoint.x >= symbolSize + 1;
            int j = 0;
            boolean firstValueAfterGap = false;
            do {
                if (this.spDoc.GetNextValue(IdCode[i2])) {
                    xTime = this.spDoc.m_ActTime;
                    ActDataEntry = (MetDataEntry)this.spDoc.m_ActDataEntry;
                    yValue = ActDataEntry.GetMetData(IdCode[i2]);
                    if (firstValueAfterGap) {
                        StartPoint = graph.CalcPointLP(xTime, yValue);
                    } else {
                        EndPoint = graph.CalcPointLP(xTime, yValue);
                        if (StartPoint.y <= graph.CalcYPosLP(YMinValue) && EndPoint.y <= graph.CalcYPosLP(YMinValue)) {
                            g.drawLine(StartPoint.x, StartPoint.y, EndPoint.x, EndPoint.y);
                            if (symbolDraw) {
                                g.fillRect(StartPoint.x - symbolSize / 2, StartPoint.y - symbolSize / 2, symbolSize, symbolSize);
                                g.fillRect(EndPoint.x - symbolSize / 2, EndPoint.y - symbolSize / 2, symbolSize, symbolSize);
                            }
                        } else if (StartPoint.y < graph.CalcYPosLP(YMinValue) && EndPoint.y > graph.CalcYPosLP(YMinValue)) {
                            int EndPointX = StartPoint.x + (EndPoint.x - StartPoint.x) * ((graph.CalcYPosLP(YMinValue) - StartPoint.y) / (EndPoint.y - StartPoint.y));
                            g.drawLine(StartPoint.x, StartPoint.y, EndPointX, graph.CalcYPosLP(YMinValue));
                        } else if (StartPoint.y > graph.CalcYPosLP(YMinValue) && EndPoint.y < graph.CalcYPosLP(YMinValue)) {
                            int StartPointX = StartPoint.x + (EndPoint.x - StartPoint.x) * ((graph.CalcYPosLP(YMinValue) - StartPoint.y) / (EndPoint.y - StartPoint.y));
                            g.drawLine(StartPointX, graph.CalcYPosLP(YMinValue), EndPoint.x, EndPoint.y);
                        }
                        StartPoint.x = EndPoint.x;
                        StartPoint.y = EndPoint.y;
                    }
                    firstValueAfterGap = false;
                    continue;
                }
                firstValueAfterGap = true;
            } while (++j < NrOfXValues);
            ++i2;
        }
        g.setColor(this.getForeground());
        this.spDoc.m_CurrentColor = this.getForeground();
        this.DrawMarker(g, this.m_IdCode);
    }

    void InsertControlObjects() {
        this.setBackground(this.spDoc.m_Background);
        this.setForeground(this.spDoc.m_Foreground);
        this.leftRectSize.width = this.getSize().width;
        this.leftRectSize.height = this.getSize().height;
        this.m_leftRect = new Rectangle(0, 0, this.leftRectSize.width, this.leftRectSize.height);
        Graph graph = new Graph(this.spDoc);
        if (this.spDoc == null) {
            return;
        }
        if (!this.PrepareGraph(graph)) {
            return;
        }
        this.removeAll();
        if (System.getProperty("os.name").substring(0, 3).equals("Win")) {
            this.add((Component)this.spDoc.jSlider, new XYConstraints(graph.m_XAxisStartPos.x - (int)(0.5 * (double)graph.m_SliderHeight), graph.m_YAxisStartPos.y, graph.m_XAxisEndPos.x - graph.m_XAxisStartPos.x + graph.m_SliderHeight, graph.m_SliderHeight));
            this.add((Component)this.spDoc.jButton_Remove, new XYConstraints(graph.m_XAxisStartPos.x - (int)(4.0 * (double)graph.m_SliderHeight), graph.m_YAxisStartPos.y, (int)((double)graph.m_SliderHeight * 1.0), graph.m_SliderHeight));
            this.add((Component)this.spDoc.jButton_Home, new XYConstraints(graph.m_XAxisStartPos.x - (int)(2.9 * (double)graph.m_SliderHeight), graph.m_YAxisStartPos.y, (int)((double)graph.m_SliderHeight * 1.4), graph.m_SliderHeight));
            this.add((Component)this.spDoc.jButton_Prev, new XYConstraints(graph.m_XAxisStartPos.x - (int)(1.5 * (double)graph.m_SliderHeight), graph.m_YAxisStartPos.y, (int)((double)graph.m_SliderHeight * 1.0), graph.m_SliderHeight));
            this.add((Component)this.spDoc.jButton_Next, new XYConstraints(graph.m_XAxisEndPos.x + (int)(0.5 * (double)graph.m_SliderHeight), graph.m_YAxisStartPos.y, (int)((double)graph.m_SliderHeight * 1.0), graph.m_SliderHeight));
            this.add((Component)this.spDoc.jButton_End, new XYConstraints(graph.m_XAxisEndPos.x + (int)(1.5 * (double)graph.m_SliderHeight), graph.m_YAxisStartPos.y, (int)((double)graph.m_SliderHeight * 1.4), graph.m_SliderHeight));
            this.add((Component)this.spDoc.jButton_Up, new XYConstraints(graph.m_XAxisEndPos.x + (int)(0.5 * (double)graph.m_SliderHeight), (graph.m_YAxisStartPos.y + graph.m_YAxisEndPos.y) / 2 - (int)(1.5 * (double)graph.m_SliderHeight), (int)((double)graph.m_SliderHeight * 2.0), graph.m_SliderHeight));
            this.add((Component)this.spDoc.jButton_Down, new XYConstraints(graph.m_XAxisEndPos.x + (int)(0.5 * (double)graph.m_SliderHeight), (graph.m_YAxisStartPos.y + graph.m_YAxisEndPos.y) / 2 + (int)(0.5 * (double)graph.m_SliderHeight), (int)((double)graph.m_SliderHeight * 2.0), graph.m_SliderHeight));
        } else {
            this.add((Component)this.spDoc.jSlider, new XYConstraints(graph.m_XAxisStartPos.x - graph.m_SliderHeight, graph.m_YAxisStartPos.y, graph.m_XAxisEndPos.x - graph.m_XAxisStartPos.x + 2 * graph.m_SliderHeight, graph.m_SliderHeight));
            this.add((Component)this.spDoc.jButton_Remove, new XYConstraints(graph.m_XAxisStartPos.x - (int)(4.0 * (double)graph.m_SliderHeight), graph.m_YAxisStartPos.y - (int)((double)graph.m_SliderHeight * 2.0), (int)((double)graph.m_SliderHeight * 2.5), (int)((double)graph.m_SliderHeight * 2.0)));
            this.add((Component)this.spDoc.jButton_Home, new XYConstraints(graph.m_XAxisStartPos.x - (int)(4.0 * (double)graph.m_SliderHeight), graph.m_YAxisStartPos.y - (int)((double)graph.m_SliderHeight * 1.0), (int)((double)graph.m_SliderHeight * 2.5), (int)((double)graph.m_SliderHeight * 2.0)));
            this.add((Component)this.spDoc.jButton_Prev, new XYConstraints(graph.m_XAxisStartPos.x - (int)(4.0 * (double)graph.m_SliderHeight), graph.m_YAxisStartPos.y, (int)((double)graph.m_SliderHeight * 2.5), (int)((double)graph.m_SliderHeight * 2.0)));
            this.add((Component)this.spDoc.jButton_Next, new XYConstraints(graph.m_XAxisEndPos.x + (int)(1.0 * (double)graph.m_SliderHeight), graph.m_YAxisStartPos.y, (int)((double)graph.m_SliderHeight * 2.5), (int)((double)graph.m_SliderHeight * 2.0)));
            this.add((Component)this.spDoc.jButton_End, new XYConstraints(graph.m_XAxisEndPos.x + (int)(1.0 * (double)graph.m_SliderHeight), graph.m_YAxisStartPos.y - (int)((double)graph.m_SliderHeight * 1.0), (int)((double)graph.m_SliderHeight * 2.5), (int)((double)graph.m_SliderHeight * 2.0)));
            this.add((Component)this.spDoc.jButton_Up, new XYConstraints(graph.m_XAxisEndPos.x + (int)(0.2 * (double)graph.m_SliderHeight), (graph.m_YAxisStartPos.y + graph.m_YAxisEndPos.y) / 2 - 3 * graph.m_SliderHeight, (int)((double)graph.m_SliderHeight * 3.2), (int)((double)graph.m_SliderHeight * 2.0)));
            this.add((Component)this.spDoc.jButton_Down, new XYConstraints(graph.m_XAxisEndPos.x + (int)(0.2 * (double)graph.m_SliderHeight), (graph.m_YAxisStartPos.y + graph.m_YAxisEndPos.y) / 2 + graph.m_SliderHeight, (int)((double)graph.m_SliderHeight * 3.2), (int)((double)graph.m_SliderHeight * 2.0)));
        }
        this.spDoc.jSlider.setVisible(true);
    }

    boolean PrepareGraph(Graph graph) {
        Graphics g = this.getGraphics();
        GregorianCalendar StartTime = this.spDoc.m_StartTime;
        int TimeRange = this.spDoc.m_TimeRange1;
        int TimeStep = this.spDoc.m_TimeStep;
        int xNrOfGrids = this.spDoc.m_TimeGrid;
        int yNrOfGrids = this.spDoc.m_yNrOfGrids;
        float YMinValue = this.spDoc.m_YMinValue;
        float YMaxValue = this.spDoc.m_YMaxValue;
        if (TimeStep == 0 || TimeRange == 0) {
            return false;
        }
        int NrOfXValues = TimeRange / TimeStep;
        if (NrOfXValues <= 0) {
            NrOfXValues = 1;
        }
        Rectangle ClientRect = new Rectangle(this.m_leftRect.x, this.m_leftRect.y, this.m_leftRect.width, this.m_leftRect.height * 4 / 5);
        graph.SetClientAreaDP(g, ClientRect, 7, 3, 4, 1);
        graph.SetXAxis(StartTime, TimeRange, xNrOfGrids);
        graph.SetYAxis(YMinValue, YMaxValue, yNrOfGrids);
        graph.CalcCoordinateSystem();
        return true;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.spDoc.datafile_m_ActStartTime != null) {
            this.spDoc.RetrieveDataFile();
        }
        this.DrawSnowPackView(g);
    }

    void setIdCode(int IdCode) {
        this.m_IdCode = IdCode;
    }
}

