/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.C_DataFile;
import ProWin.FileDisplay;
import ProWin.MenuFrame;
import ProWin.MessageBox;
import ProWin.Setup;
import ProWin.YesNoDialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;

public class ModelRun
implements Runnable,
C_DataFile {
    String MODEL_DIRECTORY;
    MenuFrame mFrame;
    File outfile;
    Process p = null;
    Thread runThread = null;

    public ModelRun(MenuFrame mFrame, String MODEL_DIRECTORY, File outfile) {
        this.mFrame = mFrame;
        this.outfile = outfile;
        this.MODEL_DIRECTORY = MODEL_DIRECTORY;
        this.runThread = new Thread((Runnable)this, "ModelRun");
        this.runThread.setPriority(6);
        this.runThread.start();
    }

    void ModelLogFileDisplay(boolean callFromRunThread) {
        System.out.println("ModelRun: in Model Log file");
        if (Setup.m_SnowPackPath == "") {
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Note", "Path of ModelLogFile unknown.", "Start the SNOWPACK model first!");
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            return;
        }
        String SnowPackPath = Setup.m_SnowPackPath;
        File modelLogFile = new File(SnowPackPath + "/ModelLogFile");
        if (!modelLogFile.exists()) {
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Error", "File does not exist: ", SnowPackPath + "/ModelLogFile");
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            return;
        }
        if (this.runThread.isAlive() && !callFromRunThread) {
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Note", "Model execution not terminated yet.", "Please try again later.");
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            return;
        }
        FileDisplay fd = new FileDisplay((Frame)this.mFrame, "ModelLogFile (SNOWPACK model run information)", true, SnowPackPath + "/ModelLogFile");
        fd.setLocation(this.mFrame.DialogCorner(fd, this.mFrame));
        fd.setVisible(true);
    }

    public void run() {
        String slash;
        String scriptName;
        String programName;
        Setup.modelRunning = true;
        System.out.println("OS = " + System.getProperty("os.name"));
        String osName = System.getProperty("os.name").toLowerCase();
        String[] commandLine = null;
        if (osName.startsWith("win") || osName.startsWith("nt")) {
            programName = "snowpack.exe";
            scriptName = "Model_Start.bat";
            slash = "\\";
            commandLine = new String[]{"cmd.exe", "/C", scriptName, this.MODEL_DIRECTORY};
            System.out.println(System.getProperty("user.dir"));
        } else {
            programName = "snowpack";
            scriptName = "Model_Start";
            slash = "/";
            commandLine = new String[]{scriptName, this.MODEL_DIRECTORY};
        }
        File scriptFile = new File(scriptName);
        if (!scriptFile.exists()) {
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Error", "Script file does not exist: ", scriptName);
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            Setup.modelRunning = false;
            return;
        }
        File programFile = new File(this.MODEL_DIRECTORY + slash + programName);
        if (!programFile.exists()) {
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Error", "Program file does not exist: ", this.MODEL_DIRECTORY + slash + programName);
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            Setup.modelRunning = false;
            return;
        }
        try {
            Runtime r = Runtime.getRuntime();
            Process p = null;
            p = r.exec(commandLine);
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Note", "SNOWPACK model successfully started.", "You will be notified upon termination.");
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            System.out.println("SNOWPACK model started; command line = " + commandLine[0] + " " + commandLine[1] + " " + commandLine[2]);
            p.waitFor();
            Toolkit.getDefaultToolkit().beep();
            if (p.exitValue() != 0) {
                mBox = new MessageBox((Frame)this.mFrame, "Note", "SNOWPACK model run terminated.", "Runtime errors, exit value = " + p.exitValue() + "!");
                mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
                mBox.setVisible(true);
            } else {
                mBox = new MessageBox((Frame)this.mFrame, "Note", "SNOWPACK model run terminated.", "No runtime errors (exit value = 0).");
                mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
                mBox.setVisible(true);
                this.ModelLogFileDisplay(true);
                if (!this.outfile.exists()) {
                    mBox = new MessageBox((Frame)this.mFrame, "Note", "Display not possible, model output file not found: ", this.outfile.getPath() + "!");
                    mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
                    mBox.setVisible(true);
                } else {
                    YesNoDialog ynd = new YesNoDialog(this.mFrame, "Model Output Display", "Do you want to visualize the output", "of the model run right now?", "Yes", "No, later", true);
                    ynd.setLocation(this.mFrame.DialogCorner(ynd, this.mFrame));
                    ynd.setVisible(true);
                    if (ynd.action) {
                        this.mFrame.setVisible(true);
                        this.mFrame.NewFrame(this.outfile, 503);
                    } else {
                        mBox = new MessageBox((Frame)this.mFrame, "Info", "Output display later: Close all open frames with same", "name as constructed file. Otherwise no data refresh!");
                        mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
                        mBox.setVisible(true);
                    }
                }
            }
            System.out.println("SNOWPACK finished, exit value = " + p.exitValue());
        }
        catch (Exception e1) {
            MessageBox mBox = new MessageBox((Frame)this.mFrame, "Error", "Error executing the SNOWPACK model:", e1.toString());
            mBox.setLocation(this.mFrame.DialogCorner(mBox, this.mFrame));
            mBox.setVisible(true);
            System.out.println("Error executing SNOWPACK: " + e1);
        }
        Setup.modelRunning = false;
    }
}

