/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.Utils;
import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;

public class MapImage {
    FileNotFoundException ex1 = new FileNotFoundException();
    FileNotFoundException ex2 = new FileNotFoundException();
    FileNotFoundException exFinal = new FileNotFoundException();
    private Image image;
    private boolean isGeoreferenced;
    private String worldFileName1;
    private String worldFileName2;
    private String worldFileName3;
    private float xCellsize;
    private float xulCorner;
    private float yCellsize;
    private float yulCorner;

    public MapImage(File file) {
        try {
            this.image = ImageIO.read(file);
            this.isGeoreferenced = this.readWorldFile(file);
        }
        catch (IOException ex) {
            System.out.println(ex.getLocalizedMessage());
        }
    }

    public Image getImage() {
        return this.image;
    }

    public String getWorldFileName1() {
        return this.worldFileName1;
    }

    public String getWorldFileName2() {
        return this.worldFileName2;
    }

    public String getWorldFileName3() {
        return this.worldFileName3;
    }

    public float getXCellsize() {
        return this.xCellsize;
    }

    public float getXulCorner() {
        return this.xulCorner;
    }

    public float getYCellsize() {
        return this.yCellsize;
    }

    public float getYulCorner() {
        return this.yulCorner;
    }

    public boolean isGeoreferenced() {
        return this.isGeoreferenced;
    }

    /*
     * WARNING - void declaration
     */
    public boolean readWorldFile(File file) {
        this.worldFileName1 = Utils.getAbsoluteBaseName(file) + ".tfw";
        this.worldFileName2 = Utils.getAbsoluteBaseName(file) + ".jpw";
        this.worldFileName3 = Utils.getAbsoluteBaseName(file) + ".pnw";
        FileReader in = null;
        try {
            in = new FileReader(this.worldFileName1);
        }
        catch (FileNotFoundException ex1) {
            try {
                this.ex1 = ex1;
                System.out.println(ex1.getMessage());
                in = new FileReader(this.worldFileName2);
            }
            catch (FileNotFoundException ex2) {
                try {
                    this.ex2 = ex2;
                    System.out.println(ex2.getMessage());
                    in = new FileReader(this.worldFileName3);
                }
                catch (FileNotFoundException ex3) {
                    this.exFinal = ex3;
                    System.out.println(ex3.getMessage());
                    return false;
                }
            }
        }
        LineNumberReader lnr = new LineNumberReader(in);
        float[] header = new float[6];
        int count = 0;
        try {
            String line;
            while ((line = lnr.readLine()) != null) {
                void ex2;
                StringTokenizer token = new StringTokenizer((String)ex2, " ", false);
                while (token.hasMoreTokens()) {
                    header[count] = Float.parseFloat(token.nextToken());
                    ++count;
                }
            }
        }
        catch (IOException ex3) {
            System.out.println(ex3.getMessage());
        }
        this.xCellsize = header[0];
        this.yCellsize = Math.abs(header[3]);
        this.xulCorner = header[4];
        this.yulCorner = header[5];
        return true;
    }
}

