/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.SnowPackDoc;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;

public class Graph {
    int m_AxisOverlap = 5;
    Font m_Font;
    Rectangle m_GraphRect = new Rectangle();
    int m_SliderHeight = 10;
    GregorianCalendar m_StartTime = new GregorianCalendar(new SimpleTimeZone(3600000, "MEZ"));
    int m_TimeRange = 0;
    Point m_XAxisEndPos;
    Point m_XAxisStartPos = new Point();
    float m_XCalcPointFactor = 0.0f;
    float m_XMaxValue = 0.0f;
    float m_XMinValue = 0.0f;
    int m_XNrOfGrids = 0;
    Point m_YAxisEndPos;
    Point m_YAxisStartPos;
    float m_YCalcPointFactor = 0.0f;
    float m_YMaxValue = 0.0f;
    float m_YMinValue = 0.0f;
    int m_YNrOfGrids = 0;
    SnowPackDoc spDoc;

    public Graph(SnowPackDoc spDoc) {
        this.m_XAxisEndPos = new Point();
        this.m_YAxisStartPos = new Point();
        this.m_YAxisEndPos = new Point();
        this.spDoc = spDoc;
        this.m_Font = new Font("Dialog", 0, 10);
    }

    void CalcCoordinateSystem() {
        int LenXAxis = 0;
        int LenYAxis = 0;
        int LenXAxisNegativ = 0;
        int LenYAxisNegativ = 0;
        LenXAxis = this.m_GraphRect.width;
        LenYAxis = this.m_GraphRect.height;
        if (this.m_XMinValue != this.m_XMaxValue && this.m_XMinValue < 0.0f) {
            LenXAxisNegativ = (int)((double)((0.0f - this.m_XMinValue) / (this.m_XMaxValue - this.m_XMinValue) * (float)LenXAxis) + 0.5);
        }
        if (this.m_YMinValue != this.m_YMaxValue && this.m_YMinValue < 0.0f) {
            LenYAxisNegativ = (int)((double)((0.0f - this.m_YMinValue) / (this.m_YMaxValue - this.m_YMinValue) * (float)LenYAxis) + 0.5);
        }
        this.m_XAxisStartPos.x = this.m_GraphRect.x;
        this.m_XAxisStartPos.y = this.m_GraphRect.y + LenYAxis - LenYAxisNegativ;
        this.m_XAxisEndPos.x = this.m_XAxisStartPos.x + LenXAxis;
        this.m_XAxisEndPos.y = this.m_XAxisStartPos.y;
        this.m_YAxisStartPos.x = this.m_XAxisStartPos.x + LenXAxisNegativ;
        this.m_YAxisStartPos.y = this.m_GraphRect.y + LenYAxis;
        this.m_YAxisEndPos.x = this.m_YAxisStartPos.x;
        this.m_YAxisEndPos.y = this.m_GraphRect.y;
        if (this.m_XMinValue != this.m_XMaxValue) {
            this.m_XCalcPointFactor = (float)LenXAxis / (this.m_XMaxValue - this.m_XMinValue);
        }
        if (this.m_YMinValue != this.m_YMaxValue) {
            this.m_YCalcPointFactor = (float)LenYAxis / (this.m_YMaxValue - this.m_YMinValue);
        }
    }

    Point CalcPointLP(GregorianCalendar xTime, float y) {
        Point RetPoint = new Point();
        RetPoint.x = this.CalcXPosLP(xTime);
        RetPoint.y = this.CalcYPosLP(y);
        return RetPoint;
    }

    Point CalcPointLP(float x, float y) {
        Point RetPoint = new Point();
        RetPoint.x = this.CalcXPosLP(x);
        RetPoint.y = this.CalcYPosLP(y);
        return RetPoint;
    }

    int CalcXPosLP(float x) {
        return (int)((double)((x - this.m_XMinValue) * this.m_XCalcPointFactor + (float)this.m_XAxisStartPos.x) + 0.5);
    }

    int CalcXPosLP(GregorianCalendar xTime) {
        return (int)((float)(xTime.getTime().getTime() - this.m_StartTime.getTime().getTime()) * this.m_XCalcPointFactor / 1000.0f + (float)this.m_XAxisStartPos.x);
    }

    int CalcYPosLP(float y) {
        return (int)((double)(-(y - this.m_YMinValue) * this.m_YCalcPointFactor + (float)this.m_YAxisStartPos.y) + 0.5);
    }

    void DrawAboveBelowText(Graphics g, float Line, String AxisTextStyleFlags, String AxisTextStyleFlags1, int FontSize, String ValueStr, boolean erase) {
        Point GridStartPos = new Point();
        Point SizeText = new Point();
        Font font = null;
        font = AxisTextStyleFlags1.equals("BOLD") ? new Font("Dialog", 1, FontSize) : (AxisTextStyleFlags1.equals("ITALIC") ? new Font("Dialog", 2, FontSize) : new Font("Dialog", 2, FontSize));
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        SizeText.y = fm.getHeight();
        SizeText.x = fm.stringWidth(ValueStr);
        int Ascent = fm.getAscent();
        if (AxisTextStyleFlags.equals("ALIGN_RIGHT")) {
            GridStartPos.x = this.m_XAxisEndPos.x - SizeText.x;
        } else if (AxisTextStyleFlags.equals("ALIGN_CENTER")) {
            GridStartPos.x = this.m_XAxisStartPos.x + (this.m_XAxisEndPos.x - this.m_XAxisStartPos.x) / 2;
            GridStartPos.x -= SizeText.x / 2;
        } else {
            GridStartPos.x = this.m_XAxisStartPos.x;
        }
        GridStartPos.y = Line > 0.0f ? this.m_YAxisStartPos.y + Ascent + this.m_AxisOverlap + (int)((double)((Line - 1.0f) * (float)SizeText.y) + 0.5) : this.m_YAxisEndPos.y - this.m_AxisOverlap + (int)((double)((Line + 1.0f) * (float)SizeText.y) + 0.5);
        if (erase) {
            g.setColor(this.spDoc.m_Background);
            g.fillRect(this.m_XAxisStartPos.x, GridStartPos.y - Ascent, 2 * (this.m_XAxisEndPos.x - this.m_XAxisStartPos.x), SizeText.y);
            g.setColor(this.spDoc.m_CurrentColor);
        }
        g.drawString(ValueStr, GridStartPos.x, GridStartPos.y);
    }

    void DrawCenteredDate(Graphics g, GregorianCalendar xTime, String AxisTextStyleFlags) {
        Point GridStartPos = new Point();
        String AxisValueStr = null;
        Point SizeText = new Point();
        GridStartPos.x = this.m_XAxisStartPos.x + (this.m_XAxisEndPos.x - this.m_XAxisStartPos.x) / 2;
        GridStartPos.y = this.m_YAxisStartPos.y;
        g.setFont(this.m_Font);
        FontMetrics fm = g.getFontMetrics();
        SizeText.y = fm.getHeight();
        int Ascent = fm.getAscent();
        AxisValueStr = AxisTextStyleFlags.equals("SHORT_DATE") ? "Time: " + Graph.TimeToString(xTime).substring(9, 14) : "Time: " + Graph.TimeToString(xTime).substring(9, 17);
        SizeText.x = fm.stringWidth(AxisValueStr);
        g.setColor(this.spDoc.m_Background);
        g.fillRect(this.m_XAxisStartPos.x, GridStartPos.y + this.m_AxisOverlap, this.m_XAxisEndPos.x - this.m_XAxisStartPos.x, SizeText.y);
        g.setColor(this.spDoc.m_CurrentColor);
        g.drawString(AxisValueStr, GridStartPos.x - SizeText.x / 2, GridStartPos.y + this.m_AxisOverlap + Ascent);
        AxisValueStr = AxisTextStyleFlags.equals("SHORT_DATE") ? "Date:  " + Graph.TimeToString(xTime).substring(0, 5) : "Date:  " + Graph.TimeToString(xTime).substring(0, 8);
        SizeText.x = fm.stringWidth(AxisValueStr);
        g.setColor(this.spDoc.m_Background);
        g.fillRect(this.m_XAxisStartPos.x, GridStartPos.y + this.m_AxisOverlap + SizeText.y, this.m_XAxisEndPos.x - this.m_XAxisStartPos.x, SizeText.y);
        g.setColor(this.spDoc.m_CurrentColor);
        g.drawString(AxisValueStr, GridStartPos.x - SizeText.x / 2, GridStartPos.y + this.m_AxisOverlap + SizeText.y + Ascent);
    }

    void DrawCoordinateAxes(Graphics g) {
        g.drawLine(this.m_XAxisStartPos.x - this.m_AxisOverlap, this.m_XAxisStartPos.y, this.m_XAxisEndPos.x + this.m_AxisOverlap, this.m_XAxisEndPos.y);
        g.drawLine(this.m_YAxisStartPos.x, this.m_YAxisStartPos.y + this.m_AxisOverlap, this.m_YAxisEndPos.x, this.m_YAxisEndPos.y - this.m_AxisOverlap);
    }

    void DrawGrids(Graphics g, boolean sliderSpace) {
        int i;
        float GridOffset;
        Point GridStartPos = new Point();
        Point GridEndPos = new Point();
        if (this.m_XNrOfGrids > 0) {
            GridStartPos.x = this.m_XAxisStartPos.x;
            GridStartPos.y = this.m_YAxisStartPos.y;
            GridEndPos.y = this.m_YAxisEndPos.y;
            GridOffset = (float)(this.m_XAxisEndPos.x - this.m_XAxisStartPos.x) / (float)this.m_XNrOfGrids;
            i = 0;
            while (i <= this.m_XNrOfGrids) {
                if (GridStartPos.x - 1 > this.m_YAxisStartPos.x || GridStartPos.x + 1 < this.m_YAxisStartPos.x) {
                    int space = 0;
                    if (sliderSpace) {
                        space = this.m_SliderHeight;
                    }
                    int j = GridStartPos.y + this.m_AxisOverlap + space;
                    while (j > GridEndPos.y - this.m_AxisOverlap) {
                        g.drawLine(GridStartPos.x, j, GridStartPos.x, j - 1);
                        j -= 4;
                    }
                }
                GridStartPos.x = this.m_XAxisStartPos.x + (int)((double)((float)(i + 1) * GridOffset) + 0.5);
                ++i;
            }
        }
        if (this.m_YNrOfGrids > 0) {
            GridStartPos.y = this.m_YAxisStartPos.y;
            GridStartPos.x = this.m_XAxisStartPos.x;
            GridEndPos.x = this.m_XAxisEndPos.x;
            GridOffset = (float)(this.m_YAxisEndPos.y - this.m_YAxisStartPos.y) / (float)this.m_YNrOfGrids;
            i = 0;
            while (i <= this.m_YNrOfGrids) {
                if (GridStartPos.y - 1 > this.m_XAxisStartPos.y || GridStartPos.y + 1 < this.m_XAxisStartPos.y) {
                    int j = GridStartPos.x - this.m_AxisOverlap;
                    while (j < GridEndPos.x + this.m_AxisOverlap) {
                        g.drawLine(j, GridStartPos.y, j + 1, GridStartPos.y);
                        j += 4;
                    }
                }
                GridStartPos.y = this.m_YAxisStartPos.y + (int)((double)((float)(i + 1) * GridOffset) + 0.5);
                ++i;
            }
        }
    }

    void DrawGroundSurface(Graphics g) {
        g.drawLine(this.m_XAxisStartPos.x - this.m_AxisOverlap, this.m_XAxisStartPos.y, this.m_XAxisEndPos.x + this.m_AxisOverlap, this.m_XAxisEndPos.y);
        int HoriDist = 10;
        int VertLength = 10;
        int Displacement = -7;
        int i = this.m_XAxisStartPos.x;
        while (i < this.m_XAxisEndPos.x + 10) {
            g.drawLine(i, this.m_XAxisStartPos.y, i + Displacement, this.m_XAxisStartPos.y + VertLength);
            i += HoriDist;
        }
    }

    void DrawXAxisDateText(Graphics g, int NrOfDiv, String AxisTextStyleFlags) {
        if (NrOfDiv > 0) {
            Point GridStartPos = new Point();
            String AxisValueStr = null;
            Point SizeText = new Point();
            GregorianCalendar AxisTime = (GregorianCalendar)this.m_StartTime.clone();
            int ValueOffset = (int)((double)(this.m_TimeRange / NrOfDiv) + 0.5);
            GridStartPos.x = this.m_XAxisStartPos.x;
            GridStartPos.y = this.m_YAxisStartPos.y;
            float GridOffset = (float)(this.m_XAxisEndPos.x - this.m_XAxisStartPos.x) / (float)NrOfDiv;
            g.setFont(this.m_Font);
            FontMetrics fm = g.getFontMetrics();
            SizeText.y = fm.getHeight();
            int Ascent = fm.getAscent();
            int LastTextEndPosX = 0;
            int LastTextSizeX = 0;
            int i = 0;
            while (i <= NrOfDiv) {
                AxisValueStr = AxisTextStyleFlags.equals("SHORT_DATE") ? Graph.TimeToString(AxisTime).substring(9, 14) : Graph.TimeToString(AxisTime).substring(9, 17);
                SizeText.x = fm.stringWidth(AxisValueStr);
                int TextStartPosX = GridStartPos.x - SizeText.x / 2;
                LastTextSizeX = SizeText.x;
                if (TextStartPosX > LastTextEndPosX) {
                    g.drawString(AxisValueStr, TextStartPosX, GridStartPos.y + this.m_AxisOverlap + Ascent + this.m_SliderHeight);
                    AxisValueStr = AxisTextStyleFlags.equals("SHORT_DATE") ? Graph.TimeToString(AxisTime).substring(0, 5) : Graph.TimeToString(AxisTime).substring(0, 8);
                    SizeText.x = fm.stringWidth(AxisValueStr);
                    if (SizeText.x > LastTextSizeX) {
                        LastTextSizeX = SizeText.x;
                    }
                    g.drawString(AxisValueStr, GridStartPos.x - SizeText.x / 2, GridStartPos.y + this.m_AxisOverlap + SizeText.y + Ascent + this.m_SliderHeight);
                    LastTextEndPosX = (int)((double)TextStartPosX + (double)LastTextSizeX * 1.1 + 0.5);
                }
                GridStartPos.x = this.m_XAxisStartPos.x + (int)((double)((float)(i + 1) * GridOffset) + 0.5);
                AxisTime.add(13, ValueOffset);
                ++i;
            }
        }
    }

    void DrawXAxisText(Graphics g, float Line, int NrOfDiv, int DigitsAfterDecPoint) {
        if (NrOfDiv > 0) {
            Point GridStartPos = new Point();
            Point SizeText = new Point();
            Float AxisValue = new Float(this.m_XMinValue);
            float ValueOffset = (this.m_XMaxValue - this.m_XMinValue) / (float)NrOfDiv;
            GridStartPos.x = this.m_XAxisStartPos.x;
            float GridOffset = (float)(this.m_XAxisEndPos.x - this.m_XAxisStartPos.x) / (float)NrOfDiv;
            g.setFont(this.m_Font);
            FontMetrics fm = g.getFontMetrics();
            SizeText.y = fm.getHeight();
            int Ascent = fm.getAscent();
            GridStartPos.y = this.m_YAxisStartPos.y + this.m_AxisOverlap + Ascent + (int)((double)((Line - 1.0f) * (float)SizeText.y) + 0.5);
            int LastTextEndPosX = 0;
            int i = 0;
            while (i <= NrOfDiv) {
                String AxisValueStr = this.ValueToString(AxisValue, DigitsAfterDecPoint);
                SizeText.x = fm.stringWidth(AxisValueStr);
                int TextStartPosX = GridStartPos.x - SizeText.x / 2;
                if (TextStartPosX > LastTextEndPosX) {
                    g.drawString(AxisValueStr, TextStartPosX, GridStartPos.y);
                    LastTextEndPosX = (int)((double)TextStartPosX + (double)SizeText.x * 1.1 + 0.5);
                }
                GridStartPos.x = this.m_XAxisStartPos.x + (int)((double)((float)(i + 1) * GridOffset) + 0.5);
                AxisValue = new Float(AxisValue.floatValue() + ValueOffset);
                ++i;
            }
        }
    }

    void DrawYAxisText(Graphics g, int NrOfDiv, int DigitsAfterDecPoint, String AxisTextStyleFlag1, String AxisTextStyleFlag2, String ParameterName, String Unit) {
        if (NrOfDiv > 0) {
            String AxisValueStr;
            int MaxTextExtent = 0;
            Point GridStartPos = new Point();
            Point SizeText = new Point();
            Float AxisValue = new Float(this.m_YMinValue);
            float ValueOffset = (this.m_YMaxValue - this.m_YMinValue) / (float)NrOfDiv;
            GridStartPos.x = AxisTextStyleFlag1.equals("ALIGN_LEFT") ? this.m_XAxisStartPos.x : this.m_XAxisEndPos.x;
            GridStartPos.y = this.m_YAxisStartPos.y;
            float GridOffset = (float)(this.m_YAxisEndPos.y - this.m_YAxisStartPos.y) / (float)NrOfDiv;
            g.setFont(this.m_Font);
            FontMetrics fm = g.getFontMetrics();
            SizeText.x = fm.stringWidth("0");
            int TextXOffset = SizeText.x / 3 + this.m_AxisOverlap;
            int i = 0;
            while (i <= NrOfDiv) {
                AxisValueStr = this.ValueToString(AxisValue, DigitsAfterDecPoint);
                SizeText.x = fm.stringWidth(AxisValueStr);
                SizeText.y = fm.getAscent();
                if (SizeText.x > MaxTextExtent) {
                    MaxTextExtent = SizeText.x;
                }
                if (i == 0) {
                    SizeText.y = 0;
                }
                if (AxisTextStyleFlag1.equals("ALIGN_LEFT")) {
                    g.drawString(AxisValueStr, GridStartPos.x - SizeText.x - TextXOffset, GridStartPos.y + SizeText.y / 2);
                } else {
                    g.drawString(AxisValueStr, GridStartPos.x + TextXOffset, GridStartPos.y + SizeText.y / 2);
                }
                GridStartPos.y = this.m_YAxisStartPos.y + (int)((double)((float)(i + 1) * GridOffset) + 0.5);
                AxisValue = new Float(AxisValue.floatValue() + ValueOffset);
                ++i;
            }
            AxisValueStr = ParameterName != null && Unit != null ? ParameterName + " (" + Unit + ")" : "";
            fm = g.getFontMetrics();
            SizeText.x = fm.stringWidth(AxisValueStr);
            SizeText.y = fm.getHeight();
            AffineTransform at = new AffineTransform();
            at.setToRotation(4.71238898038469);
            Font verticalFont = this.m_Font.deriveFont(at);
            g.setFont(verticalFont);
            GridStartPos.x = AxisTextStyleFlag1.equals("ALIGN_LEFT") ? this.m_XAxisStartPos.x - MaxTextExtent - 2 * TextXOffset : this.m_XAxisEndPos.x + MaxTextExtent + 2 * TextXOffset;
            if (AxisTextStyleFlag2.equals("ALIGN_TOP")) {
                GridStartPos.y = this.m_YAxisEndPos.y + SizeText.x;
            } else if (AxisTextStyleFlag2.equals("ALIGN_BOTTOM")) {
                GridStartPos.y = this.m_YAxisStartPos.y - this.m_AxisOverlap;
            } else {
                GridStartPos.y = this.m_YAxisStartPos.y + (this.m_YAxisEndPos.y - this.m_YAxisStartPos.y) / 2;
                GridStartPos.y -= SizeText.x / 2;
            }
            g.drawString(AxisValueStr, GridStartPos.x, GridStartPos.y);
        }
    }

    void InsertArrow(Graphics g, float XMinValue, float XMaxValue, float height) {
        Point StartPoint = new Point();
        Point TopPoint = new Point();
        Point SidePoint1 = new Point();
        Point SidePoint2 = new Point();
        int ArrowLength = (int)(0.2 * (double)(this.CalcXPosLP(XMaxValue) - this.CalcXPosLP(XMinValue)));
        StartPoint.x = this.CalcXPosLP(XMaxValue);
        StartPoint.y = this.CalcYPosLP(height);
        TopPoint.x = this.CalcXPosLP(XMaxValue) - ArrowLength;
        TopPoint.y = StartPoint.y;
        SidePoint1.x = StartPoint.x - (int)(0.75 * (double)ArrowLength);
        SidePoint1.y = StartPoint.y - (int)(0.15 * (double)ArrowLength);
        SidePoint2.x = SidePoint1.x;
        SidePoint2.y = StartPoint.y + (int)(0.15 * (double)ArrowLength);
        g.drawLine(StartPoint.x, StartPoint.y, TopPoint.x, TopPoint.y);
        g.drawLine(StartPoint.x, StartPoint.y - 1, TopPoint.x, TopPoint.y - 1);
        g.drawLine(SidePoint1.x, SidePoint1.y - 1, TopPoint.x, TopPoint.y - 1);
        g.drawLine(SidePoint2.x, SidePoint2.y, TopPoint.x, TopPoint.y);
        g.drawLine(SidePoint1.x, SidePoint1.y, SidePoint2.x, SidePoint2.y);
    }

    void SetClientAreaDP(Graphics g, Rectangle ClientRect, int NrOfYAxisCharLeft, int NrOfYAxisCharRight, int NrOfBottomLines, int NrOfTopLines) {
        this.m_GraphRect = ClientRect;
        g.setFont(this.m_Font);
        FontMetrics fm = g.getFontMetrics();
        int yBorderLeft = (NrOfYAxisCharLeft + 1) * fm.charWidth('a') + fm.getHeight();
        int yBorderRight = (NrOfYAxisCharRight + 1) * fm.charWidth('a') + fm.getHeight();
        int xBorder = fm.getHeight();
        this.m_GraphRect.x += yBorderLeft;
        this.m_GraphRect.y += NrOfTopLines * xBorder;
        this.m_GraphRect.height -= (NrOfTopLines + NrOfBottomLines) * xBorder;
        this.m_GraphRect.width -= yBorderLeft + yBorderRight;
        this.m_SliderHeight = xBorder;
    }

    int SetXAxis(GregorianCalendar StartTime, int TimeRange, int NrOfGrids) {
        this.m_StartTime = StartTime;
        this.m_TimeRange = TimeRange;
        return this.SetXAxis(this.m_StartTime.getTime().getTime() / 1000L, this.m_StartTime.getTime().getTime() / 1000L + (long)TimeRange, NrOfGrids);
    }

    int SetXAxis(float MinValue, float MaxValue, int NrOfGrids) {
        this.m_XMinValue = MinValue;
        this.m_XMaxValue = MaxValue;
        this.m_XNrOfGrids = NrOfGrids;
        return 0;
    }

    int SetYAxis(float MinValue, float MaxValue, int NrOfGrids) {
        this.m_YMinValue = MinValue;
        this.m_YMaxValue = MaxValue;
        this.m_YNrOfGrids = NrOfGrids;
        return 0;
    }

    public static String TimeToString(GregorianCalendar Time) {
        Integer CalYear = new Integer(Time.get(1) % 100);
        Integer CalMonth = new Integer(Time.get(2) + 1);
        Integer CalDay = new Integer(Time.get(5));
        Integer CalHour = new Integer(Time.get(11));
        Integer CalMinute = new Integer(Time.get(12));
        Integer CalSecond = new Integer(Time.get(13));
        String YearStr = CalYear < 10 ? "0" + CalYear.toString() : CalYear.toString();
        String MonthStr = CalMonth < 10 ? "0" + CalMonth.toString() : CalMonth.toString();
        String DayStr = CalDay < 10 ? "0" + CalDay.toString() : CalDay.toString();
        String HourStr = CalHour < 10 ? "0" + CalHour.toString() : CalHour.toString();
        String MinuteStr = CalMinute < 10 ? "0" + CalMinute.toString() : CalMinute.toString();
        String SecondStr = CalSecond < 10 ? "0" + CalSecond.toString() : CalSecond.toString();
        return DayStr + "." + MonthStr + "." + YearStr + " " + HourStr + ":" + MinuteStr + ":" + SecondStr;
    }

    String ValueToString(Float AxisValue, int DigitsAfterDecPoint) {
        String AxisValueStr;
        boolean isInteger = true;
        Float AxisValue1 = new Float(AxisValue.floatValue());
        if ((double)AxisValue.floatValue() < 1.0E-4 && (double)AxisValue.floatValue() > -1.0E-4) {
            AxisValue1 = new Float(0.0);
        }
        String AxisValueStr1 = AxisValue1.toString();
        int j = 0;
        while (j < AxisValueStr1.length()) {
            if (AxisValueStr1.substring(j, j + 1).equals(".")) {
                isInteger = false;
                break;
            }
            ++j;
        }
        if (isInteger) {
            AxisValueStr = AxisValueStr1;
        } else if (DigitsAfterDecPoint <= 0) {
            AxisValueStr = AxisValueStr1.substring(0, j);
        } else if (AxisValueStr1.length() > j + 1 + DigitsAfterDecPoint) {
            float temp = Float.parseFloat(AxisValueStr1.substring(0, j + DigitsAfterDecPoint + 2));
            temp *= (float)Math.pow(10.0, DigitsAfterDecPoint);
            temp = Math.round(temp);
            AxisValueStr = new Float(temp /= (float)Math.pow(10.0, DigitsAfterDecPoint)).toString();
        } else if (AxisValueStr1.length() == j + 1 + DigitsAfterDecPoint) {
            AxisValueStr = AxisValueStr1;
        } else {
            AxisValueStr = AxisValueStr1;
            int k = 0;
            while (k < j + 1 + DigitsAfterDecPoint - AxisValueStr1.length()) {
                AxisValueStr = AxisValueStr + "0";
                ++k;
            }
        }
        return AxisValueStr;
    }
}

