/*
 * Decompiled with CFR 0.152.
 */
package alpine3d;

import alpine3d.ASCIIFileReader;
import alpine3d.FileSpecIF;
import alpine3d.SurfaceArea;
import alpine3d.SurfaceCodeReader;
import alpine3d.Utils;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.swing.JRadioButton;

public class RasterImage {
    private byte[] a;
    private byte[] b;
    private ColorModel colorModel;
    private DataBuffer dataBuffer;
    private int fileSpecifier;
    private String filename;
    private byte[] g;
    private Image image;
    private String[] limit;
    private boolean limitsAreSet = false;
    private float lowerLimit;
    private int numOfColors;
    private byte[] r;
    private JRadioButton radioButton;
    private WritableRaster raster;
    private SurfaceArea sArea = new SurfaceArea();
    private SampleModel sampleModel;
    private FileSpecIF strategy;
    private float upperLimit;
    private float xulCorner;
    private float yulCorner;

    public RasterImage(int fileSpecifier, String filename, int alpha) throws IOException {
        this.strategy = (FileSpecIF)Utils.fileSpecStrategyMap.get(new Integer(fileSpecifier));
        if (fileSpecifier == 101) {
            new SurfaceCodeReader(new File(filename), this.sArea);
        } else {
            new ASCIIFileReader(new File(filename), this.sArea);
        }
        this.fileSpecifier = fileSpecifier;
        this.filename = filename;
        this.lowerLimit = this.sArea.getMinValue();
        this.upperLimit = this.sArea.getMaxValue();
        this.radioButton = new JRadioButton(this.strategy.checkBoxLabel());
        if (fileSpecifier == 100 || fileSpecifier == 102 || fileSpecifier == 101) {
            this.radioButton.setActionCommand(fileSpecifier + filename);
        } else {
            this.radioButton.setActionCommand(filename);
        }
        this.radioButton.setToolTipText(filename);
        this.xulCorner = this.sArea.getXllCorner();
        this.yulCorner = this.sArea.getYulCorner();
        this.image = this.generateBufferedImage(alpha);
    }

    public void changeAlpha(int alpha) {
        this.colorModel = this.generateColorModel(alpha);
        this.image = new BufferedImage(this.colorModel, this.raster, false, null);
    }

    public void changeLimits(float lowerLimit, float upperLimit, int alpha) {
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.image = this.generateBufferedImage(alpha);
    }

    public void deleteLimits() {
        this.lowerLimit = this.sArea.getMinValue();
        this.upperLimit = this.sArea.getMaxValue();
        this.limitsAreSet = false;
    }

    private Image generateBufferedImage(int alpha) {
        this.colorModel = this.generateColorModel(alpha);
        this.dataBuffer = this.generateDataBuffer();
        this.sampleModel = this.generateSampleModel(this.dataBuffer, this.sArea.getNCols(), this.sArea.getNRows());
        this.raster = Raster.createWritableRaster(this.sampleModel, this.dataBuffer, null);
        return new BufferedImage(this.colorModel, this.raster, false, null);
    }

    private ColorModel generateColorModel(int alpha) {
        this.numOfColors = this.strategy.setColorArrays()[0].length;
        this.r = new byte[this.numOfColors];
        this.g = new byte[this.numOfColors];
        this.b = new byte[this.numOfColors];
        this.a = new byte[this.numOfColors];
        int i = 0;
        while (i < this.numOfColors) {
            this.a[i] = (byte)alpha;
            ++i;
        }
        this.r = this.strategy.setColorArrays()[0];
        this.g = this.strategy.setColorArrays()[1];
        this.b = this.strategy.setColorArrays()[2];
        return new IndexColorModel(5, this.numOfColors, this.r, this.g, this.b, this.a);
    }

    private DataBuffer generateDataBuffer() {
        byte[] pixels = new byte[this.sArea.getNRows() * this.sArea.getNCols()];
        pixels = this.strategy.setDataBuffer(this.sArea, this.numOfColors, this.lowerLimit, this.upperLimit);
        this.limit = this.strategy.setLimits(this.numOfColors, this.lowerLimit, this.upperLimit);
        this.dataBuffer = new DataBufferByte(pixels, pixels.length);
        this.dataBuffer = new DataBufferByte(pixels, pixels.length);
        return this.dataBuffer;
    }

    private SampleModel generateSampleModel(DataBuffer dBuffer, int nCols, int nRows) {
        int[] bitMasks = new int[]{31};
        this.sampleModel = new SinglePixelPackedSampleModel(0, nCols, nRows, bitMasks);
        return this.sampleModel;
    }

    public Color getColor(int ind) {
        int red = this.r[ind] >= 0 ? this.r[ind] : this.r[ind] + 256;
        int green = this.g[ind] >= 0 ? this.g[ind] : this.g[ind] + 256;
        int blue = this.b[ind] >= 0 ? this.b[ind] : this.b[ind] + 256;
        Color col = new Color(red, green, blue);
        return col;
    }

    public int getFileSpecifier() {
        return this.fileSpecifier;
    }

    public String getFilename() {
        return this.filename;
    }

    public Image getImage() {
        return this.image;
    }

    public String getLimit(int ind) {
        String lim = this.limit[ind];
        return lim;
    }

    public float getLowerLimit() {
        return this.lowerLimit;
    }

    public int getNumOfColors() {
        return this.numOfColors;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public SurfaceArea getSurfaceArea() {
        return this.sArea;
    }

    public float getUpperLimit() {
        return this.upperLimit;
    }

    public float getXulCorner() {
        return this.xulCorner;
    }

    public float getYulCorner() {
        return this.yulCorner;
    }

    public void limitsAreSet(boolean value) {
        this.limitsAreSet = value;
    }

    public boolean limitsAreSet() {
        return this.limitsAreSet;
    }

    public void regImageKeepLimits(int alpha) {
        this.xulCorner = this.sArea.getXllCorner();
        this.yulCorner = this.sArea.getYulCorner();
        this.image = this.generateBufferedImage(alpha);
    }

    public void regenerateImage(int alpha) {
        this.xulCorner = this.sArea.getXllCorner();
        this.yulCorner = this.sArea.getYulCorner();
        this.lowerLimit = this.sArea.getMinValue();
        this.upperLimit = this.sArea.getMaxValue();
        this.image = this.generateBufferedImage(alpha);
    }

    public void setFilename(String s) {
        this.filename = s;
    }

    public void setSurfaceArea(SurfaceArea sArea) {
        this.sArea = sArea;
    }

    public void setXllCorner(float value) {
        this.xulCorner = value;
    }

    public void setYulCorner(float value) {
        this.yulCorner = value;
    }
}

