/*
 * Decompiled with CFR 0.152.
 */
package ProWin;

import ProWin.C_DataFile;
import ProWin.DataEntry;
import ProWin.DataLine;
import ProWin.DateTimeDataLine;
import ProWin.ErrorFile;
import ProWin.ZValuesDataLine;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Hashtable;

public class ProDataEntry
extends DataEntry
implements C_DataFile,
Cloneable {
    protected static String ModulName = "ProDataEntry";
    protected Hashtable m_DataLines = new Hashtable(7);

    ProDataEntry() {
    }

    public boolean CheckDataValid(int IdCode) {
        DataLine pDataLine = this.GetDataLine(IdCode);
        return pDataLine != null;
    }

    public DataLine GetDataLine(int IdCode) {
        Integer IntIdCode = new Integer(IdCode);
        DataLine dataLine = (DataLine)this.m_DataLines.get(IntIdCode);
        return dataLine;
    }

    public int GetNrOfLayers(int IdCode) {
        DataLine pDataLine = (DataLine)this.m_DataLines.get(new Integer(IdCode));
        if (pDataLine == null) {
            return 0;
        }
        return ((ZValuesDataLine)pDataLine).GetNrOfValues();
    }

    public int GetNrOfSnowLayers() {
        DataLine pDataLine = (DataLine)this.m_DataLines.get(new Integer(501));
        if (pDataLine == null) {
            return 0;
        }
        return ((ZValuesDataLine)pDataLine).GetNrOfSnowValues();
    }

    public int GetNrOfValues(int IdCode) {
        DataLine pDataLine = this.GetDataLine(IdCode);
        if (pDataLine != null) {
            int Value = ((ZValuesDataLine)pDataLine).m_NrOfValues;
            return Value;
        }
        return -999;
    }

    public GregorianCalendar GetTime() {
        DataLine pDataLine = (DataLine)this.m_DataLines.get(new Integer(500));
        if (pDataLine == null) {
            return null;
        }
        return ((DateTimeDataLine)pDataLine).GetTime();
    }

    public int GetTotalNrOfLayers() {
        DataLine pDataLine = (DataLine)this.m_DataLines.get(new Integer(501));
        if (pDataLine == null) {
            return 0;
        }
        int TotalNrOfLayers = ((ZValuesDataLine)pDataLine).GetNrOfValues();
        if (TotalNrOfLayers == this.GetNrOfSnowLayers()) {
            return TotalNrOfLayers;
        }
        return TotalNrOfLayers - 1;
    }

    public float GetZData(int IdCode, int LayerNr) {
        DataLine pDataLine = this.GetDataLine(IdCode);
        if (pDataLine != null) {
            float Value = ((ZValuesDataLine)pDataLine).GetZValue(LayerNr);
            return Value;
        }
        return -999.9f;
    }

    public DataLine ParseDataLine(String Line) throws IOException {
        String ProcName = ModulName + ".ParseDataLine";
        if (Line == null) {
            ErrorFile.write("ERR_PAR_FUNCTION", 1, ProcName);
            return null;
        }
        DataLine pDataLine = null;
        if (Line.length() < 4) {
            ErrorFile.write("ERR_LINE_SYNTAX", 2, ProcName);
            return null;
        }
        try {
            int IdCode = Line.substring(3, 4) == "," ? Integer.parseInt(Line.substring(0, 3)) : Integer.parseInt(Line.substring(0, 4));
            if (IdCode == 500) {
                pDataLine = new DateTimeDataLine();
            } else if (IdCode > 500 && IdCode < 999) {
                pDataLine = new ZValuesDataLine();
            } else {
                ErrorFile.write("ERR_LINE_SYNTAX", 3, ProcName);
                return null;
            }
            if (pDataLine == null) {
                ErrorFile.write("ERR_MEMORY", 4, ProcName);
                return null;
            }
            Integer IntIdCode = new Integer(IdCode);
            if (this.m_DataLines.containsKey(IntIdCode)) {
                ErrorFile.write("ERR_LINE_SYNTAX", 5, ProcName);
                return null;
            }
            if (!pDataLine.ParseLine(Line)) {
                return null;
            }
            this.m_DataLines.put(IntIdCode, pDataLine);
        }
        catch (NumberFormatException e) {
            ErrorFile.write("ERR_LINE_SYNTAX", 7, ProcName);
            return null;
        }
        return pDataLine;
    }

    public boolean SoilDataExist() {
        return this.GetTotalNrOfLayers() != this.GetNrOfSnowLayers();
    }

    public boolean SoilDataExist(int IdCode) {
        if (this.GetTotalNrOfLayers() == this.GetNrOfSnowLayers()) {
            return false;
        }
        if (this.GetNrOfLayers(IdCode) == this.GetNrOfSnowLayers()) {
            return false;
        }
        return this.GetNrOfLayers(IdCode) == this.GetTotalNrOfLayers();
    }

    public DataLine addDataLine(int IdCode, DataLine pDataLine) {
        Integer IntIdCode = new Integer(IdCode);
        if (this.m_DataLines.containsKey(IntIdCode)) {
            return null;
        }
        this.m_DataLines.put(IntIdCode, pDataLine);
        return pDataLine;
    }
}

